/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NMO_H_
#define _SOPRANO_NMO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk {
    namespace Vocabulary {
        namespace NMO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#
             */
            NEPOMUK_EXPORT QUrl nmoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email 
             * 
             * An email. 
             */
            NEPOMUK_EXPORT QUrl Email();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#IMMessage 
             * 
             * A message sent with Instant Messaging software. 
             */
            NEPOMUK_EXPORT QUrl IMMessage();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Mailbox 
             * 
             * A mailbox - container for MailboxDataObjects. 
             */
            NEPOMUK_EXPORT QUrl Mailbox();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MailboxDataObject 
             * 
             * An entity encountered in a mailbox. Most common interpretations 
             * for such an entity include Message or Folder 
             */
            NEPOMUK_EXPORT QUrl MailboxDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Message 
             * 
             * A message. Could be an email, instant messanging message, SMS 
             * message etc. 
             */
            NEPOMUK_EXPORT QUrl Message();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MessageHeader 
             * 
             * An arbitrary message header. 
             */
            NEPOMUK_EXPORT QUrl MessageHeader();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MimeEntity 
             * 
             * A MIME entity, as defined in RFC2045, Section 2.4. 
             */
            NEPOMUK_EXPORT QUrl MimeEntity();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#bcc 
             * 
             * deprecated in favor of nmo:emailBcc 
             */
            NEPOMUK_EXPORT QUrl bcc();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#cc 
             * 
             * deprecated in favor of nmo:emailCc 
             */
            NEPOMUK_EXPORT QUrl cc();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#contentMimeType 
             * 
             * Key used to store the MIME type of the content of an object when 
             * it is different from the object's main MIME type. This value 
             * can be used, for example, to model an e-mail message whose mime 
             * type is"message/rfc822", but whose content has type "text/html". 
             * If not specified, the MIME type of the 
             * content defaults to the value specified by the 'mimeType' property. 
             */
            NEPOMUK_EXPORT QUrl contentMimeType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#emailBcc 
             * 
             * A Contact that is to receive a bcc of the email. A Bcc (blind carbon 
             * copy) is a copy of an email message sent to a recipient whose email 
             * address does not appear in the message. 
             */
            NEPOMUK_EXPORT QUrl emailBcc();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#emailCc 
             * 
             * A Contact that is to receive a cc of the email. A cc (carbon copy) 
             * is a copy of an email message whose recipient appears on the recipient 
             * list, so that all other recipients are aware of it. 
             */
            NEPOMUK_EXPORT QUrl emailCc();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#emailTo 
             * 
             * The primary intended recipient of an email. 
             */
            NEPOMUK_EXPORT QUrl emailTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#from 
             * 
             * deprecated in favor of nmo:messageFrom 
             */
            NEPOMUK_EXPORT QUrl from();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#hasAttachment 
             * 
             * Links a message with files that were sent as attachments. 
             */
            NEPOMUK_EXPORT QUrl hasAttachment();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#headerName 
             * 
             * Name of the message header. 
             */
            NEPOMUK_EXPORT QUrl headerName();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#headerValue 
             * 
             * Value of the message header. 
             */
            NEPOMUK_EXPORT QUrl headerValue();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#htmlMessageContent 
             * 
             * HTML representation of the body of the message. For multipart 
             * messages, all parts are concatenated into the value of this 
             * property. Attachments, whose mimeTypes are different from 
             * text/plain or message/rfc822 are considered separate DataObjects 
             * and are therefore not included in the value of this property. 
             */
            NEPOMUK_EXPORT QUrl htmlMessageContent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#inReplyTo 
             * 
             * Signifies that a message is a reply to another message. This 
             * feature is commonly used to link messages into conversations. 
             * Note that it is more specific than nmo:references. See RFC 2822 
             * sec. 3.6.4 
             */
            NEPOMUK_EXPORT QUrl inReplyTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#isRead 
             * 
             * A flag that states the fact that a MailboxDataObject has been 
             * read. 
             */
            NEPOMUK_EXPORT QUrl isRead();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageFrom 
             * 
             * The sender of the message 
             */
            NEPOMUK_EXPORT QUrl messageFrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageHeader 
             * 
             * Links the message with an arbitrary message header. 
             */
            NEPOMUK_EXPORT QUrl messageHeader();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageId 
             * 
             * An identifier of a message. This property has been inspired 
             * by the message-id property defined in RFC 2822, Sec. 3.6.4. 
             * It should be used for all kinds of identifiers used by various 
             * messaging applications to connect multiple messages into 
             * conversations. For email messageids, values are according 
             * to RFC2822/sec 3.6.4 and the literal value in RDF must include 
             * the brackets. 
             */
            NEPOMUK_EXPORT QUrl messageId();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageRecipient 
             * 
             * A common superproperty for all properties that link a message 
             * with its recipients. Please don't use this property directly. 
             */
            NEPOMUK_EXPORT QUrl messageRecipient();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageReplyTo 
             * 
             * An address where the reply should be sent. 
             */
            NEPOMUK_EXPORT QUrl messageReplyTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageSender 
             * 
             * The person or agent submitting the message to the network, if 
             * other from the one given with the nmo:from property. Defined 
             * in RFC 822 sec. 4.4.2 
             */
            NEPOMUK_EXPORT QUrl messageSender();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#messageSubject 
             * 
             * The subject of a message 
             */
            NEPOMUK_EXPORT QUrl messageSubject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#plainTextMessageContent 
             * 
             * Plain text representation of the body of the message. For multipart 
             * messages, all parts are concatenated into the value of this 
             * property. Attachments, whose mimeTypes are different from 
             * text/plain or message/rfc822 are considered separate DataObjects 
             * and are therefore not included in the value of this property. 
             */
            NEPOMUK_EXPORT QUrl plainTextMessageContent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#primaryMessageRecipient 
             * 
             * The primary intended recipient of a message. 
             */
            NEPOMUK_EXPORT QUrl primaryMessageRecipient();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#primaryRecipient 
             * 
             * deprecated in favor of primaryMessageRecipient 
             */
            NEPOMUK_EXPORT QUrl primaryRecipient();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#receivedDate 
             * 
             * Date when this message was received. 
             */
            NEPOMUK_EXPORT QUrl receivedDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#recipient 
             * 
             * deprecated in favor of nmo:messageRecipient 
             */
            NEPOMUK_EXPORT QUrl recipient();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#references 
             * 
             * Signifies that a message references another message. This 
             * property is a generic one. See RFC 2822 Sec. 3.6.4 
             */
            NEPOMUK_EXPORT QUrl references();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#replyTo 
             * 
             * deprecated in favor of nmo:messageReplyTo 
             */
            NEPOMUK_EXPORT QUrl replyTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#secondaryMessageRecipient 
             * 
             * A superproperty for all "additional" recipients of a message. 
             */
            NEPOMUK_EXPORT QUrl secondaryMessageRecipient();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#secondaryRecipient 
             * 
             * deprecated in favor of nmo:secondaryMessageRecipient 
             */
            NEPOMUK_EXPORT QUrl secondaryRecipient();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#sender 
             * 
             * deprecated in favor of nmo:messageSender 
             */
            NEPOMUK_EXPORT QUrl sender();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#sentDate 
             * 
             * Date when this message was sent. 
             */
            NEPOMUK_EXPORT QUrl sentDate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#to 
             * 
             * deprecated in favor of nmo:emailTo 
             */
            NEPOMUK_EXPORT QUrl to();
        }
    }
}

#endif
