<?php

// We need to add the requires to be able to use this class on its own
require_once(__DIR__.'/../config.php');

// NOTE: This will only work if the plugins are located in the default location!
// We are unable to use the plugin's config.php for this, because it should be a symlink to
// a config file in /etc/kopano (so __DIR__ will give the location of the plugin)
// The only fix would be that the plugins folder should not be configurable
define ('PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH', realpath(__DIR__ . '/../../..'));
require_once(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/init.php');
require_once(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/config.php');
require_once(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/defaults.php');
// The location of the script class.plugin.php has changed, so we will need to check were it is 
if ( file_exists(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/server/includes/core/class.plugin.php') ){
	require_once(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/server/includes/core/class.plugin.php');
} elseif ( file_exists(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/server/core/class.plugin.php') ){
	require_once(PLUGIN_SPELLCHECKER_WEBAPP_BASE_PATH . '/server/core/class.plugin.php');
}

/**
 * The main class for the spellchecker plugin
 */
class PluginSpellchecker extends Plugin {

	/**
	 * Function initializes the Plugin and registers all hooks
	 *
	 * @return void
	 */
	function init() {
		$this->registerHook('server.core.settings.init.before');
	}

	/**
	 * Function is executed when a hook is triggered by the PluginManager
	 *
	 * @param string $eventID the id of the triggered hook
	 * @param mixed $data object(s) related to the hook
	 * @return void
	 */
	function execute($eventID, &$data) {
		switch($eventID) {
			case 'server.core.settings.init.before' :
				$this->injectPluginSettings($data);
				break;
		}
	}

	/**
	 * Called when the core Settings class is initialized and ready to accept sysadmin default
	 * settings. Registers the sysadmin defaults for the pdfbox plugin.
	 * @param Array $data Reference to the data of the triggered hook
	 */
	function injectPluginSettings(&$data) {
		$data['settingsObj']->addSysAdminDefaults(Array(
			'zarafa' => Array(
				'v1' => Array(
					'plugins' => Array(
						'spellchecker' => Array(
							'enable' => PLUGIN_SPELLCHECKER_USER_DEFAULT_ENABLE,
							'spellchecker_languages' => PLUGIN_SPELLCHECKER_SELECTED_LANGUAGES,
							'spellchecker_language' => ''
						)
					)
				)
			)
		));
	}
	
	/**
	 * Returns a string with the directories where dictionaries can be found
	 * @return String a colon separated string with directories
	 */
	function getDictionaryDirectories(){
		$dirs = Array(realpath(__DIR__ . '/../dicts'));
		
		$dirs = array_merge($dirs, $this->includeLanguagePacks());
		
		return implode(':', $dirs);
	}
	
	/**
	 * Includes the languagepacks, so we can use them to get dictionary directories
	 */
	function includeLanguagePacks(){
		$dirs = Array();
		
		$pluginsDir = realpath(__DIR__ . '/../..');
		$handle = opendir($pluginsDir);
		while ( $name = readdir($handle) ){
			if ( preg_match('/^spellchecker\-languagepack(\-[^\-]*)*$/', $name) ){
				preg_match_all('/(?:^|\-)([^\-]*)/', $name, $matches);
				$className = '';
				for ( $i=0; $i<count($matches[1]); $i++ ){
					$className .= ucfirst($matches[1][$i]);
				}
				include_once($pluginsDir . '/' .$name . '/php/plugin.' . $className . '.php');
				$className = 'Plugin' . $className;
				$p = new $className();
				$dirs[] = $p->getDictionaryDirectories();
			}
		}
		
		return $dirs;
	}
}
