/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.gstreamer;

import com.sun.media.jfxmedia.effects.AudioSpectrum;

public final class GSTAudioSpectrum
implements AudioSpectrum {
    private static float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final int DEFAULT_THRESHOLD = -60;
    public static final int DEFAULT_BANDS = 128;
    public static final double DEFAULT_INTERVAL = 0.1;
    private long refMedia;
    private float[] magnitudes = EMPTY_FLOAT_ARRAY;
    private float[] phases = EMPTY_FLOAT_ARRAY;

    GSTAudioSpectrum(long refMedia) {
        if (refMedia == 0L) {
            throw new IllegalArgumentException("Invalid native media reference");
        }
        this.refMedia = refMedia;
        this.setBandCount(128);
    }

    public boolean getEnabled() {
        return this.gstGetEnabled(this.refMedia);
    }

    public void setEnabled(boolean enabled) {
        this.gstSetEnabled(this.refMedia, enabled);
    }

    public int getBandCount() {
        return this.phases.length;
    }

    public void setBandCount(int bands) {
        if (bands > 1) {
            this.magnitudes = new float[bands];
            for (int i = 0; i < this.magnitudes.length; ++i) {
                this.magnitudes[i] = Float.NEGATIVE_INFINITY;
            }
        } else {
            this.magnitudes = EMPTY_FLOAT_ARRAY;
            this.phases = EMPTY_FLOAT_ARRAY;
            throw new IllegalArgumentException("Number of bands must at least be 2");
        }
        this.phases = new float[bands];
        this.gstSetBands(this.refMedia, bands, this.magnitudes, this.phases);
    }

    public double getInterval() {
        return this.gstGetInterval(this.refMedia);
    }

    public void setInterval(double interval) {
        if (!(interval * 1.0E9 >= 1.0)) {
            throw new IllegalArgumentException("Interval can't be less that 1 nanosecond");
        }
        this.gstSetInterval(this.refMedia, interval);
    }

    public int getSensitivityThreshold() {
        return this.gstGetThreshold(this.refMedia);
    }

    public void setSensitivityThreshold(int threshold) {
        if (threshold > 0) {
            throw new IllegalArgumentException(String.format("Sensitivity threshold must be less than 0: %d", threshold));
        }
        this.gstSetThreshold(this.refMedia, threshold);
    }

    public float[] getMagnitudes() {
        return (float[])this.magnitudes.clone();
    }

    public float[] getPhases() {
        return (float[])this.phases.clone();
    }

    private native boolean gstGetEnabled(long var1);

    private native void gstSetEnabled(long var1, boolean var3);

    private native void gstSetBands(long var1, int var3, float[] var4, float[] var5);

    private native double gstGetInterval(long var1);

    private native void gstSetInterval(long var1, double var3);

    private native int gstGetThreshold(long var1);

    private native void gstSetThreshold(long var1, int var3);
}

