/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class FifotrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$$").number("d+,").number("(d+),").number("x+,").expression("[^,]+,").number("(d+)?,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("([AV]),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("d+,").number("(xxxx),").number("(x+)?,").number("(x+)?,").number("(d+)|").number("(d+)|").number("(x+)|").number("(x+),").number("([x|]+)").expression(",([^,]+)").expression(",([^*]+)").optional(2).any().compile();

    public FifotrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("alarm", parser.next());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
        position.setCourse(parser.nextInt(0));
        position.setAltitude(parser.nextInt(0));
        position.set("odometer", parser.nextLong(0L));
        position.set("status", parser.nextHexInt(0));
        if (parser.hasNext()) {
            position.set("input", parser.nextHexInt(0));
        }
        if (parser.hasNext()) {
            position.set("output", parser.nextHexInt(0));
        }
        position.setNetwork(new Network(CellTower.from(parser.nextInt(0), parser.nextInt(0), parser.nextHexInt(0), parser.nextHexInt(0))));
        String[] adc = parser.next().split("\\|");
        for (int i = 0; i < adc.length; ++i) {
            position.set("adc" + (i + 1), Integer.parseInt(adc[i], 16));
        }
        position.set("driverUniqueId", parser.next());
        if (parser.hasNext()) {
            String[] sensors = parser.next().split("\\|");
            for (int i = 0; i < sensors.length; ++i) {
                position.set("io" + (i + 1), sensors[i]);
            }
        }
        return position;
    }
}

