/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.ChannelHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.traccar.BaseDataHandler;
import org.traccar.Context;
import org.traccar.helper.DistanceCalculator;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class DistanceHandler
extends BaseDataHandler {
    private final boolean filter;
    private final int coordinatesMinError;
    private final int coordinatesMaxError;

    public DistanceHandler(boolean filter, int coordinatesMinError, int coordinatesMaxError) {
        this.filter = filter;
        this.coordinatesMinError = coordinatesMinError;
        this.coordinatesMaxError = coordinatesMaxError;
    }

    private Position getLastPosition(long deviceId) {
        if (Context.getIdentityManager() != null) {
            return Context.getIdentityManager().getLastPosition(deviceId);
        }
        return null;
    }

    @Override
    protected Position handlePosition(Position position) {
        double distance = 0.0;
        if (position.getAttributes().containsKey("distance")) {
            distance = position.getDouble("distance");
        }
        double totalDistance = 0.0;
        Position last = this.getLastPosition(position.getDeviceId());
        if (last != null) {
            totalDistance = last.getDouble("totalDistance");
            if (!position.getAttributes().containsKey("distance")) {
                distance = DistanceCalculator.distance(position.getLatitude(), position.getLongitude(), last.getLatitude(), last.getLongitude());
                distance = BigDecimal.valueOf(distance).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
            }
            if (this.filter && last.getValid() && last.getLatitude() != 0.0 && last.getLongitude() != 0.0) {
                boolean satisfiesMax;
                boolean satisfiesMin = this.coordinatesMinError == 0 || distance > (double)this.coordinatesMinError;
                boolean bl = satisfiesMax = this.coordinatesMaxError == 0 || distance < (double)this.coordinatesMaxError || position.getValid();
                if (!satisfiesMin || !satisfiesMax) {
                    position.setLatitude(last.getLatitude());
                    position.setLongitude(last.getLongitude());
                    distance = 0.0;
                }
            }
        }
        position.set("distance", distance);
        totalDistance = BigDecimal.valueOf(totalDistance + distance).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        position.set("totalDistance", totalDistance);
        return position;
    }
}

