/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.DistributingUpdateProcessorFactory;
import org.apache.solr.update.processor.TimeRoutedAliasUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class DistributedUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements DistributingUpdateProcessorFactory {
    public static void addParamToDistributedRequestWhitelist(SolrQueryRequest req, String ... paramNames) {
        Set whitelist = (Set)req.getContext().computeIfAbsent(DistributedUpdateProcessor.PARAM_WHITELIST_CTX_KEY, key -> new TreeSet());
        Collections.addAll(whitelist, paramNames);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return TimeRoutedAliasUpdateProcessor.wrap(req, new DistributedUpdateProcessor(req, rsp, next));
    }
}

