/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.DefaultStreamFactory;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private StreamFactory streamFactory = new DefaultStreamFactory();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String coreName;

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void inform(SolrCore core) {
        Object functionMappingsObj;
        CoreContainer coreContainer = core.getCoreContainer();
        this.coreName = core.getName();
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
        }
        if (null != (functionMappingsObj = this.initArgs.get("streamFunctions"))) {
            NamedList functionMappings = (NamedList)functionMappingsObj;
            for (Map.Entry functionMapping : functionMappings) {
                Class<Expressible> clazz = core.getResourceLoader().findClass((String)functionMapping.getValue(), Expressible.class);
                this.streamFactory.withFunctionName((String)functionMapping.getKey(), clazz);
            }
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        TupleStream tupleStream = null;
        try {
            tupleStream = this.streamFactory.constructStream(params.get("expr"));
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
            Map<Object, Object> requestContext = req.getContext();
            requestContext.put("stream", (Object)new DummyErrorStream(e));
            return;
        }
        StreamContext context = new StreamContext();
        context.setSolrClientCache(StreamHandler.clientCache);
        context.put((Object)"core", (Object)this.coreName);
        Traversal traversal = new Traversal();
        context.put((Object)"traversal", (Object)traversal);
        tupleStream.setStreamContext(context);
        Map<Object, Object> requestContext = req.getContext();
        requestContext.put("stream", (Object)new TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        requestContext.put("traversal", traversal);
    }

    @Override
    public String getDescription() {
        return "StreamHandler";
    }

    public String getSource() {
        return null;
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    public static class TimerStream
    extends TupleStream {
        private long begin;
        private TupleStream tupleStream;

        public TimerStream(TupleStream tupleStream) {
            this.tupleStream = tupleStream;
        }

        public StreamComparator getStreamSort() {
            return this.tupleStream.getStreamSort();
        }

        public void close() throws IOException {
            this.tupleStream.close();
        }

        public void open() throws IOException {
            this.begin = System.nanoTime();
            this.tupleStream.open();
        }

        public void setStreamContext(StreamContext context) {
            this.tupleStream.setStreamContext(context);
        }

        public List<TupleStream> children() {
            return this.tupleStream.children();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return null;
        }

        public Tuple read() throws IOException {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                long totalTime = (System.nanoTime() - this.begin) / 1000000L;
                tuple.fields.put("RESPONSE_TIME", totalTime);
            }
            return tuple;
        }
    }

    public static class DummyErrorStream
    extends TupleStream {
        private Exception e;

        public DummyErrorStream(Exception e) {
            this.e = e;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public Exception getException() {
            return this.e;
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return null;
        }

        public Tuple read() {
            String msg = this.e.getMessage();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("EOF", true);
            m.put("EXCEPTION", msg);
            return new Tuple(m);
        }
    }
}

