/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(-15l) => -1l
 * sign(-7l) => -1l
 * sign(0l) => 0l
 * sign(7l) => 1l
 * sign(15l) => 1l
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[sign(-15l) == -1l ? 1 : -1] array0;
  float[sign(-7l) == -1l ? 1 : -1] array1;
  float[sign(0l) == 0l ? 1 : -1] array2;
  float[sign(7l) == 1l ? 1 : -1] array3;
  float[sign(15l) == 1l ? 1 : -1] array4;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
