/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.charts.AxisPosition;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ChartAxisFactory;
import org.apache.poi.ss.usermodel.charts.ChartData;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Removal;
import org.apache.poi.xssf.usermodel.XSSFGraphicFrame;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.charts.XSSFCategoryAxis;
import org.apache.poi.xssf.usermodel.charts.XSSFChartAxis;
import org.apache.poi.xssf.usermodel.charts.XSSFChartDataFactory;
import org.apache.poi.xssf.usermodel.charts.XSSFChartLegend;
import org.apache.poi.xssf.usermodel.charts.XSSFDateAxis;
import org.apache.poi.xssf.usermodel.charts.XSSFManualLayout;
import org.apache.poi.xssf.usermodel.charts.XSSFValueAxis;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChartSpace;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDateAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPageMargins;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPrintSettings;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTitle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.ChartSpaceDocument;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XSSFChart
extends POIXMLDocumentPart
implements Chart,
ChartAxisFactory {
    private XSSFGraphicFrame frame;
    private CTChartSpace chartSpace;
    private CTChart chart;
    List<XSSFChartAxis> axis = new ArrayList<XSSFChartAxis>();

    protected XSSFChart() {
        this.createChart();
    }

    protected XSSFChart(PackagePart part) throws IOException, XmlException {
        super(part);
        this.chartSpace = ChartSpaceDocument.Factory.parse(part.getInputStream(), POIXMLTypeLoader.DEFAULT_XML_OPTIONS).getChartSpace();
        this.chart = this.chartSpace.getChart();
    }

    private void createChart() {
        this.chartSpace = CTChartSpace.Factory.newInstance();
        this.chart = this.chartSpace.addNewChart();
        CTPlotArea plotArea = this.chart.addNewPlotArea();
        plotArea.addNewLayout();
        this.chart.addNewPlotVisOnly().setVal(true);
        CTPrintSettings printSettings = this.chartSpace.addNewPrintSettings();
        printSettings.addNewHeaderFooter();
        CTPageMargins pageMargins = printSettings.addNewPageMargins();
        pageMargins.setB(0.75);
        pageMargins.setL(0.7);
        pageMargins.setR(0.7);
        pageMargins.setT(0.75);
        pageMargins.setHeader(0.3);
        pageMargins.setFooter(0.3);
        printSettings.addNewPageSetup();
    }

    @Internal
    public CTChartSpace getCTChartSpace() {
        return this.chartSpace;
    }

    @Internal
    public CTChart getCTChart() {
        return this.chart;
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTChartSpace.type.getName().getNamespaceURI(), "chartSpace", "c"));
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.chartSpace.save(out, xmlOptions);
        out.close();
    }

    public XSSFGraphicFrame getGraphicFrame() {
        return this.frame;
    }

    protected void setGraphicFrame(XSSFGraphicFrame frame) {
        this.frame = frame;
    }

    @Override
    public XSSFChartDataFactory getChartDataFactory() {
        return XSSFChartDataFactory.getInstance();
    }

    @Override
    public XSSFChart getChartAxisFactory() {
        return this;
    }

    @Override
    public void plot(ChartData data, ChartAxis ... chartAxis) {
        data.fillChart(this, chartAxis);
    }

    @Override
    public XSSFValueAxis createValueAxis(AxisPosition pos) {
        long id = this.axis.size() + 1;
        XSSFValueAxis valueAxis = new XSSFValueAxis(this, id, pos);
        if (this.axis.size() == 1) {
            ChartAxis ax = this.axis.get(0);
            ax.crossAxis(valueAxis);
            valueAxis.crossAxis(ax);
        }
        this.axis.add(valueAxis);
        return valueAxis;
    }

    @Override
    public XSSFCategoryAxis createCategoryAxis(AxisPosition pos) {
        long id = this.axis.size() + 1;
        XSSFCategoryAxis categoryAxis = new XSSFCategoryAxis(this, id, pos);
        if (this.axis.size() == 1) {
            ChartAxis ax = this.axis.get(0);
            ax.crossAxis(categoryAxis);
            categoryAxis.crossAxis(ax);
        }
        this.axis.add(categoryAxis);
        return categoryAxis;
    }

    @Override
    public XSSFDateAxis createDateAxis(AxisPosition pos) {
        long id = this.axis.size() + 1;
        XSSFDateAxis dateAxis = new XSSFDateAxis(this, id, pos);
        if (this.axis.size() == 1) {
            ChartAxis ax = this.axis.get(0);
            ax.crossAxis(dateAxis);
            dateAxis.crossAxis(ax);
        }
        this.axis.add(dateAxis);
        return dateAxis;
    }

    public List<? extends XSSFChartAxis> getAxis() {
        if (this.axis.isEmpty() && this.hasAxis()) {
            this.parseAxis();
        }
        return this.axis;
    }

    @Override
    public XSSFManualLayout getManualLayout() {
        return new XSSFManualLayout(this);
    }

    public boolean isPlotOnlyVisibleCells() {
        return this.chart.getPlotVisOnly().getVal();
    }

    public void setPlotOnlyVisibleCells(boolean plotVisOnly) {
        this.chart.getPlotVisOnly().setVal(plotVisOnly);
    }

    @Deprecated
    @Removal(version="4.0")
    public XSSFRichTextString getTitle() {
        return this.getTitleText();
    }

    public XSSFRichTextString getTitleText() {
        if (!this.chart.isSetTitle()) {
            return null;
        }
        CTTitle title = this.chart.getTitle();
        StringBuffer text = new StringBuffer();
        XmlObject[] t = title.selectPath("declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//a:t");
        for (int m = 0; m < t.length; ++m) {
            NodeList kids = t[m].getDomNode().getChildNodes();
            int count = kids.getLength();
            for (int n = 0; n < count; ++n) {
                Node kid = kids.item(n);
                if (!(kid instanceof Text)) continue;
                text.append(kid.getNodeValue());
            }
        }
        return new XSSFRichTextString(text.toString());
    }

    @Deprecated
    @Removal(version="4.0")
    public void setTitle(String newTitle) {
    }

    public void setTitleText(String newTitle) {
        CTTextBody rich;
        CTTitle ctTitle = this.chart.isSetTitle() ? this.chart.getTitle() : this.chart.addNewTitle();
        CTTx tx = ctTitle.isSetTx() ? ctTitle.getTx() : ctTitle.addNewTx();
        if (tx.isSetStrRef()) {
            tx.unsetStrRef();
        }
        if (tx.isSetRich()) {
            rich = tx.getRich();
        } else {
            rich = tx.addNewRich();
            rich.addNewBodyPr();
        }
        CTTextParagraph para = rich.sizeOfPArray() > 0 ? rich.getPArray(0) : rich.addNewP();
        if (para.sizeOfRArray() > 0) {
            CTRegularTextRun run = para.getRArray(0);
            run.setT(newTitle);
        } else if (para.sizeOfFldArray() > 0) {
            CTTextField fld = para.getFldArray(0);
            fld.setT(newTitle);
        } else {
            CTRegularTextRun run = para.addNewR();
            run.setT(newTitle);
        }
    }

    public String getTitleFormula() {
        if (!this.chart.isSetTitle()) {
            return null;
        }
        CTTitle title = this.chart.getTitle();
        if (!title.isSetTx()) {
            return null;
        }
        CTTx tx = title.getTx();
        if (!tx.isSetStrRef()) {
            return null;
        }
        return tx.getStrRef().getF();
    }

    public void setTitleFormula(String formula) {
        CTTitle ctTitle = this.chart.isSetTitle() ? this.chart.getTitle() : this.chart.addNewTitle();
        CTTx tx = ctTitle.isSetTx() ? ctTitle.getTx() : ctTitle.addNewTx();
        if (tx.isSetRich()) {
            tx.unsetRich();
        }
        CTStrRef strRef = tx.isSetStrRef() ? tx.getStrRef() : tx.addNewStrRef();
        strRef.setF(formula);
    }

    @Override
    public XSSFChartLegend getOrCreateLegend() {
        return new XSSFChartLegend(this);
    }

    @Override
    public void deleteLegend() {
        if (this.chart.isSetLegend()) {
            this.chart.unsetLegend();
        }
    }

    private boolean hasAxis() {
        CTPlotArea ctPlotArea = this.chart.getPlotArea();
        int totalAxisCount = ctPlotArea.sizeOfValAxArray() + ctPlotArea.sizeOfCatAxArray() + ctPlotArea.sizeOfDateAxArray() + ctPlotArea.sizeOfSerAxArray();
        return totalAxisCount > 0;
    }

    private void parseAxis() {
        this.parseCategoryAxis();
        this.parseDateAxis();
        this.parseValueAxis();
    }

    private void parseCategoryAxis() {
        for (CTCatAx catAx : this.chart.getPlotArea().getCatAxArray()) {
            this.axis.add(new XSSFCategoryAxis(this, catAx));
        }
    }

    private void parseDateAxis() {
        for (CTDateAx dateAx : this.chart.getPlotArea().getDateAxArray()) {
            this.axis.add(new XSSFDateAxis(this, dateAx));
        }
    }

    private void parseValueAxis() {
        for (CTValAx valAx : this.chart.getPlotArea().getValAxArray()) {
            this.axis.add(new XSSFValueAxis(this, valAx));
        }
    }
}

