/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import org.hibernate.annotations.Filter;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@Table(indexes={@Index(name="changeDateIndex", columnList="changeDate")})
public class Config {
    private Set<ConfigAttribute> attributes = new HashSet<ConfigAttribute>();
    private String author = "";
    protected Date changeDate;
    private int version;
    protected Device device;
    protected long id;

    public Config() {
    }

    public Config(Device device) {
        this.device = device;
    }

    public void addAttribute(ConfigAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    @XmlElement
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="config", orphanRemoval=true)
    @Filter(name="lightAttributesOnly")
    public Set<ConfigAttribute> getAttributes() {
        return this.attributes;
    }

    @Transient
    public Map<String, ConfigAttribute> getAttributeMap() {
        HashMap<String, ConfigAttribute> map = new HashMap<String, ConfigAttribute>();
        for (ConfigAttribute a : this.attributes) {
            map.put(a.getName(), a);
        }
        return map;
    }

    @XmlElement
    public String getAuthor() {
        return this.author;
    }

    @XmlElement
    public Date getChangeDate() {
        return this.changeDate;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Device getDevice() {
        return this.device;
    }

    @XmlElement
    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    public void setAttributes(Set<ConfigAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setId(long id) {
        this.id = id;
    }
}

