/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

class CombinedMultiPropertiesConfig
extends MultiPropertiesConfig {
    MultiPropertiesConfig[] configs;
    String[] resourcePaths;

    CombinedMultiPropertiesConfig(MultiPropertiesConfig[] configs) {
        this.configs = configs;
        LinkedList<String> allPaths = new LinkedList<String>();
        for (int i = configs.length - 1; i >= 0; --i) {
            String[] rps = configs[i].getPropertiesResourcePaths();
            for (int j = rps.length - 1; j >= 0; --j) {
                String rp = rps[j];
                if (allPaths.contains(rp)) continue;
                allPaths.add(0, rp);
            }
        }
        this.resourcePaths = allPaths.toArray(new String[allPaths.size()]);
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.resourcePaths.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        for (int i = this.configs.length - 1; i >= 0; --i) {
            MultiPropertiesConfig config = this.configs[i];
            Properties check = config.getPropertiesByResourcePath(path);
            if (check == null) continue;
            return check;
        }
        return null;
    }

    public Properties getPropertiesByPrefix(String pfx) {
        LinkedList<Map.Entry<Object, Object>> entries = new LinkedList<Map.Entry<Object, Object>>();
        for (int i = this.configs.length - 1; i >= 0; --i) {
            MultiPropertiesConfig config = this.configs[i];
            Properties check = config.getPropertiesByPrefix(pfx);
            if (check == null) continue;
            entries.addAll(0, check.entrySet());
        }
        if (entries.size() == 0) {
            return null;
        }
        Properties out = new Properties();
        Iterator ii = entries.iterator();
        while (ii.hasNext()) {
            Map.Entry entry = (Map.Entry)ii.next();
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public String getProperty(String key) {
        for (int i = this.configs.length - 1; i >= 0; --i) {
            MultiPropertiesConfig config = this.configs[i];
            String check = config.getProperty(key);
            if (check == null) continue;
            return check;
        }
        return null;
    }
}

