/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, handler)
 * @param {Object} target
 * @param {Object} handler
 */
function Proxy(target, handler) {
}
/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { defineProperty: function(target, property, descriptor) { } })
 * @param {Object} target
 * @param {String} property
 * @param {String} descriptor
 * @returns {Boolean}
 * @static
 */
Proxy.defineProperty = function(target, property, descriptor) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { set: function(target, property, value, receiver) { } })
 * @param {Object} target
 * @param {String} property
 * @param {String} value
 * @param {Object} receiver
 * @returns {Boolean}
 * @static
 */
Proxy.set = function(target, property, value, receiver) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { preventExtensions: function(target) { } })
 * @param {Object} target
 * @returns {Boolean}
 * @static
 */
Proxy.preventExtensions = function(target) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { deleteProperty: function(target, property) { } })
 * @param {Object} target
 * @param {String} property
 * @returns {Boolean}
 * @static
 */
Proxy.deleteProperty = function(target, property) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { get: function(target, property, receiver) { } })
 * @param {Object} target
 * @param {String} prop
 * @param {Object} receiver
 * @returns {Object}
 * @static
 */
Proxy.get = function(target, property, receiver) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { construct: function(target, argumentsList, newTarget) { } })
 * @param {Object} target
 * @param {String} argumentsList
 * @param {String} newTarget
 * @returns {Object}
 * @static
 */
Proxy.construct = function(target, argumentsList, newTarget) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { getOwnPropertyDescriptor: function(target, prop) { } })
 * @param {Object} target
 * @param {String} prop
 * @returns {Object}
 * @static
 */
Proxy.getOwnPropertyDescriptor = function(target, prop) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { apply: function(target, thisArg, argumentsList) { } })
 * @param {Object} target
 * @param {String} thisArg
 * @param {String} argumentsList
 * @returns {Object}
 * @static
 */
Proxy.apply = function(target, thisArg, argumentsList) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { setPrototypeOf: function(target, prototype) { } })
 * @param {Object} target
 * @param {Object} prototype
 * @returns {Boolean}
 * @static
 */
Proxy.setPrototypeOf = function(target, prototype) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { has: function(target, prop) { } })
 * @param {Object} target
 * @param {String} prop
 * @returns {Boolean}
 * @static
 */
Proxy.has = function(target, prop) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { ownKeys: function(target) { } })
 * @param {Object} target
 * @returns {Array}
 * @static
 */
Proxy.ownKeys = function(target) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(obj, { getPrototypeOf(target) {   ... } })
 * @param {Object} target
 * @returns {Object}
 * @static
 */
Proxy.getPrototypeOf = function(target) {};

/**
 * @since ECMAScript6
 * @syntax var p = new Proxy(target, { isExtensible: function(target) { } })
 * @param {Object} target
 * @returns {Boolean}
 * @static
 */
Proxy.isExtensible = function(target) {};

/**
 * Represents the Proxy prototype object.
 * @syntax Proxy.prototype
 * @static
 */
Proxy.prototype;

