/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.history.BranchSelector;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.DiffResultsView;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.ui.history.SearchExecutor;
import org.netbeans.modules.git.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.git.ui.history.SummaryView;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.history.LinkButton;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
DocumentListener,
ActionListener {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private Action searchAction;
    private SearchExecutor currentSearch;
    private Search currentAdditionalSearch;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List<RepositoryRevision> results;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private final File repository;
    private static final Icon ICON_COLLAPSED = UIManager.getIcon("Tree.collapsedIcon");
    private static final Icon ICON_EXPANDED = UIManager.getIcon("Tree.expandedIcon");
    private int showingResults;
    private Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap;
    private List<SummaryView.GitLogEntry> logEntries;
    private boolean selectFirstRevision;
    private SearchHistoryTopComponent.DiffResultsViewFactory diffViewFactory;
    private boolean searchStarted;
    private String currentBranch;
    private Object currentBranchFilter = ALL_BRANCHES_FILTER;
    private final RepositoryInfo info;
    private static final String ALL_BRANCHES_FILTER = Bundle.SearchHistoryPanel_filter_allbranches();
    private final PropertyChangeListener list;
    private final Timer filterTimer;
    private ExplorerManager explorerManager;
    final JButton bNext = new JButton();
    final JButton bPrev = new JButton();
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    private JComboBox cmbBranch;
    private JComboBox cmbFilterKind;
    private LinkButton expandCriteriaButton;
    final JCheckBox fileInfoCheckBox = new JCheckBox();
    private JToolBar.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar jToolBar1;
    private JLabel lblBranch;
    private JLabel lblFilter;
    private JLabel lblFilterContains;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;
    private JTextField txtFilter;

    public SearchHistoryPanel(File repository, RepositoryInfo info, File[] roots, SearchCriteriaPanel criteria) {
        this.roots = roots;
        this.repository = repository;
        this.info = info;
        this.criteria = criteria;
        this.diffViewFactory = new SearchHistoryTopComponent.DiffResultsViewFactory();
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.initializeFilter();
        this.filterTimer = new Timer(500, this);
        this.filterTimer.setRepeats(false);
        this.filterTimer.stop();
        this.setupComponents();
        this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info);
        info.addPropertyChangeListener(this.list);
        this.aquaBackgroundWorkaround();
        this.refreshComponents(true);
    }

    private void aquaBackgroundWorkaround() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.jToolBar1.setBackground(color);
            this.resultsPanel.setBackground(color);
            this.searchCriteriaPanel.setBackground(color);
            this.searchCriteriaPanel.setBackground(color);
            this.criteria.setBackground(color);
        }
    }

    public void disableFileChangesOption(boolean b) {
        this.fileInfoCheckBox.setEnabled(false);
        this.fileInfoCheckBox.setSelected(false);
    }

    boolean isShowInfo() {
        return this.fileInfoCheckBox.isSelected();
    }

    void setBranch(String branch) {
        this.currentBranch = branch;
    }

    void setSearchCriteria(boolean b) {
        this.criteriaVisible = b;
        this.refreshComponents(false);
    }

    private void enableFilters(boolean enabled) {
        this.lblFilter.setEnabled(enabled);
        this.cmbFilterKind.setEnabled(enabled);
        this.lblFilterContains.setEnabled(enabled);
        this.txtFilter.setEnabled(enabled);
    }

    private void setupComponents() {
        this.searchCriteriaPanel.add(this.criteria);
        this.searchAction = new AbstractAction(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_Search"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.executeSearch();
            }
        };
        this.searchCriteriaPanel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.searchCriteriaPanel.getActionMap().put("search", this.searchAction);
        this.bSearch.setAction(this.searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension d1 = this.tbSummary.getPreferredSize();
        Dimension d2 = this.tbDiff.getPreferredSize();
        if (d1.width > d2.width) {
            this.tbDiff.setPreferredSize(d1);
        }
        this.nextAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/git/resources/icons/diff-next.png", (boolean)false)){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/git/resources/icons/diff-prev.png", (boolean)false)){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.criteria.tfFrom.getDocument().addDocumentListener(this);
        this.criteria.tfTo.getDocument().addDocumentListener(this);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
        this.fileInfoCheckBox.setSelected(GitModuleConfig.getDefault().getShowFileInfo());
        this.criteria.btnSelectBranch.addActionListener(this);
        this.cmbBranch.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof GitBranch) {
                    value = ((GitBranch)value).getName();
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.refreshBranchFilterModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        } else if ("prop.branches".equals(evt.getPropertyName())) {
            this.refreshBranchFilterModel();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean refreshResults) {
        if (refreshResults) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (!this.searchStarted) {
                    this.resultsPanel.add((Component)new NoContentPanel(Bundle.LBL_SearchHistory_NoSearchYet()));
                } else if (this.searchInProgress) {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    String errMessage = this.currentSearch.getErrorMessage();
                    this.resultsPanel.add((Component)new NoContentPanel(errMessage == null ? NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults") : errMessage));
                }
            } else if (this.tbSummary.isSelected()) {
                if (this.summaryView == null) {
                    this.logEntries = this.createLogEntries(this.results);
                    this.summaryView = new SummaryView(this, this.logEntries, this.kenaiUserMap);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
                this.summaryView.requestFocusInWindow();
            } else {
                if (this.diffView == null) {
                    this.diffView = this.diffViewFactory.createDiffResultsView(this, this.filter(this.results));
                }
                this.resultsPanel.add(this.diffView.getComponent());
                if (this.selectFirstRevision) {
                    this.selectFirstRevision();
                }
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.updateActions();
        this.fileInfoCheckBox.setEnabled(this.tbSummary.isSelected());
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.expandCriteriaButton.setIcon(this.criteriaVisible ? ICON_EXPANDED : ICON_COLLAPSED);
        if (this.criteria.getLimit() <= 0) {
            this.criteria.setLimit(-1);
        }
        this.enableFilters(this.results != null);
        this.revalidate();
        this.repaint();
    }

    private void selectFirstRevision() {
        if (this.diffView != null && this.results != null && !this.results.isEmpty()) {
            this.diffView.select(this.results.get(0));
        }
    }

    final void updateActions() {
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
    }

    void setResults(List<RepositoryRevision> newResults, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap, int limit) {
        this.setResults(newResults, kenaiUserMap, false, limit);
    }

    private void setResults(List<RepositoryRevision> newResults, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap, boolean searching, int limit) {
        this.results = newResults;
        this.kenaiUserMap = kenaiUserMap;
        this.searchInProgress = searching;
        this.showingResults = limit;
        if (newResults != null && newResults.size() < limit) {
            this.showingResults = -1;
        }
        this.summaryView = null;
        this.releaseDiff();
        this.diffView = null;
        this.refreshComponents(true);
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    void executeSearch() {
        this.searchStarted = true;
        this.cancelBackgroundTasks();
        this.setResults(null, null, true, -1);
        GitModuleConfig.getDefault().setShowHistoryMerges(this.criteria.isIncludeMerges());
        if (this.currentBranch != null) {
            GitModuleConfig.getDefault().setSearchOnlyCurrentBranchEnabled(this.criteria.getBranch() != null);
        }
        this.updateBranchFilter(this.criteria.getBranch());
        try {
            this.currentSearch = new SearchExecutor(this);
            this.currentSearch.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress", (Object)this.repository));
        }
        catch (IllegalArgumentException ex) {
            GitClientExceptionHandler.annotate(ex.getLocalizedMessage());
        }
    }

    void cancelBackgroundTasks() {
        if (this.currentSearch != null) {
            this.currentSearch.cancel();
        }
        if (this.currentAdditionalSearch != null) {
            this.currentAdditionalSearch.cancel();
        }
    }

    void showDiff(RepositoryRevision.Event ... events) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(events);
    }

    public void showDiff(RepositoryRevision container) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(container);
    }

    public static int compareRevisions(String r1, String r2) {
        int n2;
        int n1;
        StringTokenizer st1 = new StringTokenizer(r1, ".");
        StringTokenizer st2 = new StringTokenizer(r2, ".");
        do {
            if (!st1.hasMoreTokens()) {
                return st2.hasMoreTokens() ? -1 : 0;
            }
            if (st2.hasMoreTokens()) continue;
            return st1.hasMoreTokens() ? 1 : 0;
        } while ((n1 = Integer.parseInt(st1.nextToken())) == (n2 = Integer.parseInt(st2.nextToken())));
        return n2 - n1;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.bSearch = new JButton();
        this.searchCriteriaPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JToolBar.Separator();
        this.jSeparator4 = new JToolBar.Separator();
        this.lblBranch = new JLabel();
        this.cmbBranch = new JComboBox();
        this.jSeparator1 = new JToolBar.Separator();
        this.lblFilter = new JLabel();
        this.cmbFilterKind = new JComboBox();
        this.lblFilterContains = new JLabel();
        this.txtFilter = new JTextField();
        this.resultsPanel = new JPanel();
        this.expandCriteriaButton = new LinkButton();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/ui/history/Bundle");
        this.bSearch.setToolTipText(bundle.getString("TT_Search"));
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        this.jToolBar1.setLayout(new BoxLayout(this.jToolBar1, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)bundle.getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(bundle.getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)bundle.getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(bundle.getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/git/resources/icons/diff-next.png", (boolean)false));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_NextDifference"));
        this.bNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_NextDifference"));
        this.bPrev.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/git/resources/icons/diff-prev.png", (boolean)false));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_PrevDifference"));
        this.bPrev.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_PrevDifference"));
        this.jToolBar1.add(this.jSeparator3);
        Mnemonics.setLocalizedText((AbstractButton)this.fileInfoCheckBox, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_TT_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setHorizontalTextPosition(4);
        this.fileInfoCheckBox.setOpaque(false);
        this.fileInfoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.fileInfoCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.fileInfoCheckBox);
        this.jToolBar1.add(this.jSeparator4);
        this.lblBranch.setLabelFor(this.cmbBranch);
        Mnemonics.setLocalizedText((JLabel)this.lblBranch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"branchLabel.text"));
        this.lblBranch.setToolTipText(NbBundle.getMessage(SearchHistoryPanel.class, (String)"branchLabel.TTtext"));
        this.lblBranch.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jToolBar1.add(this.lblBranch);
        this.cmbBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.cmbBranchActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmbBranch);
        this.jToolBar1.add(this.jSeparator1);
        Mnemonics.setLocalizedText((JLabel)this.lblFilter, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"filterLabel.text"));
        this.lblFilter.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jToolBar1.add(this.lblFilter);
        this.cmbFilterKind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.cmbFilterKindActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmbFilterKind);
        Mnemonics.setLocalizedText((JLabel)this.lblFilterContains, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"containsLabel"));
        this.lblFilterContains.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jToolBar1.add(this.lblFilterContains);
        this.txtFilter.setMinimumSize(new Dimension(30, 18));
        this.txtFilter.setPreferredSize(new Dimension(50, 18));
        this.jToolBar1.add(this.txtFilter);
        this.resultsPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.expandCriteriaButton, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_expandCriteriaButton.text"));
        this.expandCriteriaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.expandCriteriaButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchCriteriaPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBar1, GroupLayout.Alignment.TRAILING, -1, 691, Short.MAX_VALUE).addComponent(this.resultsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent((Component)this.expandCriteriaButton, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.bSearch)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsPanel, -1, 251, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.expandCriteriaButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchCriteriaPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addGap(9, 9, 9)));
    }

    private void onViewToggle(ActionEvent evt) {
        this.refreshComponents(true);
    }

    private void fileInfoCheckBoxActionPerformed(ActionEvent evt) {
        GitModuleConfig.getDefault().setShowFileInfo(this.fileInfoCheckBox.isSelected());
        if (this.summaryView != null) {
            this.summaryView.refreshView();
        }
    }

    private void expandCriteriaButtonActionPerformed(ActionEvent evt) {
        this.searchCriteriaPanel.setVisible(!this.searchCriteriaPanel.isVisible());
        this.expandCriteriaButton.setIcon(this.searchCriteriaPanel.isVisible() ? ICON_EXPANDED : ICON_COLLAPSED);
        this.criteriaVisible = this.searchCriteriaPanel.isVisible();
    }

    private void cmbFilterKindActionPerformed(ActionEvent evt) {
        boolean filterCritVisible = this.cmbFilterKind.getSelectedItem() != FilterKind.ALL;
        this.lblFilterContains.setVisible(filterCritVisible);
        this.txtFilter.setVisible(filterCritVisible);
        if (filterCritVisible) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SearchHistoryPanel.this.cmbFilterKind.isPopupVisible()) {
                        SearchHistoryPanel.this.txtFilter.requestFocusInWindow();
                    }
                }
            });
        }
        if (this.filterTimer != null && !this.txtFilter.getText().trim().isEmpty()) {
            this.filterTimer.restart();
        }
    }

    private void cmbBranchActionPerformed(ActionEvent evt) {
        boolean refresh;
        Object filter = this.cmbBranch.getSelectedItem();
        boolean bl = refresh = filter != this.currentBranchFilter;
        if (refresh) {
            this.currentBranchFilter = filter;
            if (this.currentBranchFilter == ALL_BRANCHES_FILTER && this.criteria.getBranch() != null && this.criteria.tfBranch.isEnabled() && 0 == JOptionPane.showConfirmDialog(this, Bundle.MSG_SearchHistoryPanel_searchAllBranches_text(this.criteria.getBranch()), Bundle.LBL_SearchHistoryPanel_searchAllBranches_title(), 0, 3)) {
                this.criteria.setBranch("");
                this.executeSearch();
                return;
            }
            this.filterTimer.restart();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    private void documentChanged(DocumentEvent e) {
        if (e.getDocument() == this.txtFilter.getDocument()) {
            this.filterTimer.restart();
        } else {
            this.validateUserInput();
        }
    }

    private void validateUserInput() {
        if (!this.criteria.validateUserInput()) {
            this.bSearch.setEnabled(false);
            return;
        }
        this.bSearch.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BranchSelector selector;
        if (e.getSource() == this.filterTimer) {
            if (this.summaryView != null) {
                this.summaryView.refreshView();
            }
            if (this.diffView != null) {
                this.diffView.refreshResults(this.filter(this.results));
            }
        } else if (e.getSource() == this.criteria.btnSelectBranch && (selector = new BranchSelector(this.repository)).open()) {
            this.criteria.setBranch(selector.getSelectedBranch());
        }
    }

    File getRepository() {
        return this.repository;
    }

    void release() {
        this.info.removePropertyChangeListener(this.list);
        this.releaseDiff();
    }

    private void releaseDiff() {
        if (this.diffView != null) {
            this.diffView.cancelBackgroundTasks();
        }
        this.cancelBackgroundTasks();
    }

    List<RepositoryRevision> getResults() {
        return this.results;
    }

    boolean hasMoreResults() {
        return this.showingResults > -1;
    }

    static Map<String, VCSKenaiAccessor.KenaiUser> createKenaiUsersMap(List<RepositoryRevision> results) {
        return Collections.emptyMap();
    }

    void getMoreRevisions(PropertyChangeListener callback, int count) {
        if (this.currentSearch == null) {
            throw new IllegalStateException("No search task active");
        }
        if (this.currentAdditionalSearch != null) {
            this.currentAdditionalSearch.cancel();
        }
        count = count < 0 || this.showingResults < 0 ? -1 : (count += this.showingResults);
        this.currentAdditionalSearch = new Search(count);
        this.currentAdditionalSearch.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(SearchHistoryPanel.class, (String)"MSG_SearchHistoryPanel.GettingMoreRevisions"));
    }

    Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> getSearchHighlights() {
        String filterText = this.txtFilter.getText().trim();
        Object selectedFilterKind = this.cmbFilterKind.getSelectedItem();
        if (selectedFilterKind == FilterKind.ALL || filterText.isEmpty() || !(selectedFilterKind instanceof FilterKind)) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AbstractSummaryView.SummaryViewMaster.SearchHighlight(((FilterKind)((Object)selectedFilterKind)).kind, filterText));
    }

    private void initializeFilter() {
        DefaultComboBoxModel<FilterKind> filterModel = new DefaultComboBoxModel<FilterKind>();
        filterModel.addElement(FilterKind.ALL);
        filterModel.addElement(FilterKind.ID);
        filterModel.addElement(FilterKind.MESSAGE);
        filterModel.addElement(FilterKind.USER);
        this.cmbFilterKind.setModel(filterModel);
        this.cmbFilterKind.setSelectedItem((Object)FilterKind.ALL);
        this.txtFilter.getDocument().addDocumentListener(this);
    }

    private List<RepositoryRevision> filter(List<RepositoryRevision> results) {
        ArrayList<RepositoryRevision> newResults = new ArrayList<RepositoryRevision>(results.size());
        for (RepositoryRevision rev : results) {
            if (!this.applyFilter(rev)) continue;
            newResults.add(rev);
        }
        return newResults;
    }

    boolean applyFilter(RepositoryRevision rev) {
        boolean visible = true;
        String filterText = this.txtFilter.getText().trim().toLowerCase();
        Object selectedFilterKind = this.cmbFilterKind.getSelectedItem();
        if (selectedFilterKind != FilterKind.ALL && !filterText.isEmpty()) {
            if (selectedFilterKind == FilterKind.MESSAGE) {
                visible = rev.getLog().getFullMessage().toLowerCase().contains(filterText);
            } else if (selectedFilterKind == FilterKind.USER) {
                visible = rev.getLog().getAuthor().toString().toLowerCase().contains(filterText);
            } else if (selectedFilterKind == FilterKind.ID) {
                visible = rev.getLog().getRevision().contains(filterText) || SearchHistoryPanel.contains(rev.getBranches(), filterText) || SearchHistoryPanel.contains(rev.getTags(), filterText);
            }
        }
        Object selectedBranchFilter = this.currentBranchFilter;
        if (visible && selectedBranchFilter instanceof GitBranch) {
            visible = rev.getLog().getBranches().containsKey(((GitBranch)this.currentBranchFilter).getName());
        }
        return visible;
    }

    private static boolean contains(GitBranch[] items, String needle) {
        for (GitBranch item : items) {
            if (item.getName() == "(no branch)" || !item.getName().toLowerCase().contains(needle)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(GitTag[] items, String needle) {
        for (GitTag item : items) {
            if (!item.getTagName().toLowerCase().contains(needle)) continue;
            return true;
        }
        return false;
    }

    List<SummaryView.GitLogEntry> createLogEntries(List<RepositoryRevision> results) {
        LinkedList<SummaryView.GitLogEntry> ret = new LinkedList<SummaryView.GitLogEntry>();
        for (RepositoryRevision repositoryRevision : results) {
            ret.add(new SummaryView.GitLogEntry(repositoryRevision, this));
        }
        return ret;
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.tbDiff.setSelected(true);
        this.selectFirstRevision = selectFirstRevision;
        this.selectFirstRevision();
    }

    void setDiffResultsViewFactory(SearchHistoryTopComponent.DiffResultsViewFactory fac) {
        if (fac != null) {
            this.diffViewFactory = fac;
        }
    }

    private void refreshBranchFilterModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(ALL_BRANCHES_FILTER);
        for (Map.Entry<String, GitBranch> e : this.info.getBranches().entrySet()) {
            GitBranch b = e.getValue();
            if (b.getName() == "(no branch)") continue;
            model.addElement((String)b);
            if (!(this.currentBranchFilter instanceof GitBranch) || !b.getName().equals(((GitBranch)this.currentBranchFilter).getName())) continue;
            this.currentBranchFilter = b;
        }
        this.cmbBranch.setModel(model);
        this.cmbBranch.setSelectedItem(this.currentBranchFilter);
    }

    private void updateBranchFilter(String branch) {
        this.currentBranchFilter = ALL_BRANCHES_FILTER;
        if (branch != null && this.criteria.getMode() != SearchExecutor.Mode.REMOTE_IN) {
            ComboBoxModel model = this.cmbBranch.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Object filter = model.getElementAt(i);
                if (!(filter instanceof GitBranch) || !branch.equals(((GitBranch)filter).getName())) continue;
                this.currentBranchFilter = filter;
                break;
            }
        }
        this.cmbBranch.setSelectedItem(this.currentBranchFilter);
    }

    private class Search
    extends GitProgressSupport {
        private final int count;
        private final SearchExecutor executor;

        private Search(int count) {
            this.count = count;
            this.executor = SearchHistoryPanel.this.currentSearch;
        }

        @Override
        protected void perform() {
            List<RepositoryRevision> newResults;
            try {
                newResults = this.executor.search(this.count, this.getClient(), this.getProgressMonitor());
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                return;
            }
            final Map<String, VCSKenaiAccessor.KenaiUser> additionalUsersMap = SearchHistoryPanel.createKenaiUsersMap(newResults);
            if (!this.isCanceled()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Search.this.isCanceled()) {
                            HashSet<String> visibleRevisions = new HashSet<String>(SearchHistoryPanel.this.results.size());
                            for (RepositoryRevision rev : SearchHistoryPanel.this.results) {
                                visibleRevisions.add(rev.getLog().getRevision());
                            }
                            ArrayList<RepositoryRevision> toAdd = new ArrayList<RepositoryRevision>(newResults.size());
                            for (RepositoryRevision rev : newResults) {
                                if (visibleRevisions.contains(rev.getLog().getRevision())) continue;
                                toAdd.add(rev);
                            }
                            SearchHistoryPanel.this.results.addAll(toAdd);
                            if (Search.this.count == -1) {
                                SearchHistoryPanel.this.showingResults = -1;
                            } else {
                                SearchHistoryPanel.this.showingResults = Search.this.count;
                            }
                            if (SearchHistoryPanel.this.showingResults > newResults.size()) {
                                SearchHistoryPanel.this.showingResults = -1;
                            }
                            SearchHistoryPanel.this.logEntries = SearchHistoryPanel.this.createLogEntries(SearchHistoryPanel.this.results);
                            SearchHistoryPanel.this.kenaiUserMap.putAll(additionalUsersMap);
                            if (SearchHistoryPanel.this.diffView != null) {
                                SearchHistoryPanel.this.diffView.refreshResults(SearchHistoryPanel.this.results);
                            }
                            if (SearchHistoryPanel.this.summaryView != null) {
                                SearchHistoryPanel.this.summaryView.entriesChanged(SearchHistoryPanel.this.logEntries);
                            }
                        }
                    }
                });
            }
        }
    }

    static enum FilterKind {
        ALL(null, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.All")),
        MESSAGE(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.MESSAGE, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.Message")),
        USER(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.AUTHOR, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.User")),
        ID(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.REVISION, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.Commit")),
        FILE(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.FILE, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.File"));

        private String label;
        private AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind kind;

        private FilterKind(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind kind, String label) {
            this.kind = kind;
            this.label = label;
        }

        public final String toString() {
            return this.label;
        }
    }
}

