/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

class FieldElementImpl
extends ScopeImpl
implements FieldElement {
    String defaultType;
    private String defaultFQType;
    private String className;
    private static Set<String> recursionDetection = new HashSet<String>();

    FieldElementImpl(Scope inScope, String defaultType, String defaultFQType, ASTNodeInfo<FieldAccess> nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, PhpModifiers.fromBitMask(1), null, isDeprecated);
        this.defaultType = defaultType;
        this.defaultFQType = defaultFQType;
        assert (inScope instanceof TypeScope);
        this.className = inScope.getName();
    }

    FieldElementImpl(Scope inScope, String defaultType, String defaultFQType, SingleFieldDeclarationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, nodeInfo.getAccessModifiers(), null, isDeprecated);
        this.defaultType = defaultType;
        this.defaultFQType = defaultFQType;
        assert (inScope instanceof TypeScope);
        this.className = inScope.getName();
    }

    FieldElementImpl(Scope inScope, String defaultType, String defaultFQType, PhpDocTypeTagInfo nodeInfo) {
        super(inScope, nodeInfo, nodeInfo.getAccessModifiers(), null, inScope.isDeprecated());
        this.defaultType = defaultType;
        this.defaultFQType = defaultFQType;
        assert (inScope instanceof TypeScope);
        this.className = inScope.getName();
    }

    FieldElementImpl(Scope inScope, org.netbeans.modules.php.editor.api.elements.FieldElement indexedConstant) {
        super(inScope, indexedConstant, PhpElementKind.FIELD);
        String in = indexedConstant.getIn();
        this.className = in != null ? in : inScope.getName();
        Set<TypeResolver> instanceTypes = indexedConstant.getInstanceTypes();
        for (TypeResolver typeResolver : instanceTypes) {
            String type;
            if (!typeResolver.isResolved()) continue;
            QualifiedName typeName = typeResolver.getTypeName(false);
            String string = type = typeName == null ? "" : typeName.toNamespaceName() + "\\" + typeName.getName();
            if (this.defaultType != null) {
                this.defaultType = this.defaultType + String.format("|%s", type);
                continue;
            }
            this.defaultType = type;
        }
        Set<TypeResolver> instanceFQTypes = indexedConstant.getInstanceFQTypes();
        for (TypeResolver typeResolver : instanceFQTypes) {
            String type;
            if (!typeResolver.isResolved()) continue;
            QualifiedName typeName = typeResolver.getTypeName(false);
            String string = type = typeName == null ? "" : typeName.toNamespaceName() + "\\" + typeName.getName();
            if (this.defaultFQType != null) {
                this.defaultFQType = this.defaultFQType + String.format("|%s", type);
                continue;
            }
            this.defaultFQType = type;
        }
    }

    private FieldElementImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpModifiers modifiers, String defaultType, boolean isDeprecated) {
        super(inScope, name, file, offsetRange, PhpElementKind.FIELD, modifiers, isDeprecated);
        this.defaultType = defaultType;
        this.defaultFQType = defaultType;
    }

    @Override
    void addElement(ModelElementImpl element) {
    }

    static String toName(SingleFieldDeclaration node) {
        return VariableNameImpl.toName(node.getName());
    }

    static OffsetRange toOffsetRange(SingleFieldDeclaration node) {
        return VariableNameImpl.toOffsetRange(node.getName());
    }

    static PhpModifiers toAccessModifiers(FieldsDeclaration node) {
        return PhpModifiers.fromBitMask(node.getModifier());
    }

    public Collection<? extends TypeScope> getDefaultTypes() {
        HashSet<? extends TypeScope> typeScopes = new HashSet<TypeScope>();
        if (this.defaultFQType != null && this.defaultFQType.length() > 0) {
            String[] allTypeNames;
            String[] stringArray = allTypeNames = this.defaultFQType.split("\\|");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String typeName;
                String modifiedTypeName = typeName = stringArray[i];
                if (typeName.indexOf("[") != -1) {
                    modifiedTypeName = typeName.replaceAll("\\[.*\\]", "");
                }
                typeScopes.addAll(IndexScopeImpl.getTypes(QualifiedName.create(modifiedTypeName), this));
            }
        }
        return typeScopes;
    }

    @Override
    public String getNormalizedName() {
        return this.className + super.getNormalizedName();
    }

    @Override
    public Collection<? extends String> getTypeNames(int offset) {
        Collection<Object> retval;
        AssignmentImpl assignment = this.findAssignment(offset);
        Collection<Object> collection = retval = assignment != null ? assignment.getTypeNames() : Collections.emptyList();
        if (retval.isEmpty() && (retval = this.getDefaultTypeNames()).isEmpty()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            for (VariableName variableName : classScope.getDeclaredVariables()) {
                if (!variableName.representsThis()) continue;
                return variableName.getTypeNames(offset);
            }
        }
        return retval;
    }

    @Override
    public Collection<? extends TypeScope> getArrayAccessTypes(int offset) {
        return this.getTypes(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends TypeScope> getTypes(int offset) {
        Collection<Object> retval;
        AssignmentImpl assignment = this.findAssignment(offset);
        Collection<Object> collection = retval = assignment != null ? assignment.getTypes() : Collections.emptyList();
        if (retval.isEmpty() && (retval = this.getDefaultTypes()).isEmpty() && this.getInScope() instanceof ClassScope) {
            ClassScope classScope = (ClassScope)this.getInScope();
            for (VariableName variableName : classScope.getDeclaredVariables()) {
                if (!variableName.representsThis()) continue;
                String checkName = this.getNormalizedName();
                boolean added = recursionDetection.add(checkName);
                try {
                    if (!added) continue;
                    Collection collection2 = variableName.getFieldTypes(this, offset);
                    return collection2;
                }
                finally {
                    recursionDetection.remove(checkName);
                }
            }
        }
        return retval;
    }

    @Override
    public Collection<? extends String> getDefaultTypeNames() {
        List retval = Collections.emptyList();
        if (this.defaultType != null && this.defaultType.length() > 0) {
            retval = new ArrayList();
            for (String typeName : this.defaultType.split("\\|")) {
                if (VariousUtils.isSemiType(typeName)) continue;
                retval.add(typeName);
            }
        }
        return retval;
    }

    public Collection<? extends FieldAssignmentImpl> getAssignments() {
        return FieldElementImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return true;
            }
        });
    }

    public AssignmentImpl findAssignment(int offset) {
        FieldAssignmentImpl retval = null;
        Collection<? extends FieldAssignmentImpl> assignments = this.getAssignments();
        if (assignments.size() == 1) {
            retval = assignments.iterator().next();
        } else {
            for (FieldAssignmentImpl fieldAssignmentImpl : assignments) {
                if (!fieldAssignmentImpl.getBlockRange().containsInclusive(offset) || retval != null && retval.getOffset() > fieldAssignmentImpl.getOffset() || fieldAssignmentImpl.getOffset() >= offset) continue;
                retval = fieldAssignmentImpl;
            }
        }
        return retval;
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        indexDocument.addPair("field", this.getIndexSignature(), true, true);
    }

    private String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        String noDollarName = this.getName().substring(1);
        sb.append(noDollarName.toLowerCase()).append(';');
        sb.append(noDollarName).append(';');
        sb.append(this.getOffset()).append(';');
        sb.append(this.getPhpModifiers().toFlags()).append(';');
        if (this.defaultType != null) {
            sb.append(this.defaultType);
        }
        sb.append(';');
        if (this.defaultFQType != null) {
            sb.append(this.defaultFQType);
        }
        sb.append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        return sb.toString();
    }

    @Override
    public Collection<? extends TypeScope> getFieldTypes(FieldElement element, int offset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

