/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2sedeploy.J2SEDeployProperties;
import org.netbeans.modules.java.j2sedeploy.ui.JSEDeploymentPanel;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class JSEDeploymentCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_DEPLOYMENT = "Deployment";
    private static final Map<String, J2SEDeployProperties> projectProperties = new HashMap<String, J2SEDeployProperties>();
    private WeakReference<JSEDeploymentPanel> panelRef = null;

    public ProjectCustomizer.Category createCategory(Lookup context) {
        boolean deploymentEnabled = true;
        final Project project = (Project)context.lookup(Project.class);
        if (project != null) {
            J2SEPropertyEvaluator j2sepe = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
            String fxEnabled = j2sepe.evaluator().getProperty("javafx.enabled");
            boolean bl = deploymentEnabled = !J2SEDeployProperties.isTrue(fxEnabled);
        }
        if (deploymentEnabled) {
            ProjectCustomizer.Category c = ProjectCustomizer.Category.create((String)CAT_DEPLOYMENT, (String)NbBundle.getMessage(JSEDeploymentCategoryProvider.class, (String)"LBL_Category_Deployment"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            c.setOkButtonListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JSEDeploymentPanel panel;
                        J2SEDeployProperties prop = J2SEDeployProperties.getInstanceIfExists(project.getLookup());
                        if (prop != null) {
                            projectProperties.put(project.getProjectDirectory().getPath(), prop);
                        }
                        if (JSEDeploymentCategoryProvider.this.panelRef != null && (panel = (JSEDeploymentPanel)JSEDeploymentCategoryProvider.this.panelRef.get()) != null) {
                            List<ActionListener> listeners = panel.getOKListeners();
                            for (ActionListener listener : listeners) {
                                listener.actionPerformed(e);
                            }
                        }
                    }
                }
            });
            c.setStoreListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JSEDeploymentPanel panel;
                        J2SEDeployProperties prop = (J2SEDeployProperties)projectProperties.get(project.getProjectDirectory().getPath());
                        if (prop != null) {
                            try {
                                prop.store();
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        projectProperties.remove(project.getProjectDirectory().getPath());
                        if (JSEDeploymentCategoryProvider.this.panelRef != null && (panel = (JSEDeploymentPanel)JSEDeploymentCategoryProvider.this.panelRef.get()) != null) {
                            List<ActionListener> listeners = panel.getStoreListeners();
                            for (ActionListener listener : listeners) {
                                listener.actionPerformed(e);
                            }
                        }
                    }
                }
            });
            c.setCloseListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JSEDeploymentPanel panel;
                        J2SEDeployProperties.cleanup(project.getLookup());
                        if (JSEDeploymentCategoryProvider.this.panelRef != null && (panel = (JSEDeploymentPanel)JSEDeploymentCategoryProvider.this.panelRef.get()) != null) {
                            List<ActionListener> listeners = panel.getCloseListeners();
                            for (ActionListener listener : listeners) {
                                listener.actionPerformed(e);
                            }
                        }
                    }
                }
            });
            return c;
        }
        return null;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        JSEDeploymentPanel panel = new JSEDeploymentPanel(J2SEDeployProperties.getInstance(context));
        this.panelRef = new WeakReference<JSEDeploymentPanel>(panel);
        return panel;
    }
}

