/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.html.HtmlDataObject;
import org.netbeans.modules.html.api.HtmlDataNode;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;

public final class HtmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie {
    private static final String DOCUMENT_SAVE_ENCODING = "Document_Save_Encoding";
    private static final String UTF_8_ENCODING = "UTF-8";
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            try {
                HtmlEditorSupport.this.saveDocument();
            }
            catch (UserCancelException userCancelException) {
                // empty catch block
            }
        }

        public String toString() {
            return HtmlEditorSupport.this.getDataObject().getPrimaryFile().getNameExt();
        }
    };

    HtmlEditorSupport(HtmlDataObject obj) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType(this.getDataObject().getPrimaryFile().getMIMEType());
    }

    protected boolean close(boolean ask) {
        boolean closed = super.close(ask);
        DataObject dobj = this.getDataObject();
        if (closed && dobj.isValid()) {
            HtmlDataNode nodeDelegate = (HtmlDataNode)dobj.getNodeDelegate();
            nodeDelegate.setPropertySets(null);
        }
        return closed;
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/html", (Serializable)this.getDataObject());
    }

    public void saveDocument() throws IOException {
        this.updateEncoding();
        super.saveDocument();
    }

    void updateEncoding() throws UserQuestionException {
        String documentContent = this.getDocumentText();
        String encoding = HtmlDataObject.findEncoding(documentContent);
        String feqEncoding = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile()).name();
        if (encoding != null) {
            if (!this.isSupportedEncoding(encoding) || !this.canEncode(documentContent, encoding)) {
                final String defaultEncoding = this.canEncode(documentContent, feqEncoding) ? feqEncoding : UTF_8_ENCODING;
                String msg = NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_unsupportedEncodingSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, defaultEncoding, defaultEncoding.equals(UTF_8_ENCODING) ? "" : " the original"});
                throw new UserQuestionException(msg){

                    public void confirmed() throws IOException {
                        HtmlEditorSupport.this.setEncodingProperty(defaultEncoding);
                        HtmlEditorSupport.super.saveDocument();
                    }
                };
            }
            this.setEncodingProperty(encoding);
        } else {
            if (!this.canEncode(documentContent, feqEncoding)) {
                String msg = NbBundle.getMessage(HtmlEditorSupport.class, (String)"MSG_badCharConversionSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), feqEncoding});
                throw new UserQuestionException(msg){

                    public void confirmed() throws IOException {
                        HtmlEditorSupport.this.setEncodingProperty(HtmlEditorSupport.UTF_8_ENCODING);
                        HtmlEditorSupport.super.saveDocument();
                    }
                };
            }
            this.setEncodingProperty(feqEncoding);
        }
    }

    private void setEncodingProperty(String encoding) {
        StyledDocument doc = this.getDocument();
        if (doc != null) {
            doc.putProperty(DOCUMENT_SAVE_ENCODING, encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        String foundEncoding = (String)doc.getProperty(DOCUMENT_SAVE_ENCODING);
        String usedEncoding = foundEncoding != null ? foundEncoding : UTF_8_ENCODING;
        Charset c = Charset.forName(usedEncoding);
        OutputStreamWriter w = new OutputStreamWriter(stream, c);
        try {
            kit.write(w, (Document)doc, 0, doc.getLength());
        }
        finally {
            ((Writer)w).close();
        }
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.getCookieSet0().add((Node.Cookie)this.saveCookie);
            obj.setModified(true);
        }
    }

    void removeSaveCookie() {
        HtmlDataObject obj = (HtmlDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    private String getDocumentText() {
        String text = "";
        try {
            StyledDocument doc = this.getDocument();
            if (doc != null) {
                text = doc.getText(doc.getStartPosition().getOffset(), doc.getLength());
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        }
        return text;
    }

    private boolean canDecodeFile(FileObject fo, String encoding) {
        CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        try {
            BufferedInputStream bis = new BufferedInputStream(fo.getInputStream());
            byte[] buffer = new byte[(int)fo.getSize()];
            bis.read(buffer);
            bis.close();
            decoder.decode(ByteBuffer.wrap(buffer));
            return true;
        }
        catch (CharacterCodingException bis) {
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.WARNING, "Error during charset verification", ioe);
        }
        return false;
    }

    private boolean canEncode(String docText, String encoding) {
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        return encoder.canEncode(docText);
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(HtmlDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((HtmlDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (HtmlEditorSupport)this.getDataObject().getCookie(HtmlEditorSupport.class);
        }
    }
}

