/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import java.io.IOException;
import java.io.Reader;

public class LocationTrackingReader
extends Reader {
    private final Reader delegate;
    private int offset = -1;
    private int lineOffset = -1;
    private int lineNumber = -1;
    private char[] buf;
    private int bufOffset = 0;
    private int bufLength = 0;

    public LocationTrackingReader(Reader delegate) {
        this(delegate, 2048);
    }

    public LocationTrackingReader(Reader delegate, int bufferSize) {
        this.delegate = delegate;
        this.buf = new char[bufferSize];
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.bufLength > 0) {
            int length = Math.min(len, this.bufLength);
            System.arraycopy(this.buf, this.bufOffset, cbuf, off, length);
            this.bufLength -= length;
            this.bufOffset += length;
            if (this.bufLength == 0) {
                this.bufOffset = 0;
            }
            this.offset += length;
            return length;
        }
        int read = this.delegate.read(cbuf, off, len);
        if (read != -1) {
            this.offset += read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        if (this.bufLength > 0) {
            char c = this.buf[this.bufOffset];
            --this.bufLength;
            ++this.bufOffset;
            if (this.bufLength == 0) {
                this.bufOffset = 0;
            }
            ++this.offset;
            return c;
        }
        int read = this.delegate.read();
        if (read != -1) {
            ++this.offset;
        }
        return read;
    }

    public String readLine() throws IOException {
        this.lineOffset = this.offset + 1;
        int lineBufOffset = this.bufOffset;
        int c = -1;
        int x = lineBufOffset;
        while (true) {
            int length;
            if (x >= this.bufOffset + this.bufLength) {
                int emptyOffset;
                int read;
                if (this.bufOffset > 0 && this.bufLength > 0) {
                    System.arraycopy(this.buf, this.bufOffset, this.buf, 0, this.bufLength);
                    x -= this.bufOffset;
                    this.bufOffset = 0;
                    lineBufOffset = 0;
                }
                if (this.bufOffset + this.bufLength >= this.buf.length) {
                    char[] newBuf = new char[this.buf.length * 2];
                    if (this.bufLength > 0) {
                        System.arraycopy(this.buf, this.bufOffset, newBuf, 0, this.bufLength);
                    }
                    x -= this.bufOffset;
                    this.bufOffset = 0;
                    lineBufOffset = 0;
                    this.buf = newBuf;
                }
                if ((read = this.delegate.read(this.buf, emptyOffset = this.bufOffset + this.bufLength, this.buf.length - emptyOffset)) <= 0) break;
                this.bufLength += read;
            }
            if (x >= this.bufOffset + this.bufLength) break;
            int nc = this.buf[x];
            if (nc == 10) {
                length = x - lineBufOffset + 1;
                this.bufOffset += length;
                this.bufLength -= length;
                this.offset += length;
                int stringLength = c == 13 ? length - 2 : length - 1;
                ++this.lineNumber;
                return new String(this.buf, lineBufOffset, stringLength);
            }
            if (c == 13) {
                length = x - lineBufOffset;
                this.bufOffset += length;
                this.bufLength -= length;
                this.offset += length;
                int stringLength = length - 1;
                ++this.lineNumber;
                return new String(this.buf, lineBufOffset, stringLength);
            }
            c = nc;
            ++x;
        }
        if (this.bufLength > 0) {
            String line = new String(this.buf, this.bufOffset, c == 13 ? this.bufLength - 1 : this.bufLength);
            this.bufOffset = 0;
            this.offset += this.bufLength;
            this.bufLength = 0;
            ++this.lineNumber;
            return line;
        }
        ++this.lineNumber;
        return null;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

