/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NPECheck {
    static final boolean DEF_ENABLE_FOR_FIELDS = false;
    static final String KEY_ENABLE_FOR_FIELDS = "enable-for-fields";
    static final boolean DEF_UNBOXING_UNKNOWN_VALUES = true;
    static final String KEY_UNBOXING_UNKNOWN_VALUES = "unboxing-unknown";
    private static final Object KEY_EXPRESSION_STATE = new Object();
    private static final Object KEY_CONDITIONAL_PARAMETER = new Object();
    private static final AnnotationMirrorGetter OVERRIDE_ANNOTATIONS = (AnnotationMirrorGetter)Lookup.getDefault().lookup(AnnotationMirrorGetter.class);
    private static final Set<ElementKind> VARIABLE_ELEMENT_NO_FIELDS = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    private static final Set<ElementKind> VARIABLE_ELEMENT_FIELDS = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

    public static ErrorDescription assignment(HintContext ctx) {
        Element e = ctx.getInfo().getTrees().getElement((TreePath)ctx.getVariables().get("$var"));
        if (!NPECheck.isVariableElement(ctx, e)) {
            return null;
        }
        TreePath expr = (TreePath)ctx.getVariables().get("$expr");
        State r = NPECheck.computeExpressionsState(ctx).get(expr.getLeaf());
        State elementState = NPECheck.getStateFromAnnotations(ctx.getInfo(), e);
        if (elementState != null && elementState.isNotNull()) {
            String key = null;
            if (r == State.NULL || r == State.NULL_HYPOTHETICAL) {
                key = "ERR_AssigningNullToNotNull";
            }
            if (r == State.POSSIBLE_NULL_REPORT) {
                key = "ERR_PossibleAssigingNullToNotNull";
            }
            if (key != null) {
                return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)NbBundle.getMessage(NPECheck.class, (String)key), (Fix[])new Fix[0]);
            }
        }
        return null;
    }

    public static ErrorDescription unboxingConditional(HintContext ctx) {
        String k;
        TypeMirror np;
        TreePath npPath;
        CompilationInfo ci = ctx.getInfo();
        TypeMirror leftType = ci.getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$trueExpr"));
        TypeMirror rightType = ci.getTrees().getTypeMirror((TreePath)ctx.getVariables().get("$falseExpr"));
        TypeMirror resType = ci.getTrees().getTypeMirror(ctx.getPath());
        if (!(Utilities.isValidType(leftType) && Utilities.isValidType(rightType) && Utilities.isValidType(resType))) {
            return null;
        }
        if (!resType.getKind().isPrimitive()) {
            return null;
        }
        if (leftType.getKind().isPrimitive()) {
            if (rightType.getKind().isPrimitive()) {
                npPath = null;
                np = null;
            } else {
                np = rightType;
                npPath = (TreePath)ctx.getVariables().get("$falseExpr");
            }
        } else if (!rightType.getKind().isPrimitive()) {
            if (!Utilities.isPrimitiveWrapperType(leftType) || !Utilities.isPrimitiveWrapperType(rightType) || ci.getTypes().isSameType(leftType, rightType)) {
                return null;
            }
            Object o = ci.getCachedValue(KEY_CONDITIONAL_PARAMETER);
            if (o == null) {
                np = leftType;
                npPath = (TreePath)ctx.getVariables().get("$trueExpr");
                ci.putCachedValue(KEY_CONDITIONAL_PARAMETER, (Object)Boolean.TRUE, CompilationInfo.CacheClearPolicy.ON_TASK_END);
            } else {
                np = rightType;
                npPath = (TreePath)ctx.getVariables().get("$falseExpr");
            }
        } else {
            np = leftType;
            npPath = (TreePath)ctx.getVariables().get("$trueExpr");
        }
        if (np == null || !ci.getTypes().isAssignable(np, resType)) {
            return null;
        }
        assert (npPath != null);
        Map<Tree, State> expressionsState = NPECheck.computeExpressionsState(ctx);
        State s = expressionsState.get(npPath.getLeaf());
        if (s == null || s == State.POSSIBLE_NULL) {
            boolean report = ctx.getPreferences().getBoolean(KEY_UNBOXING_UNKNOWN_VALUES, true);
            if (!report) {
                return null;
            }
            k = "ERR_UnboxingPotentialNullValue";
        } else {
            switch (s) {
                case NULL: 
                case NULL_HYPOTHETICAL: {
                    k = "ERR_UnboxingNullValue";
                    break;
                }
                case POSSIBLE_NULL_REPORT: 
                case POSSIBLE_NULL: 
                case INSTANCE_OF_FALSE: {
                    k = "ERR_UnboxingPotentialNullValue";
                    break;
                }
                case NOT_NULL_BE_NPE: 
                case NOT_NULL: 
                case NOT_NULL_HYPOTHETICAL: 
                case INSTANCE_OF_TRUE: {
                    return null;
                }
                default: {
                    throw new AssertionError((Object)s.name());
                }
            }
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)npPath, (String)NbBundle.getMessage(NPECheck.class, (String)k), (Fix[])new Fix[0]);
    }

    public static ErrorDescription switchExpression(HintContext ctx) {
        TreePath select = (TreePath)ctx.getVariables().get("$select");
        TypeMirror m = ctx.getInfo().getTrees().getTypeMirror(select);
        if (m == null || m.getKind() != TypeKind.DECLARED) {
            return null;
        }
        State r = NPECheck.computeExpressionsState(ctx).get(select.getLeaf());
        if (r == State.NULL || r == State.NULL_HYPOTHETICAL) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_DereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        if (r == State.POSSIBLE_NULL_REPORT || r == State.INSTANCE_OF_FALSE) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_PossiblyDereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription enhancedFor(HintContext ctx) {
        TreePath colExpr = (TreePath)ctx.getVariables().get("$expr");
        if (colExpr == null) {
            return null;
        }
        State r = NPECheck.computeExpressionsState(ctx).get(colExpr.getLeaf());
        if (r == State.NULL || r == State.NULL_HYPOTHETICAL) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_DereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        if (r == State.POSSIBLE_NULL_REPORT || r == State.INSTANCE_OF_FALSE) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_PossiblyDereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription memberSelect(HintContext ctx) {
        TreePath select = (TreePath)ctx.getVariables().get("$select");
        State r = NPECheck.computeExpressionsState(ctx).get(select.getLeaf());
        if (r == State.NULL || r == State.NULL_HYPOTHETICAL) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_DereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        if (r == State.POSSIBLE_NULL_REPORT || r == State.INSTANCE_OF_FALSE) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)"ERR_PossiblyDereferencingNull");
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static boolean isSafeToDereference(CompilationInfo info, TreePath path) {
        State r = NPECheck.computeExpressionsState(info, null).get(path.getLeaf());
        return r != null && r.isNotNull();
    }

    public static List<ErrorDescription> methodInvocation(HintContext ctx) {
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ArrayList<State> paramStates = new ArrayList<State>(mit.getArguments().size());
        Map<Tree, State> expressionsState = NPECheck.computeExpressionsState(ctx);
        for (Tree tree : mit.getArguments()) {
            State r = expressionsState.get(tree);
            paramStates.add(r != null ? r : State.POSSIBLE_NULL);
        }
        Element e = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (e == null || e.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement executableElement = (ExecutableElement)e;
        int index = 0;
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        List<? extends VariableElement> params = executableElement.getParameters();
        for (VariableElement variableElement : params) {
            if (!(NPECheck.getStateFromAnnotations(ctx.getInfo(), variableElement) != State.NOT_NULL || executableElement.isVarArgs() && variableElement == params.get(params.size() - 1))) {
                switch ((State)((Object)paramStates.get(index))) {
                    case NULL: 
                    case NULL_HYPOTHETICAL: {
                        result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)mit.getArguments().get(index), (String)NbBundle.getMessage(NPECheck.class, (String)"ERR_NULL_TO_NON_NULL_ARG"), (Fix[])new Fix[0]));
                        break;
                    }
                    case POSSIBLE_NULL_REPORT: 
                    case INSTANCE_OF_FALSE: {
                        result.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)mit.getArguments().get(index), (String)NbBundle.getMessage(NPECheck.class, (String)"ERR_POSSIBLENULL_TO_NON_NULL_ARG"), (Fix[])new Fix[0]));
                    }
                }
            }
            ++index;
        }
        return result;
    }

    public static ErrorDescription notNullTest(HintContext ctx) {
        TreePath variable = (TreePath)ctx.getVariables().get("$variable");
        State r = NPECheck.computeExpressionsState(ctx).get(variable.getLeaf());
        if (r != null && r.isNotNull() && !NPECheck.ignore(ctx, false)) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)(r == State.NOT_NULL_BE_NPE ? "ERR_NotNullWouldBeNPE" : "ERR_NotNull"));
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription nullTest(HintContext ctx) {
        TreePath variable = (TreePath)ctx.getVariables().get("$variable");
        State r = NPECheck.computeExpressionsState(ctx).get(variable.getLeaf());
        if (r != null && r.isNotNull() && !NPECheck.ignore(ctx, true)) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)(r == State.NOT_NULL_BE_NPE ? "ERR_NotNullWouldBeNPE" : "ERR_NotNull"));
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    private static boolean ignore(HintContext ctx, boolean equalsToNull) {
        TreePath test;
        for (test = ctx.getPath().getParentPath(); test != null && !StatementTree.class.isAssignableFrom(test.getLeaf().getKind().asInterface()); test = test.getParentPath()) {
        }
        if (test == null) {
            return false;
        }
        if (test.getLeaf().getKind() == Tree.Kind.ASSERT && !equalsToNull) {
            return NPECheck.verifyConditions(ctx, ((AssertTree)test.getLeaf()).getCondition(), equalsToNull);
        }
        if (test.getLeaf().getKind() == Tree.Kind.IF && equalsToNull) {
            StatementTree last;
            IfTree it = (IfTree)test.getLeaf();
            switch (it.getThenStatement().getKind()) {
                case BLOCK: {
                    List<? extends StatementTree> statements = ((BlockTree)it.getThenStatement()).getStatements();
                    last = !statements.isEmpty() ? statements.get(statements.size() - 1) : null;
                    break;
                }
                default: {
                    last = it.getThenStatement();
                }
            }
            return last != null && last.getKind() == Tree.Kind.THROW && NPECheck.verifyConditions(ctx, ((IfTree)test.getLeaf()).getCondition(), equalsToNull);
        }
        return false;
    }

    private static boolean verifyConditions(HintContext ctx, ExpressionTree cond, boolean equalsToNull) {
        switch (cond.getKind()) {
            case PARENTHESIZED: {
                return NPECheck.verifyConditions(ctx, ((ParenthesizedTree)cond).getExpression(), equalsToNull);
            }
            case NOT_EQUAL_TO: {
                return !equalsToNull && NPECheck.hasNull(ctx, (BinaryTree)cond);
            }
            case EQUAL_TO: {
                return equalsToNull && NPECheck.hasNull(ctx, (BinaryTree)cond);
            }
            case CONDITIONAL_OR: 
            case OR: {
                return equalsToNull && NPECheck.verifyConditions(ctx, ((BinaryTree)cond).getLeftOperand(), equalsToNull) && NPECheck.verifyConditions(ctx, ((BinaryTree)cond).getRightOperand(), equalsToNull);
            }
            case CONDITIONAL_AND: 
            case AND: {
                return !equalsToNull && NPECheck.verifyConditions(ctx, ((BinaryTree)cond).getLeftOperand(), equalsToNull) && NPECheck.verifyConditions(ctx, ((BinaryTree)cond).getRightOperand(), equalsToNull);
            }
        }
        return false;
    }

    private static boolean hasNull(HintContext ctx, BinaryTree bt) {
        return bt.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL || bt.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL;
    }

    public static ErrorDescription returnNull(HintContext ctx) {
        TreePath expression = (TreePath)ctx.getVariables().get("$expression");
        State returnState = NPECheck.computeExpressionsState(ctx).get(expression.getLeaf());
        if (returnState == null) {
            return null;
        }
        TreePath method = Utilities.findOwningExecutable(ctx, ctx.getPath(), true);
        if (method == null) {
            return null;
        }
        CompilationInfo info = ctx.getInfo();
        Element el = null;
        switch (method.getLeaf().getKind()) {
            case LAMBDA_EXPRESSION: {
                TypeMirror functionalType = info.getTrees().getTypeMirror(method);
                if (!Utilities.isValidType(functionalType) || functionalType.getKind() != TypeKind.DECLARED) {
                    return null;
                }
                el = info.getElementUtilities().getDescriptorElement((TypeElement)((DeclaredType)functionalType).asElement());
                break;
            }
            case METHOD: {
                el = info.getTrees().getElement(method);
            }
        }
        if (el == null || el.getKind() != ElementKind.METHOD) {
            return null;
        }
        State expected = NPECheck.getStateFromAnnotations(info, el);
        String key = null;
        switch (returnState) {
            case NULL: 
            case NULL_HYPOTHETICAL: {
                if (!expected.isNotNull()) break;
                key = "ERR_ReturningNullFromNonNull";
                break;
            }
            case POSSIBLE_NULL_REPORT: 
            case INSTANCE_OF_FALSE: {
                if (!expected.isNotNull()) break;
                key = "ERR_ReturningPossibleNullFromNonNull";
            }
        }
        if (key != null) {
            String displayName = NbBundle.getMessage(NPECheck.class, (String)key);
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)expression, (String)displayName, (Fix[])new Fix[0]);
        }
        return null;
    }

    private static Map<Tree, State> computeExpressionsState(CompilationInfo info, HintContext ctx) {
        Map result = (Map)info.getCachedValue(KEY_EXPRESSION_STATE);
        if (result != null) {
            return result;
        }
        VisitorImpl v = new VisitorImpl(ctx, info, null);
        v.scan((Tree)info.getCompilationUnit(), null);
        result = v.expressionState;
        info.putCachedValue(KEY_EXPRESSION_STATE, (Object)result, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return result;
    }

    private static Map<Tree, State> computeExpressionsState(HintContext ctx) {
        Map result = (Map)ctx.getInfo().getCachedValue(KEY_EXPRESSION_STATE);
        if (result != null) {
            return result;
        }
        VisitorImpl v = new VisitorImpl(ctx);
        v.scan((Tree)ctx.getInfo().getCompilationUnit(), null);
        result = v.expressionState;
        ctx.getInfo().putCachedValue(KEY_EXPRESSION_STATE, (Object)result, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return result;
    }

    private static State getStateFromAnnotations(CompilationInfo info, Element e) {
        return NPECheck.getStateFromAnnotations(info, e, State.POSSIBLE_NULL);
    }

    private static State getStateFromAnnotations(CompilationInfo info, Element e, State def) {
        Iterable<? extends AnnotationMirror> mirrors;
        if (e == null) {
            return def;
        }
        Iterable<? extends AnnotationMirror> iterable = mirrors = OVERRIDE_ANNOTATIONS != null ? OVERRIDE_ANNOTATIONS.getAnnotationMirrors(info, e) : null;
        if (mirrors == null) {
            mirrors = e.getAnnotationMirrors();
        }
        for (AnnotationMirror annotationMirror : mirrors) {
            String simpleName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getSimpleName().toString();
            if ("Nullable".equals(simpleName) || "NullAllowed".equals(simpleName)) {
                return State.POSSIBLE_NULL_REPORT;
            }
            if ("CheckForNull".equals(simpleName)) {
                return State.POSSIBLE_NULL_REPORT;
            }
            if (!"NotNull".equals(simpleName) && !"NonNull".equals(simpleName) && !"Nonnull".equals(simpleName)) continue;
            return State.NOT_NULL;
        }
        return def;
    }

    private static boolean isVariableElement(HintContext ctx, Element ve) {
        return ve != null && (ctx != null && ctx.getPreferences().getBoolean(KEY_ENABLE_FOR_FIELDS, false) ? VARIABLE_ELEMENT_FIELDS : VARIABLE_ELEMENT_NO_FIELDS).contains((Object)ve.getKind());
    }

    static enum State {
        NULL,
        NULL_HYPOTHETICAL,
        POSSIBLE_NULL,
        POSSIBLE_NULL_REPORT,
        INSTANCE_OF_FALSE,
        NOT_NULL,
        NOT_NULL_HYPOTHETICAL,
        INSTANCE_OF_TRUE,
        NOT_NULL_BE_NPE;


        @CheckForNull
        public State reverse() {
            switch (this) {
                case NULL: {
                    return NOT_NULL;
                }
                case NULL_HYPOTHETICAL: {
                    return NOT_NULL_HYPOTHETICAL;
                }
                case INSTANCE_OF_FALSE: {
                    return INSTANCE_OF_TRUE;
                }
                case POSSIBLE_NULL_REPORT: 
                case POSSIBLE_NULL: {
                    return this;
                }
                case NOT_NULL_BE_NPE: 
                case NOT_NULL: {
                    return NULL;
                }
                case NOT_NULL_HYPOTHETICAL: {
                    return NULL_HYPOTHETICAL;
                }
                case INSTANCE_OF_TRUE: {
                    return INSTANCE_OF_FALSE;
                }
            }
            throw new IllegalStateException();
        }

        public boolean isNotNull() {
            return this == NOT_NULL || this == NOT_NULL_BE_NPE || this == NOT_NULL_HYPOTHETICAL || this == INSTANCE_OF_TRUE;
        }

        public static State collect(State s1, State s2) {
            if (s1 == s2) {
                return s1;
            }
            if (s1 == NULL || s2 == NULL || s1 == NULL_HYPOTHETICAL || s2 == NULL_HYPOTHETICAL) {
                return POSSIBLE_NULL_REPORT;
            }
            if (s1 == POSSIBLE_NULL_REPORT || s2 == POSSIBLE_NULL_REPORT || s2 == INSTANCE_OF_FALSE) {
                return POSSIBLE_NULL_REPORT;
            }
            if (s1 != null && s2 != null && s1.isNotNull() && s2.isNotNull()) {
                return NOT_NULL;
            }
            return POSSIBLE_NULL;
        }
    }

    private static final class VisitorImpl
    extends CancellableTreePathScanner<State, Void> {
        private final HintContext ctx;
        private final CompilationInfo info;
        private final AtomicBoolean cancelFlag;
        private Map<VariableElement, State> variable2State = new HashMap<VariableElement, State>();
        private final Map<VariableElement, State> variable2StateFinal = new HashMap<VariableElement, State>();
        private final Map<Tree, Collection<Map<VariableElement, State>>> resumeBefore = new IdentityHashMap<Tree, Collection<Map<VariableElement, State>>>();
        private final Map<Tree, Collection<Map<VariableElement, State>>> resumeAfter = new IdentityHashMap<Tree, Collection<Map<VariableElement, State>>>();
        private Map<TypeMirror, Map<VariableElement, State>> resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<VariableElement, State>>();
        private final Map<Tree, State> expressionState = new IdentityHashMap<Tree, State>();
        private final List<TreePath> pendingFinally = new LinkedList<TreePath>();
        private boolean not;
        private boolean doNotRecord;
        private final TypeElement throwableEl;
        private final TypeMirror runtimeExceptionType;
        private final TypeMirror errorType;
        private final Map<Tree, Collection<VariableElement>> scopedVariables = new IdentityHashMap<Tree, Collection<VariableElement>>();
        private boolean inCycle = false;

        public VisitorImpl(HintContext ctx, CompilationInfo aInfo, AtomicBoolean cancel) {
            this.ctx = ctx;
            if (ctx != null) {
                this.info = ctx.getInfo();
                this.cancelFlag = null;
            } else {
                this.info = aInfo;
                this.cancelFlag = cancel != null ? cancel : new AtomicBoolean(false);
            }
            this.throwableEl = this.info.getElements().getTypeElement("java.lang.Throwable");
            TypeElement tel = this.info.getElements().getTypeElement("java.lang.RuntimeException");
            this.runtimeExceptionType = tel != null ? tel.asType() : null;
            tel = this.info.getElements().getTypeElement("java.lang.Error");
            this.errorType = tel != null ? tel.asType() : null;
        }

        public VisitorImpl(HintContext ctx) {
            this(ctx, null, null);
        }

        protected boolean isCanceled() {
            if (this.ctx != null) {
                return this.ctx.isCanceled();
            }
            return this.cancelFlag.get();
        }

        public State scan(Tree tree, Void p) {
            TypeMirror currentType;
            this.resume(tree, this.resumeBefore);
            State r = (State)((Object)super.scan(tree, (Object)p));
            TypeMirror typeMirror = currentType = tree != null ? this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree)) : null;
            if (tree != null && tree.getKind() == Tree.Kind.LAMBDA_EXPRESSION || currentType != null && currentType.getKind().isPrimitive()) {
                r = State.NOT_NULL;
            }
            if (r != null && !this.doNotRecord) {
                this.expressionState.put(tree, this.mergeIn(this.expressionState, tree, r));
            }
            this.resume(tree, this.resumeAfter);
            Collection<VariableElement> varsOutScope = this.scopedVariables.get(tree);
            if (varsOutScope != null) {
                for (VariableElement ve : varsOutScope) {
                    State s = this.variable2State.get(ve);
                    if (s == null) continue;
                    this.variable2StateFinal.put(ve, s);
                }
                this.variable2State.keySet().removeAll(varsOutScope);
            }
            return r;
        }

        private void resume(Tree tree, Map<Tree, Collection<Map<VariableElement, State>>> resume) {
            Collection<Map<VariableElement, State>> toResume = resume.remove(tree);
            if (toResume != null) {
                for (Map<VariableElement, State> s : toResume) {
                    this.mergeIntoVariable2State(s);
                }
            }
        }

        public State visitAssignment(AssignmentTree node, Void p) {
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getVariable()));
            HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
            State r = this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getVariable(), p);
            this.mergeHypotheticalVariable2State(orig);
            if (this.isVariableElement(e)) {
                this.variable2State.put((VariableElement)e, r);
            }
            return r;
        }

        public State visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
            HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getExpression(), p);
            this.scan((Tree)node.getVariable(), p);
            this.mergeHypotheticalVariable2State(orig);
            return null;
        }

        private void addScopedVariable(Tree t, VariableElement ve) {
            Collection<VariableElement> c = this.scopedVariables.get(t);
            if (c == null) {
                c = new ArrayList<VariableElement>(3);
                this.scopedVariables.put(t, c);
            }
            c.add(ve);
        }

        public State visitVariable(VariableTree node, Void p) {
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
            State r = this.scan((Tree)node.getInitializer(), p);
            this.mergeHypotheticalVariable2State(orig);
            if (e != null) {
                if (e.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                    r = State.NOT_NULL;
                }
                this.variable2State.put((VariableElement)e, r);
                TreePath pp = this.getCurrentPath().getParentPath();
                if (pp != null) {
                    this.addScopedVariable(pp.getLeaf(), (VariableElement)e);
                }
            }
            return r;
        }

        public State visitMemberSelect(MemberSelectTree node, Void p) {
            Element enumConst;
            Element site;
            State expr = this.scan((Tree)node.getExpression(), p);
            boolean wasNPE = false;
            if (expr == State.NULL || expr == State.NULL_HYPOTHETICAL || expr == State.POSSIBLE_NULL || expr == State.POSSIBLE_NULL_REPORT || expr == State.INSTANCE_OF_FALSE) {
                wasNPE = true;
            }
            if (this.isVariableElement(site = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()))) && wasNPE && (this.variable2State.get((VariableElement)site) == null || !this.variable2State.get((VariableElement)site).isNotNull())) {
                this.variable2State.put((VariableElement)site, State.NOT_NULL_BE_NPE);
            }
            if (site != null && site.getKind() == ElementKind.ENUM && (enumConst = this.info.getTrees().getElement(this.getCurrentPath())) != null && enumConst.getKind() == ElementKind.ENUM_CONSTANT) {
                return State.NOT_NULL;
            }
            return NPECheck.getStateFromAnnotations(this.info, this.info.getTrees().getElement(this.getCurrentPath()));
        }

        public State visitLiteral(LiteralTree node, Void p) {
            if (node.getValue() == null) {
                return State.NULL;
            }
            return State.NOT_NULL;
        }

        public State visitIf(IfTree node, Void p) {
            boolean elseExitsFromAllBranches;
            HashMap<VariableElement, State> oldVariable2StateBeforeCondition = new HashMap<VariableElement, State>(this.variable2State);
            State condition = this.scan((Tree)node.getCondition(), p);
            this.scan((Tree)node.getThenStatement(), null);
            HashMap<VariableElement, State> variableStatesAfterThen = new HashMap<VariableElement, State>(this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>(oldVariable2StateBeforeCondition);
            this.not = true;
            this.doNotRecord = true;
            this.scan((Tree)node.getCondition(), p);
            this.not = false;
            this.doNotRecord = false;
            this.scan((Tree)node.getElseStatement(), null);
            boolean thenExitsFromAllBranches = Utilities.exitsFromAllBranchers(this.info, new TreePath(this.getCurrentPath(), node.getThenStatement()));
            boolean bl = elseExitsFromAllBranches = node.getElseStatement() != null && Utilities.exitsFromAllBranchers(this.info, new TreePath(this.getCurrentPath(), node.getElseStatement()));
            if (!thenExitsFromAllBranches || elseExitsFromAllBranches) {
                if (!thenExitsFromAllBranches && elseExitsFromAllBranches) {
                    this.variable2State = variableStatesAfterThen;
                } else {
                    this.mergeIntoVariable2State(variableStatesAfterThen);
                }
            }
            return null;
        }

        public State visitBinary(BinaryTree node, Void p) {
            Element e;
            Tree.Kind kind = node.getKind();
            if (this.not) {
                switch (kind) {
                    case CONDITIONAL_AND: {
                        kind = Tree.Kind.CONDITIONAL_OR;
                        break;
                    }
                    case CONDITIONAL_OR: {
                        kind = Tree.Kind.CONDITIONAL_AND;
                        break;
                    }
                    case EQUAL_TO: {
                        kind = Tree.Kind.NOT_EQUAL_TO;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        kind = Tree.Kind.EQUAL_TO;
                    }
                }
            }
            State left = null;
            State right = null;
            switch (kind) {
                case OR: 
                case CONDITIONAL_AND: 
                case AND: 
                case XOR: {
                    this.scan((Tree)node.getLeftOperand(), p);
                    this.scan((Tree)node.getRightOperand(), p);
                    break;
                }
                case CONDITIONAL_OR: {
                    HashMap<VariableElement, State> orig = new HashMap<VariableElement, State>(this.variable2State);
                    this.scan((Tree)node.getLeftOperand(), p);
                    Map<VariableElement, State> afterLeft = this.variable2State;
                    this.variable2State = orig;
                    boolean oldNot = this.not;
                    boolean oldDoNotRecord = this.doNotRecord;
                    this.not ^= true;
                    this.doNotRecord = true;
                    this.scan((Tree)node.getLeftOperand(), p);
                    this.not = oldNot;
                    this.doNotRecord = oldDoNotRecord;
                    this.scan((Tree)node.getRightOperand(), p);
                    this.mergeIntoVariable2State(afterLeft);
                    break;
                }
                default: {
                    boolean oldNot = this.not;
                    this.not = false;
                    left = this.scan((Tree)node.getLeftOperand(), p);
                    right = this.scan((Tree)node.getRightOperand(), p);
                    this.not = oldNot;
                }
            }
            if (kind == Tree.Kind.EQUAL_TO) {
                if (right == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getLeftOperand()))) && !this.hasDefiniteValue((VariableElement)e)) {
                    this.variable2State.put((VariableElement)e, State.NULL_HYPOTHETICAL);
                    return null;
                }
                if (left == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getRightOperand()))) && !this.hasDefiniteValue((VariableElement)e)) {
                    this.variable2State.put((VariableElement)e, State.NULL_HYPOTHETICAL);
                    return null;
                }
            }
            if (kind == Tree.Kind.NOT_EQUAL_TO) {
                if (right == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getLeftOperand()))) && !this.hasDefiniteValue((VariableElement)e)) {
                    this.variable2State.put((VariableElement)e, State.NOT_NULL_HYPOTHETICAL);
                    return null;
                }
                if (left == State.NULL && this.isVariableElement(e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getRightOperand()))) && !this.hasDefiniteValue((VariableElement)e)) {
                    this.variable2State.put((VariableElement)e, State.NOT_NULL_HYPOTHETICAL);
                    return null;
                }
            }
            return null;
        }

        public State visitInstanceOf(InstanceOfTree node, Void p) {
            super.visitInstanceOf(node, (Object)p);
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (this.isVariableElement(e)) {
                boolean setState = false;
                State currentState = this.variable2State.get((VariableElement)e);
                if (currentState == null) {
                    setState = !NPECheck.getStateFromAnnotations(this.info, e).isNotNull();
                } else {
                    boolean bl = setState = !this.variable2State.get((VariableElement)e).isNotNull();
                }
                if (setState) {
                    this.variable2State.put((VariableElement)e, this.not ? State.INSTANCE_OF_FALSE : State.INSTANCE_OF_TRUE);
                }
            }
            return null;
        }

        public State visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            HashMap<VariableElement, State> oldVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            this.scan((Tree)node.getCondition(), p);
            State thenSection = this.scan((Tree)node.getTrueExpression(), p);
            Map<VariableElement, State> variableStatesAfterThen = this.variable2State;
            this.variable2State = oldVariable2State;
            this.not = true;
            this.doNotRecord = true;
            this.scan((Tree)node.getCondition(), p);
            this.not = false;
            this.doNotRecord = false;
            State elseSection = this.scan((Tree)node.getFalseExpression(), p);
            State result = State.collect(thenSection, elseSection);
            this.mergeIntoVariable2State(variableStatesAfterThen);
            return result;
        }

        public State visitNewClass(NewClassTree node, Void p) {
            this.scan((Tree)node.getEnclosingExpression(), p);
            this.scan((Tree)node.getIdentifier(), p);
            this.scan(node.getTypeArguments(), p);
            for (Tree tree : node.getArguments()) {
                Map<VariableElement, State> origVariable2State = this.variable2State;
                this.variable2State = new HashMap<VariableElement, State>(this.variable2State);
                this.scan(tree, p);
                this.mergeNonHypotheticalVariable2State(origVariable2State);
            }
            this.scan((Tree)node.getClassBody(), p);
            Element invoked = this.info.getTrees().getElement(this.getCurrentPath());
            if (invoked != null && invoked.getKind() == ElementKind.CONSTRUCTOR) {
                this.recordResumeOnExceptionHandler((ExecutableElement)invoked);
            }
            return State.NOT_NULL;
        }

        public State visitMethodInvocation(MethodInvocationTree node, Void p) {
            this.scan(node.getTypeArguments(), p);
            this.scan((Tree)node.getMethodSelect(), p);
            for (Tree tree : node.getArguments()) {
                Map<VariableElement, State> origVariable2State = this.variable2State;
                this.variable2State = new HashMap<VariableElement, State>(this.variable2State);
                this.scan(tree, p);
                this.mergeNonHypotheticalVariable2State(origVariable2State);
            }
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e == null || e.getKind() != ElementKind.METHOD) {
                return State.POSSIBLE_NULL;
            }
            this.recordResumeOnExceptionHandler((ExecutableElement)e);
            this.visitAssertMethods(node, e);
            State state = this.visitPrimitiveWrapperMethods(node, e);
            if (state != null) {
                return state;
            }
            return NPECheck.getStateFromAnnotations(this.info, e);
        }

        private State visitPrimitiveWrapperMethods(MethodInvocationTree node, Element e) {
            if (!Utilities.isPrimitiveWrapperType(e.getEnclosingElement().asType())) {
                return null;
            }
            switch (e.getSimpleName().toString()) {
                case "toString": 
                case "toUnsignedString": 
                case "toHexString": 
                case "toOctalString": 
                case "toBinaryString": 
                case "valueOf": 
                case "decode": {
                    return State.NOT_NULL;
                }
                case "getLong": 
                case "getShort": 
                case "getInteger": 
                case "getBoolean": 
                case "getFloat": 
                case "getDouble": 
                case "getCharacter": {
                    if (node.getArguments().size() != 2) {
                        return null;
                    }
                    TreePath parPath = new TreePath(this.getCurrentPath(), node.getArguments().get(1));
                    TypeMirror m = this.ctx.getInfo().getTrees().getTypeMirror(parPath);
                    if (!Utilities.isValidType(m)) {
                        return null;
                    }
                    if (m.getKind().isPrimitive()) {
                        return State.NOT_NULL;
                    }
                    if (NPECheck.isSafeToDereference(this.ctx.getInfo(), parPath)) {
                        return State.NOT_NULL;
                    }
                    return null;
                }
            }
            return null;
        }

        private void visitAssertMethods(MethodInvocationTree node, Element e) {
            if (!node.getArguments().isEmpty()) {
                Element param;
                String ownerFQN = ((TypeElement)e.getEnclosingElement()).getQualifiedName().toString();
                Tree argument = null;
                State targetState = null;
                switch (e.getSimpleName().toString()) {
                    case "assertNotNull": {
                        targetState = State.NOT_NULL;
                        break;
                    }
                    case "assertNull": {
                        targetState = State.NULL;
                    }
                }
                switch (ownerFQN) {
                    case "org.testng.Assert": {
                        argument = node.getArguments().get(0);
                        break;
                    }
                    case "junit.framework.Assert": 
                    case "org.junit.Assert": 
                    case "org.junit.jupiter.api.Assertions": {
                        argument = node.getArguments().get(node.getArguments().size() - 1);
                    }
                }
                Element element = param = argument != null && targetState != null ? this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), argument)) : null;
                if (param != null && this.isVariableElement(param)) {
                    this.variable2State.put((VariableElement)param, targetState);
                }
            }
        }

        public State visitIdentifier(IdentifierTree node, Void p) {
            super.visitIdentifier(node, (Object)p);
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e == null || !this.isVariableElement(e)) {
                return State.POSSIBLE_NULL;
            }
            if (e.getKind() == ElementKind.ENUM_CONSTANT) {
                return State.NOT_NULL;
            }
            State s = this.variable2State.get((VariableElement)e);
            if (s != null) {
                return s;
            }
            return NPECheck.getStateFromAnnotations(this.info, e);
        }

        public State visitWhileLoop(WhileLoopTree node, Void p) {
            return this.handleGeneralizedFor(null, node.getCondition(), null, node.getStatement(), p);
        }

        public State visitDoWhileLoop(DoWhileLoopTree node, Void p) {
            return this.handleGeneralizedFor(Collections.singletonList(node.getStatement()), node.getCondition(), null, node.getStatement(), p);
        }

        public State visitUnary(UnaryTree node, Void p) {
            boolean oldNot = this.not;
            this.not ^= node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            State res = this.scan((Tree)node.getExpression(), p);
            this.not = oldNot;
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public State visitMethod(MethodTree node, Void p) {
            Map<TypeMirror, Map<VariableElement, State>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
            this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<VariableElement, State>>();
            try {
                this.variable2State = new HashMap<VariableElement, State>();
                this.not = false;
                Element current = this.info.getTrees().getElement(this.getCurrentPath());
                if (current != null && (current.getKind() == ElementKind.METHOD || current.getKind() == ElementKind.CONSTRUCTOR)) {
                    for (VariableElement variableElement : ((ExecutableElement)current).getParameters()) {
                        this.variable2State.put(variableElement, NPECheck.getStateFromAnnotations(this.info, variableElement));
                    }
                }
                while (current != null) {
                    for (VariableElement variableElement : ElementFilter.fieldsIn(current.getEnclosedElements())) {
                        this.variable2State.put(variableElement, NPECheck.getStateFromAnnotations(this.info, variableElement));
                    }
                    current = current.getEnclosingElement();
                }
                State state = (State)((Object)super.visitMethod(node, (Object)p));
                return state;
            }
            finally {
                this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
            }
        }

        public State visitForLoop(ForLoopTree node, Void p) {
            return this.handleGeneralizedFor(node.getInitializer(), node.getCondition(), node.getUpdate(), node.getStatement(), p);
        }

        public State visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
            return this.handleGeneralizedFor(Arrays.asList(node.getVariable(), node.getExpression()), null, null, node.getStatement(), p);
        }

        private Map<VariableElement, State> findStateDifference(Map<VariableElement, State> basepoint) {
            HashMap<VariableElement, State> m = new HashMap<VariableElement, State>();
            for (Map.Entry<VariableElement, State> vEntry : this.variable2State.entrySet()) {
                VariableElement k = vEntry.getKey();
                State s = basepoint.get(k);
                if (s == vEntry.getValue()) continue;
                m.put(k, vEntry.getValue());
            }
            return m;
        }

        private State handleGeneralizedFor(Iterable<? extends Tree> initializer, Tree condition, Iterable<? extends Tree> update, Tree statement, Void p) {
            this.scan(initializer, p);
            HashMap<VariableElement, State> oldVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            boolean oldNot = this.not;
            boolean oldDoNotRecord = this.doNotRecord;
            this.not = true;
            this.doNotRecord = true;
            this.scan(condition, p);
            this.not = oldNot;
            HashMap<VariableElement, State> negConditionVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            Map<VariableElement, State> negConditionChanges2State = this.findStateDifference(oldVariable2State);
            this.doNotRecord = oldDoNotRecord;
            if (!this.inCycle) {
                this.inCycle = true;
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                this.scan(condition, p);
                this.scan(statement, p);
                this.scan(update, p);
                this.mergeIntoVariable2State(oldVariable2State);
                this.inCycle = false;
            } else {
                this.variable2State = oldVariable2State;
            }
            this.scan(condition, p);
            this.scan(statement, p);
            this.scan(update, p);
            this.mergeIntoVariable2State(negConditionVariable2State);
            this.forceIntoVariable2State(negConditionChanges2State);
            return null;
        }

        public State visitAssert(AssertTree node, Void p) {
            this.scan((Tree)node.getCondition(), p);
            this.scan((Tree)node.getDetail(), p);
            return null;
        }

        public State visitArrayAccess(ArrayAccessTree node, Void p) {
            super.visitArrayAccess(node, (Object)p);
            return State.POSSIBLE_NULL;
        }

        public State visitSwitch(SwitchTree node, Void p) {
            this.scan((Tree)node.getExpression(), null);
            HashMap<VariableElement, State> origVariable2State = new HashMap<VariableElement, State>(this.variable2State);
            boolean exhaustive = false;
            for (CaseTree caseTree : node.getCases()) {
                this.mergeIntoVariable2State(origVariable2State);
                if (caseTree.getExpression() == null) {
                    exhaustive = true;
                }
                this.scan((Tree)caseTree, null);
            }
            if (!exhaustive) {
                this.mergeIntoVariable2State(origVariable2State);
            }
            return null;
        }

        public State visitBreak(BreakTree node, Void p) {
            super.visitBreak(node, (Object)p);
            StatementTree target = this.info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
            this.resumeAfter(target, this.variable2State);
            this.variable2State = new HashMap<VariableElement, State>();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public State visitTry(TryTree node, Void p) {
            Map<TypeMirror, Map<VariableElement, State>> oldResumeOnExceptionHandler = this.resumeOnExceptionHandler;
            this.resumeOnExceptionHandler = new IdentityHashMap<TypeMirror, Map<VariableElement, State>>();
            try {
                Map<VariableElement, State> data;
                if (node.getFinallyBlock() != null) {
                    this.pendingFinally.add(0, new TreePath(this.getCurrentPath(), node.getFinallyBlock()));
                }
                this.scan(node.getResources(), null);
                Map<VariableElement, State> oldVariable2State = this.variable2State;
                this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                IdentityHashMap<TypeMirror, Map<VariableElement, State>> resumeOnEx = null;
                ArrayList<TypeMirror> caughtTypes = null;
                if (node.getCatches() != null && !node.getCatches().isEmpty()) {
                    caughtTypes = new ArrayList<TypeMirror>(node.getCatches().size());
                    resumeOnEx = new IdentityHashMap<TypeMirror, Map<VariableElement, State>>(caughtTypes.size());
                    for (CatchTree catchTree : node.getCatches()) {
                        for (TypeMirror typeMirror : Utilities.getUnionExceptions(this.info, this.getCurrentPath(), catchTree)) {
                            data = this.resumeOnExceptionHandler.get(typeMirror);
                            if (data != null) {
                                resumeOnEx.put(typeMirror, data);
                            }
                            this.resumeOnExceptionHandler.put(typeMirror, new HashMap());
                            caughtTypes.add(typeMirror);
                        }
                    }
                    this.recordResumeOnExceptionHandler(this.runtimeExceptionType);
                    this.recordResumeOnExceptionHandler(this.errorType);
                }
                this.scan((Tree)node.getBlock(), null);
                if (caughtTypes != null) {
                    this.recordResumeOnExceptionHandler(this.runtimeExceptionType);
                    this.recordResumeOnExceptionHandler(this.errorType);
                }
                HashMap<VariableElement, State> afterBlockVariable2State = new HashMap<VariableElement, State>(this.variable2State);
                if (caughtTypes != null) {
                    assert (resumeOnEx != null);
                    for (TypeMirror typeMirror : caughtTypes) {
                        Map map = (Map)resumeOnEx.remove(typeMirror);
                        data = this.resumeOnExceptionHandler.remove(typeMirror);
                        if (data != null) {
                            resumeOnEx.put(typeMirror, data);
                        }
                        if (map == null) continue;
                        this.resumeOnExceptionHandler.put(typeMirror, map);
                    }
                    assert (node.getCatches() != null);
                    for (CatchTree catchTree : node.getCatches()) {
                        Map<VariableElement, State> map = this.variable2State;
                        this.variable2State = new HashMap<VariableElement, State>(oldVariable2State);
                        for (TypeMirror typeMirror : Utilities.getUnionExceptions(this.info, this.getCurrentPath(), catchTree)) {
                            Map data2 = (Map)resumeOnEx.get(typeMirror);
                            if (data2 == null) continue;
                            this.mergeIntoVariable2State(data2);
                        }
                        this.scan((Tree)catchTree, null);
                        if (Utilities.exitsFromAllBranchers(this.info, new TreePath(this.getCurrentPath(), catchTree))) {
                            this.variable2State = map;
                            continue;
                        }
                        this.mergeIntoVariable2State(map);
                    }
                }
                if (node.getFinallyBlock() != null) {
                    this.pendingFinally.remove(0);
                    this.mergeIntoVariable2State(oldVariable2State);
                    this.mergeIntoVariable2State(afterBlockVariable2State);
                    this.scan((Tree)node.getFinallyBlock(), null);
                }
            }
            finally {
                Map<TypeMirror, Map<VariableElement, State>> remainingException = this.resumeOnExceptionHandler;
                this.resumeOnExceptionHandler = oldResumeOnExceptionHandler;
                for (Map.Entry<TypeMirror, Map<VariableElement, State>> e : remainingException.entrySet()) {
                    this.recordResumeOnExceptionHandler(e.getKey(), e.getValue());
                }
            }
            return null;
        }

        private void recordResumeOnExceptionHandler(ExecutableElement invoked) {
            for (TypeMirror typeMirror : invoked.getThrownTypes()) {
                this.recordResumeOnExceptionHandler(typeMirror);
            }
            this.recordResumeOnExceptionHandler("java.lang.RuntimeException");
            this.recordResumeOnExceptionHandler("java.lang.Error");
        }

        private void recordResumeOnExceptionHandler(String exceptionTypeFQN) {
            TypeElement exc = this.info.getElements().getTypeElement(exceptionTypeFQN);
            if (exc == null) {
                return;
            }
            this.recordResumeOnExceptionHandler(exc.asType());
        }

        private void recordResumeOnExceptionHandler(TypeMirror thrown) {
            this.recordResumeOnExceptionHandler(thrown, this.variable2State);
        }

        private void recordResumeOnExceptionHandler(TypeMirror thrown, Map<VariableElement, State> variable2State) {
            DeclaredType dtt;
            TypeElement tel;
            TypeMirror curT = thrown;
            do {
                if (curT == null || curT.getKind() != TypeKind.DECLARED) {
                    return;
                }
                dtt = (DeclaredType)curT;
                thrown = dtt.asElement().asType();
                Map<VariableElement, State> r = this.resumeOnExceptionHandler.get(thrown);
                if (r == null) continue;
                this.mergeInto(r, variable2State);
                break;
            } while ((tel = (TypeElement)dtt.asElement()) != this.throwableEl && (curT = tel.getSuperclass()) != null);
        }

        private void resumeAfter(Tree target, Map<VariableElement, State> state) {
            for (TreePath tp : this.pendingFinally) {
                boolean shouldBeRun = false;
                for (Tree t : tp) {
                    if (t != target) continue;
                    shouldBeRun = true;
                    break;
                }
                if (!shouldBeRun) break;
                VisitorImpl.recordResume(this.resumeBefore, tp.getLeaf(), state);
            }
            VisitorImpl.recordResume(this.resumeAfter, target, state);
        }

        private static void recordResume(Map<Tree, Collection<Map<VariableElement, State>>> resume, Tree target, Map<VariableElement, State> state) {
            Collection<Map<VariableElement, State>> r = resume.get(target);
            if (r == null) {
                r = new ArrayList<Map<VariableElement, State>>();
                resume.put(target, r);
            }
            r.add(new HashMap<VariableElement, State>(state));
        }

        private void forceIntoVariable2State(Map<VariableElement, State> other) {
            Map<VariableElement, State> target = this.variable2State;
            for (Map.Entry<VariableElement, State> e : other.entrySet()) {
                State t = e.getValue();
                target.put(e.getKey(), t);
            }
        }

        private void mergeIntoVariable2State(Map<VariableElement, State> other) {
            this.mergeInto(this.variable2State, other);
        }

        private void mergeInto(Map<VariableElement, State> target, Map<VariableElement, State> other) {
            for (Map.Entry<VariableElement, State> e : other.entrySet()) {
                State t = e.getValue();
                target.put(e.getKey(), this.mergeIn(target, e.getKey(), t));
            }
        }

        private State mergeIn(Map m, Object k, State nue) {
            if (m.containsKey(k)) {
                State prev = (State)((Object)m.get(k));
                return State.collect(nue, prev);
            }
            return nue;
        }

        private void mergeHypotheticalVariable2State(Map<VariableElement, State> original) {
            for (Map.Entry<VariableElement, State> e : this.variable2State.entrySet()) {
                State t = e.getValue();
                if (t != State.NULL_HYPOTHETICAL && t != State.NOT_NULL_HYPOTHETICAL) continue;
                State originalValue = original.get(e.getKey());
                e.setValue(originalValue == State.POSSIBLE_NULL || originalValue == null ? State.POSSIBLE_NULL_REPORT : originalValue);
            }
        }

        private void mergeNonHypotheticalVariable2State(Map<VariableElement, State> original) {
            Map<VariableElement, State> backup = this.variable2State;
            this.variable2State = original;
            for (Map.Entry<VariableElement, State> e : backup.entrySet()) {
                State t = e.getValue();
                if (t == null || t == State.NOT_NULL_HYPOTHETICAL || t == State.NULL_HYPOTHETICAL || t == State.INSTANCE_OF_TRUE || t == State.INSTANCE_OF_FALSE) continue;
                this.variable2State.put(e.getKey(), t);
            }
        }

        private boolean hasDefiniteValue(VariableElement el) {
            State s = this.variable2State.get(el);
            return s != null && s.isNotNull();
        }

        private boolean isVariableElement(Element ve) {
            return NPECheck.isVariableElement(this.ctx, ve);
        }
    }

    public static interface AnnotationMirrorGetter {
        public Iterable<? extends AnnotationMirror> getAnnotationMirrors(CompilationInfo var1, Element var2);
    }
}

