'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPluginPaths = undefined;

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _util = require('util');

var _lodash = require('lodash');

var _plugin_paths = require('./plugin_paths');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var lstat = (0, _util.promisify)(_fs2.default.lstat); /*
                                                       * Licensed to Elasticsearch B.V. under one or more contributor
                                                       * license agreements. See the NOTICE file distributed with
                                                       * this work for additional information regarding copyright
                                                       * ownership. Elasticsearch B.V. licenses this file to you under
                                                       * the Apache License, Version 2.0 (the "License"); you may
                                                       * not use this file except in compliance with the License.
                                                       * You may obtain a copy of the License at
                                                       *
                                                       *    http://www.apache.org/licenses/LICENSE-2.0
                                                       *
                                                       * Unless required by applicable law or agreed to in writing,
                                                       * software distributed under the License is distributed on an
                                                       * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                       * KIND, either express or implied.  See the License for the
                                                       * specific language governing permissions and limitations
                                                       * under the License.
                                                       */

var readdir = (0, _util.promisify)(_fs2.default.readdir);

var canvasPluginDirectoryName = 'canvas_plugin';

var isDirectory = function isDirectory(path) {
  return lstat(path).then(function (stat) {
    return stat.isDirectory();
  }).catch(function () {
    return false;
  });
}; // if lstat fails, it doesn't exist and is not a directory

var isDirname = function isDirname(p, name) {
  return _path2.default.basename(p) === name;
};

var filterDirectories = function filterDirectories(paths) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$exclude = _ref.exclude,
      exclude = _ref$exclude === undefined ? false : _ref$exclude;

  return Promise.all(paths.map(function (p) {
    return isDirectory(p);
  })).then(function (directories) {
    return paths.filter(function (p, i) {
      return exclude ? !directories[i] : directories[i];
    });
  });
};

var getPackagePluginPath = function getPackagePluginPath() {
  var basePluginPath = _path2.default.resolve(__dirname, '..');

  if (isDirname(basePluginPath, 'target')) {
    basePluginPath = _path2.default.join(basePluginPath, '..');
  }
  return basePluginPath;
};

var getKibanaPluginsPath = function getKibanaPluginsPath() {
  var kibanaPath = _path2.default.resolve(getPackagePluginPath(), '..', '..');

  // in dev mode we are in kibana folder, else we are in node_modules
  if (!isDirname(kibanaPath, 'kibana')) {
    kibanaPath = _path2.default.join(kibanaPath, '..');
  }

  return _path2.default.join(kibanaPath, 'plugins');
};

var getXPackPluginsPath = function getXPackPluginsPath() {
  var kibanaPath = _path2.default.resolve(getPackagePluginPath(), '..', '..');

  // in dev mode we are in kibana folder, else we are in node_modules
  return _path2.default.join(kibanaPath, 'x-pack/plugins');
};

// These must all exist
var paths = [getPackagePluginPath(), getXPackPluginsPath(), // Canvas core plugins
getKibanaPluginsPath()].filter(Boolean);

var getPluginPaths = exports.getPluginPaths = function getPluginPaths(type) {
  var findPlugins = function () {
    var _ref2 = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee(directory) {
      var isDir, names;
      return _regenerator2.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return isDirectory(directory);

            case 2:
              isDir = _context.sent;

              if (isDir) {
                _context.next = 5;
                break;
              }

              return _context.abrupt('return');

            case 5:
              _context.next = 7;
              return readdir(directory);

            case 7:
              names = _context.sent;
              return _context.abrupt('return', names.filter(function (name) {
                return name[0] !== '.';
              }).map(function (name) {
                return _path2.default.resolve.apply(_path2.default, [directory, name, canvasPluginDirectoryName].concat((0, _toConsumableArray3.default)(typePath)));
              }));

            case 9:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    return function findPlugins(_x2) {
      return _ref2.apply(this, arguments);
    };
  }();

  var typePath = _plugin_paths.pluginPaths[type];
  if (!typePath) throw new Error('Unknown type: ' + type);

  return Promise.all(paths.map(findPlugins)).then(function (dirs) {
    return dirs.reduce(function (list, dir) {
      if (!dir) return list;
      return list.concat(dir);
    }, []);
  }).then(function (possibleCanvasPlugins) {
    return filterDirectories(possibleCanvasPlugins, { exclude: false });
  }).then(function (canvasPluginDirectories) {
    return Promise.all(canvasPluginDirectories.map(function (dir) {
      return (
        // Get the full path of all files in the directory
        readdir(dir).then(function (files) {
          return files.map(function (file) {
            return _path2.default.resolve(dir, file);
          });
        })
      );
    })).then(_lodash.flatten).then(function (files) {
      return filterDirectories(files, { exclude: true });
    });
  });
};