/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.TypePath;
import groovyjarjarasm.asm.signature.SignatureReader;
import groovyjarjarasm.asm.signature.SignatureVisitor;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;

public class ClassFileIndexerProvider
extends AbstractIndexerProvider {
    protected HashSet<String> typeDeclarationSet = new HashSet();
    protected HashSet<String> constructorDeclarationSet = new HashSet();
    protected HashSet<String> methodDeclarationSet = new HashSet();
    protected HashSet<String> fieldDeclarationSet = new HashSet();
    protected HashSet<String> typeReferenceSet = new HashSet();
    protected HashSet<String> constructorReferenceSet = new HashSet();
    protected HashSet<String> methodReferenceSet = new HashSet();
    protected HashSet<String> fieldReferenceSet = new HashSet();
    protected HashSet<String> stringSet = new HashSet();
    protected HashSet<String> superTypeNameSet = new HashSet();
    protected HashSet<String> descriptorSet = new HashSet();
    protected ClassIndexer classIndexer = new ClassIndexer(this.typeDeclarationSet, this.constructorDeclarationSet, this.methodDeclarationSet, this.fieldDeclarationSet, this.typeReferenceSet, this.superTypeNameSet, this.descriptorSet);
    protected SignatureIndexer signatureIndexer = new SignatureIndexer(this.typeReferenceSet);

    @Override
    public String[] getSelectors() {
        List<String> externalSelectors = this.getExternalSelectors();
        if (externalSelectors == null) {
            return new String[]{"*:file:*.class"};
        }
        int size = externalSelectors.size();
        String[] selectors = new String[size + 1];
        externalSelectors.toArray(selectors);
        selectors[size] = "*:file:*.class";
        return selectors;
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes) {
        this.typeDeclarationSet.clear();
        this.constructorDeclarationSet.clear();
        this.methodDeclarationSet.clear();
        this.fieldDeclarationSet.clear();
        this.typeReferenceSet.clear();
        this.constructorReferenceSet.clear();
        this.methodReferenceSet.clear();
        this.fieldReferenceSet.clear();
        this.stringSet.clear();
        this.superTypeNameSet.clear();
        this.descriptorSet.clear();
        try (InputStream inputStream = entry.getInputStream();){
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept(this.classIndexer, 7);
            for (String descriptor : this.descriptorSet) {
                new SignatureReader(descriptor).accept(this.signatureIndexer);
            }
            char[] buffer = new char[classReader.getMaxStringLength()];
            block18: for (int i = classReader.getItemCount() - 1; i > 0; --i) {
                int startIndex = classReader.getItem(i);
                if (startIndex == 0) continue;
                int tag = classReader.readByte(startIndex - 1);
                switch (tag) {
                    case 7: {
                        String className = classReader.readUTF8(startIndex, buffer);
                        if (className.startsWith("[")) {
                            new SignatureReader(className).acceptType(this.signatureIndexer);
                            continue block18;
                        }
                        this.typeReferenceSet.add(className);
                        continue block18;
                    }
                    case 8: {
                        String str = classReader.readUTF8(startIndex, buffer);
                        this.stringSet.add(str);
                        continue block18;
                    }
                    case 9: {
                        int nameAndTypeItem = classReader.readUnsignedShort(startIndex + 2);
                        int nameAndTypeIndex = classReader.getItem(nameAndTypeItem);
                        tag = classReader.readByte(nameAndTypeIndex - 1);
                        if (tag != 12) continue block18;
                        String fieldName = classReader.readUTF8(nameAndTypeIndex, buffer);
                        this.fieldReferenceSet.add(fieldName);
                        continue block18;
                    }
                    case 10: 
                    case 11: {
                        String className;
                        int nameAndTypeItem = classReader.readUnsignedShort(startIndex + 2);
                        int nameAndTypeIndex = classReader.getItem(nameAndTypeItem);
                        tag = classReader.readByte(nameAndTypeIndex - 1);
                        if (tag != 12) continue block18;
                        String methodName = classReader.readUTF8(nameAndTypeIndex, buffer);
                        if ("<init>".equals(methodName)) {
                            int classItem = classReader.readUnsignedShort(startIndex);
                            int classIndex = classReader.getItem(classItem);
                            className = classReader.readUTF8(classIndex, buffer);
                            this.constructorReferenceSet.add(className);
                            continue block18;
                        }
                        this.methodReferenceSet.add(methodName);
                    }
                }
            }
            String typeName = this.classIndexer.name;
            ClassFileIndexerProvider.addToIndex(indexes, "typeDeclarations", this.typeDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "constructorDeclarations", this.constructorDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "methodDeclarations", this.methodDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "fieldDeclarations", this.fieldDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "typeReferences", this.typeReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "constructorReferences", this.constructorReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "methodReferences", this.methodReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "fieldReferences", this.fieldReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "strings", this.stringSet, entry);
            if (this.superTypeNameSet.size() > 0) {
                Map<String, Collection> index = indexes.getIndex("subTypeNames");
                for (String superTypeName : this.superTypeNameSet) {
                    index.get(superTypeName).add(typeName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class MethodIndexer
    extends MethodVisitor {
        protected HashSet<String> descriptorSet;
        protected AnnotationIndexer annotationIndexer;

        public MethodIndexer(HashSet<String> descriptorSet, AnnotationIndexer annotationIndexer) {
            super(327680);
            this.descriptorSet = descriptorSet;
            this.annotationIndexer = annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }
    }

    protected static class FieldIndexer
    extends FieldVisitor {
        protected HashSet<String> descriptorSet;
        protected AnnotationIndexer annotationIndexer;

        public FieldIndexer(HashSet<String> descriptorSet, AnnotationIndexer annotationInexer) {
            super(327680);
            this.descriptorSet = descriptorSet;
            this.annotationIndexer = annotationInexer;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }
    }

    protected static class AnnotationIndexer
    extends AnnotationVisitor {
        protected HashSet<String> descriptorSet;

        public AnnotationIndexer(HashSet<String> descriptorSet) {
            super(327680);
            this.descriptorSet = descriptorSet;
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.descriptorSet.add(desc);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.descriptorSet.add(desc);
            return this;
        }
    }

    protected static class SignatureIndexer
    extends SignatureVisitor {
        protected HashSet<String> typeReferenceSet;

        SignatureIndexer(HashSet<String> typeReferenceSet) {
            super(327680);
            this.typeReferenceSet = typeReferenceSet;
        }

        @Override
        public void visitClassType(String name) {
            this.typeReferenceSet.add(name);
        }
    }

    protected static class ClassIndexer
    extends ClassVisitor {
        protected HashSet<String> typeDeclarationSet;
        protected HashSet<String> constructorDeclarationSet;
        protected HashSet<String> methodDeclarationSet;
        protected HashSet<String> fieldDeclarationSet;
        protected HashSet<String> typeReferenceSet;
        protected HashSet<String> superTypeNameSet;
        protected HashSet<String> descriptorSet;
        protected AnnotationIndexer annotationIndexer;
        protected FieldIndexer fieldIndexer;
        protected MethodIndexer methodIndexer;
        protected String name;

        public ClassIndexer(HashSet<String> typeDeclarationSet, HashSet<String> constructorDeclarationSet, HashSet<String> methodDeclarationSet, HashSet<String> fieldDeclarationSet, HashSet<String> typeReferenceSet, HashSet<String> superTypeNameSet, HashSet<String> descriptorSet) {
            super(327680);
            this.typeDeclarationSet = typeDeclarationSet;
            this.constructorDeclarationSet = constructorDeclarationSet;
            this.methodDeclarationSet = methodDeclarationSet;
            this.fieldDeclarationSet = fieldDeclarationSet;
            this.typeReferenceSet = typeReferenceSet;
            this.superTypeNameSet = superTypeNameSet;
            this.descriptorSet = descriptorSet;
            this.annotationIndexer = new AnnotationIndexer(descriptorSet);
            this.fieldIndexer = new FieldIndexer(descriptorSet, this.annotationIndexer);
            this.methodIndexer = new MethodIndexer(descriptorSet, this.annotationIndexer);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            this.typeDeclarationSet.add(name);
            this.superTypeNameSet.add(superName);
            if (interfaces != null) {
                for (int i = interfaces.length - 1; i >= 0; --i) {
                    this.superTypeNameSet.add(interfaces[i]);
                }
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.fieldDeclarationSet.add(name);
            this.descriptorSet.add(signature == null ? desc : signature);
            return this.fieldIndexer;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<init>".equals(name)) {
                this.constructorDeclarationSet.add(this.name);
            } else if (!"<clinit>".equals(name)) {
                this.methodDeclarationSet.add(name);
            }
            this.descriptorSet.add(signature == null ? desc : signature);
            if (exceptions != null) {
                for (int i = exceptions.length - 1; i >= 0; --i) {
                    this.typeReferenceSet.add(exceptions[i]);
                }
            }
            return this.methodIndexer;
        }
    }
}

