/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.JadxArgs;
import jadx.core.codegen.AnnotationGen;
import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.EnumClassAttr;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.attributes.nodes.JadxWarn;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.parser.FieldInitAttr;
import jadx.core.utils.CodegenUtils;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassGen {
    private final ClassNode cls;
    private final ClassGen parentGen;
    private final AnnotationGen annotationGen;
    private final boolean fallback;
    private final boolean useImports;
    private final boolean showInconsistentCode;
    private final Set<ClassInfo> imports = new HashSet<ClassInfo>();
    private int clsDeclLine;

    public ClassGen(ClassNode cls, JadxArgs jadxArgs) {
        this(cls, null, jadxArgs.isUseImports(), jadxArgs.isFallbackMode(), jadxArgs.isShowInconsistentCode());
    }

    public ClassGen(ClassNode cls, ClassGen parentClsGen) {
        this(cls, parentClsGen, parentClsGen.useImports, parentClsGen.fallback, parentClsGen.showInconsistentCode);
    }

    public ClassGen(ClassNode cls, ClassGen parentClsGen, boolean useImports, boolean fallback, boolean showBadCode) {
        this.cls = cls;
        this.parentGen = parentClsGen;
        this.fallback = fallback;
        this.useImports = useImports;
        this.showInconsistentCode = showBadCode;
        this.annotationGen = new AnnotationGen(cls, this);
    }

    public ClassNode getClassNode() {
        return this.cls;
    }

    public CodeWriter makeClass() throws CodegenException {
        int importsCount;
        CodeWriter clsBody = new CodeWriter();
        this.addClassCode(clsBody);
        CodeWriter clsCode = new CodeWriter();
        if (!"".equals(this.cls.getPackage())) {
            clsCode.add("package ").add(this.cls.getPackage()).add(';');
            clsCode.newLine();
        }
        if ((importsCount = this.imports.size()) != 0) {
            ArrayList<ClassInfo> sortedImports = new ArrayList<ClassInfo>(this.imports);
            sortedImports.sort(Comparator.comparing(classInfo -> classInfo.getAlias().getFullName()));
            sortedImports.forEach(classInfo -> {
                clsCode.startLine("import ");
                ClassNode classNode = this.cls.root().resolveClass((ClassInfo)classInfo);
                if (classNode != null) {
                    clsCode.attachAnnotation(classNode);
                }
                clsCode.add(classInfo.getAlias().getFullName());
                clsCode.add(';');
            });
            clsCode.newLine();
            this.imports.clear();
        }
        clsCode.add(clsBody);
        return clsCode;
    }

    public void addClassCode(CodeWriter code) throws CodegenException {
        if (this.cls.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        CodegenUtils.addComments(code, this.cls);
        this.insertDecompilationProblems(code, this.cls);
        this.addClassDeclaration(code);
        this.addClassBody(code);
    }

    public void addClassDeclaration(CodeWriter clsCode) {
        AccessInfo af = this.cls.getAccessFlags();
        if (af.isInterface()) {
            af = af.remove(1024).remove(8);
        } else if (af.isEnum()) {
            af = af.remove(16).remove(1024).remove(8);
        }
        if (!this.cls.getAlias().isInner()) {
            af = af.remove(8).remove(2);
        }
        this.annotationGen.addForClass(clsCode);
        this.insertSourceFileInfo(clsCode, this.cls);
        this.insertRenameInfo(clsCode, this.cls);
        clsCode.startLine(af.makeString());
        if (af.isInterface()) {
            if (af.isAnnotation()) {
                clsCode.add('@');
            }
            clsCode.add("interface ");
        } else if (af.isEnum()) {
            clsCode.add("enum ");
        } else {
            clsCode.add("class ");
        }
        clsCode.attachDefinition(this.cls);
        clsCode.add(this.cls.getShortName());
        this.addGenericMap(clsCode, this.cls.getGenericMap());
        clsCode.add(' ');
        ArgType sup = this.cls.getSuperClass();
        if (sup != null && !sup.equals(ArgType.OBJECT) && !sup.getObject().equals(ArgType.ENUM.getObject())) {
            clsCode.add("extends ");
            this.useClass(clsCode, sup);
            clsCode.add(' ');
        }
        if (!this.cls.getInterfaces().isEmpty() && !af.isAnnotation()) {
            if (this.cls.getAccessFlags().isInterface()) {
                clsCode.add("extends ");
            } else {
                clsCode.add("implements ");
            }
            Iterator<ArgType> it = this.cls.getInterfaces().iterator();
            while (it.hasNext()) {
                ArgType interf = it.next();
                this.useClass(clsCode, interf);
                if (!it.hasNext()) continue;
                clsCode.add(", ");
            }
            if (!this.cls.getInterfaces().isEmpty()) {
                clsCode.add(' ');
            }
        }
    }

    public boolean addGenericMap(CodeWriter code, Map<ArgType, List<ArgType>> gmap) {
        if (gmap == null || gmap.isEmpty()) {
            return false;
        }
        code.add('<');
        int i = 0;
        for (Map.Entry<ArgType, List<ArgType>> e : gmap.entrySet()) {
            ArgType type = e.getKey();
            List<ArgType> list = e.getValue();
            if (i != 0) {
                code.add(", ");
            }
            if (type.isGenericType()) {
                code.add(type.getObject());
            } else {
                this.useClass(code, type);
            }
            if (list != null && !list.isEmpty()) {
                code.add(" extends ");
                Iterator<ArgType> it = list.iterator();
                while (it.hasNext()) {
                    ArgType g = it.next();
                    if (g.isGenericType()) {
                        code.add(g.getObject());
                    } else {
                        this.useClass(code, g);
                    }
                    if (!it.hasNext()) continue;
                    code.add(" & ");
                }
            }
            ++i;
        }
        code.add('>');
        return true;
    }

    public void addClassBody(CodeWriter clsCode) throws CodegenException {
        clsCode.add('{');
        this.clsDeclLine = clsCode.getLine();
        clsCode.incIndent();
        this.addFields(clsCode);
        this.addInnerClasses(clsCode, this.cls);
        this.addMethods(clsCode);
        clsCode.decIndent();
        clsCode.startLine('}');
    }

    private void addInnerClasses(CodeWriter code, ClassNode cls) throws CodegenException {
        for (ClassNode innerCls : cls.getInnerClasses()) {
            if (innerCls.contains(AFlag.DONT_GENERATE) || innerCls.contains(AFlag.ANONYMOUS_CLASS)) continue;
            ClassGen inClGen = new ClassGen(innerCls, this.getParentGen());
            code.newLine();
            inClGen.addClassCode(code);
            this.imports.addAll(inClGen.getImports());
        }
    }

    private boolean isInnerClassesPresents() {
        for (ClassNode innerCls : this.cls.getInnerClasses()) {
            if (innerCls.contains(AFlag.ANONYMOUS_CLASS)) continue;
            return true;
        }
        return false;
    }

    private void addMethods(CodeWriter code) {
        List<MethodNode> methods = ClassGen.sortMethodsByLine(this.cls.getMethods());
        for (MethodNode mth : methods) {
            if (mth.contains(AFlag.DONT_GENERATE)) continue;
            if (code.getLine() != this.clsDeclLine) {
                code.newLine();
            }
            int savedIndent = code.getIndent();
            try {
                this.addMethod(code, mth);
            }
            catch (Exception e) {
                code.newLine().add("/*");
                code.newLine().add(ErrorsCounter.methodError(mth, "Method generation error", e));
                code.newLine().add(Utils.getStackTrace(e));
                code.newLine().add("*/");
                code.setIndent(savedIndent);
            }
        }
    }

    private static List<MethodNode> sortMethodsByLine(List<MethodNode> methods) {
        ArrayList<MethodNode> out = new ArrayList<MethodNode>(methods);
        out.sort(Comparator.comparingInt(LineAttrNode::getSourceLine));
        return out;
    }

    private boolean isMethodsPresents() {
        for (MethodNode mth : this.cls.getMethods()) {
            if (mth.contains(AFlag.DONT_GENERATE)) continue;
            return true;
        }
        return false;
    }

    private void addMethod(CodeWriter code, MethodNode mth) throws CodegenException {
        if (mth.getAccessFlags().isAbstract() || mth.getAccessFlags().isNative()) {
            Object def;
            MethodGen mthGen = new MethodGen(this, mth);
            mthGen.addDefinition(code);
            if (this.cls.getAccessFlags().isAnnotation() && (def = this.annotationGen.getAnnotationDefaultValue(mth.getName())) != null) {
                code.add(" default ");
                this.annotationGen.encodeValue(code, def);
            }
            code.add(';');
        } else {
            MethodGen mthGen;
            CodegenUtils.addComments(code, mth);
            this.insertDecompilationProblems(code, mth);
            boolean badCode = mth.contains(AFlag.INCONSISTENT_CODE);
            if (badCode && this.showInconsistentCode) {
                code.startLine("/* Code decompiled incorrectly, please refer to instructions dump. */");
                mth.remove(AFlag.INCONSISTENT_CODE);
                badCode = false;
            }
            if ((mthGen = badCode || mth.contains(AType.JADX_ERROR) || this.fallback ? MethodGen.getFallbackMethodGen(mth) : new MethodGen(this, mth)).addDefinition(code)) {
                code.add(' ');
            }
            code.add('{');
            code.incIndent();
            this.insertSourceFileInfo(code, mth);
            if (this.fallback) {
                mthGen.addFallbackMethodCode(code);
            } else {
                mthGen.addInstructions(code);
            }
            code.decIndent();
            code.startLine('}');
        }
    }

    private void insertDecompilationProblems(CodeWriter code, AttrNode node) {
        List<JadxError> errors = node.getAll(AType.JADX_ERROR);
        List<JadxWarn> warns = node.getAll(AType.JADX_WARN);
        if (!errors.isEmpty()) {
            errors.forEach(err -> {
                code.startLine("/*  JADX ERROR: ").add(err.getError());
                Throwable cause = err.getCause();
                if (cause != null) {
                    code.incIndent();
                    Utils.appendStackTrace(code, cause);
                    code.decIndent();
                }
                code.add("*/");
            });
        }
        if (!warns.isEmpty()) {
            warns.forEach(warn -> code.startLine("/* JADX WARNING: ").addMultiLine(warn.getWarn()).add(" */"));
        }
    }

    private void addFields(CodeWriter code) throws CodegenException {
        this.addEnumFields(code);
        for (FieldNode f : this.cls.getFields()) {
            if (f.contains(AFlag.DONT_GENERATE)) continue;
            CodegenUtils.addComments(code, f);
            this.annotationGen.addForField(code, f);
            if (f.getFieldInfo().isRenamed()) {
                code.startLine("/* renamed from: ").add(f.getName()).add(" */");
            }
            code.startLine(f.getAccessFlags().makeString());
            this.useType(code, f.getType());
            code.add(' ');
            code.attachDefinition(f);
            code.add(f.getAlias());
            FieldInitAttr fv = f.get(AType.FIELD_INIT);
            if (fv != null) {
                code.add(" = ");
                if (fv.getValue() == null) {
                    code.add(TypeGen.literalToString(0L, f.getType(), this.cls));
                } else if (fv.getValueType() == FieldInitAttr.InitType.CONST) {
                    this.annotationGen.encodeValue(code, fv.getValue());
                } else if (fv.getValueType() == FieldInitAttr.InitType.INSN) {
                    InsnGen insnGen = this.makeInsnGen(fv.getInsnMth());
                    this.addInsnBody(insnGen, code, fv.getInsn());
                }
            }
            code.add(';');
        }
    }

    private boolean isFieldsPresents() {
        for (FieldNode field : this.cls.getFields()) {
            if (field.contains(AFlag.DONT_GENERATE)) continue;
            return true;
        }
        return false;
    }

    private void addEnumFields(CodeWriter code) throws CodegenException {
        EnumClassAttr enumFields = this.cls.get(AType.ENUM_CLASS);
        if (enumFields == null) {
            return;
        }
        InsnGen igen = null;
        Iterator<EnumClassAttr.EnumField> it = enumFields.getFields().iterator();
        while (it.hasNext()) {
            EnumClassAttr.EnumField f = it.next();
            code.startLine(f.getField().getAlias());
            ConstructorInsn constrInsn = f.getConstrInsn();
            if (constrInsn.getArgsCount() > f.getStartArg()) {
                if (igen == null) {
                    igen = this.makeInsnGen(enumFields.getStaticMethod());
                }
                MethodNode callMth = this.cls.dex().resolveMethod(constrInsn.getCallMth());
                igen.generateMethodArguments(code, constrInsn, f.getStartArg(), callMth);
            }
            if (f.getCls() != null) {
                code.add(' ');
                new ClassGen(f.getCls(), this).addClassBody(code);
            }
            if (!it.hasNext()) continue;
            code.add(',');
        }
        if (this.isMethodsPresents() || this.isFieldsPresents() || this.isInnerClassesPresents()) {
            if (enumFields.getFields().isEmpty()) {
                code.startLine();
            }
            code.add(';');
            if (this.isFieldsPresents()) {
                code.startLine();
            }
        }
    }

    private InsnGen makeInsnGen(MethodNode mth) {
        MethodGen mthGen = new MethodGen(this, mth);
        return new InsnGen(mthGen, false);
    }

    private void addInsnBody(InsnGen insnGen, CodeWriter code, InsnNode insn) {
        try {
            insnGen.makeInsn(insn, code, InsnGen.Flags.BODY_ONLY_NOWRAP);
        }
        catch (Exception e) {
            ErrorsCounter.classError(this.cls, "Failed to generate init code", e);
        }
    }

    public void useType(CodeWriter code, ArgType type) {
        PrimitiveType stype = type.getPrimitiveType();
        if (stype == null) {
            code.add(type.toString());
        } else if (stype == PrimitiveType.OBJECT) {
            if (type.isGenericType()) {
                code.add(type.getObject());
            } else {
                this.useClass(code, type);
            }
        } else if (stype == PrimitiveType.ARRAY) {
            this.useType(code, type.getArrayElement());
            code.add("[]");
        } else {
            code.add(stype.getLongName());
        }
    }

    public void useClass(CodeWriter code, ArgType type) {
        this.useClass(code, ClassInfo.extCls(this.cls.root(), type));
        ArgType[] generics = type.getGenericTypes();
        if (generics != null) {
            code.add('<');
            int len = generics.length;
            for (int i = 0; i < len; ++i) {
                ArgType gt;
                ArgType wt;
                if (i != 0) {
                    code.add(", ");
                }
                if ((wt = (gt = generics[i]).getWildcardType()) != null) {
                    code.add('?');
                    int bounds = gt.getWildcardBounds();
                    if (bounds == 0) continue;
                    code.add(bounds == -1 ? " super " : " extends ");
                    this.useType(code, wt);
                    continue;
                }
                this.useType(code, gt);
            }
            code.add('>');
        }
    }

    public void useClass(CodeWriter code, ClassInfo classInfo) {
        ClassNode classNode = this.cls.dex().resolveClass(classInfo);
        if (classNode != null) {
            code.attachAnnotation(classNode);
        }
        String baseClass = this.useClassInternal(this.cls.getAlias(), classInfo.getAlias());
        code.add(baseClass);
    }

    private String useClassInternal(ClassInfo useCls, ClassInfo extClsInfo) {
        String fullName = extClsInfo.getFullName();
        if (this.fallback || !this.useImports) {
            return fullName;
        }
        String shortName = extClsInfo.getShortName();
        if (extClsInfo.getPackage().equals("java.lang") && extClsInfo.getParentClass() == null) {
            return shortName;
        }
        if (ClassGen.isClassInnerFor(useCls, extClsInfo)) {
            return shortName;
        }
        if (ClassGen.isBothClassesInOneTopClass(useCls, extClsInfo)) {
            return shortName;
        }
        if (extClsInfo.getPackage().equals(useCls.getPackage()) && !extClsInfo.isInner()) {
            return shortName;
        }
        ClassNode classNode = this.cls.dex().resolveClass(extClsInfo);
        if (classNode != null && !classNode.getAccessFlags().isPublic()) {
            return shortName;
        }
        if (ClassGen.searchCollision(this.cls.dex(), useCls, extClsInfo)) {
            return fullName;
        }
        if (extClsInfo.isDefaultPackage()) {
            return shortName;
        }
        if (extClsInfo.getPackage().equals(useCls.getPackage())) {
            fullName = extClsInfo.getNameWithoutPackage();
        }
        for (ClassInfo importCls : this.getImports()) {
            if (importCls.equals(extClsInfo) || !importCls.getShortName().equals(shortName)) continue;
            if (extClsInfo.isInner()) {
                String parent = this.useClassInternal(useCls, extClsInfo.getParentClass().getAlias());
                return parent + "." + shortName;
            }
            return fullName;
        }
        this.addImport(extClsInfo);
        return shortName;
    }

    private void addImport(ClassInfo classInfo) {
        if (this.parentGen != null) {
            this.parentGen.addImport(classInfo.getAlias());
        } else {
            this.imports.add(classInfo);
        }
    }

    private Set<ClassInfo> getImports() {
        if (this.parentGen != null) {
            return this.parentGen.getImports();
        }
        return this.imports;
    }

    private static boolean isBothClassesInOneTopClass(ClassInfo useCls, ClassInfo extClsInfo) {
        ClassInfo a = useCls.getTopParentClass();
        ClassInfo b = extClsInfo.getTopParentClass();
        if (a != null) {
            return a.equals(b);
        }
        return useCls.equals(b);
    }

    private static boolean isClassInnerFor(ClassInfo inner, ClassInfo parent) {
        if (inner.isInner()) {
            ClassInfo p = inner.getParentClass();
            return p.equals(parent) || ClassGen.isClassInnerFor(p, parent);
        }
        return false;
    }

    private static boolean searchCollision(DexNode dex, ClassInfo useCls, ClassInfo searchCls) {
        if (useCls == null) {
            return false;
        }
        String shortName = searchCls.getShortName();
        if (useCls.getShortName().equals(shortName)) {
            return true;
        }
        ClassNode classNode = dex.resolveClass(useCls);
        if (classNode != null) {
            for (ClassNode inner : classNode.getInnerClasses()) {
                if (!inner.getShortName().equals(shortName) || inner.getAlias().equals(searchCls)) continue;
                return true;
            }
        }
        return ClassGen.searchCollision(dex, useCls.getParentClass(), searchCls);
    }

    private void insertSourceFileInfo(CodeWriter code, AttrNode node) {
        SourceFileAttr sourceFileAttr = node.get(AType.SOURCE_FILE);
        if (sourceFileAttr != null) {
            code.startLine("/* compiled from: ").add(sourceFileAttr.getFileName()).add(" */");
        }
    }

    private void insertRenameInfo(CodeWriter code, ClassNode cls) {
        ClassInfo classInfo = cls.getClassInfo();
        if (classInfo.isRenamed()) {
            code.startLine("/* renamed from: ").add(classInfo.getType().getObject()).add(" */");
        }
    }

    public ClassGen getParentGen() {
        return this.parentGen == null ? this : this.parentGen;
    }

    public AnnotationGen getAnnotationGen() {
        return this.annotationGen;
    }

    public boolean isFallbackMode() {
        return this.fallback;
    }
}

