/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.javax.security.auth.callback.AbstractCallbackHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SwingCallbackHandler
extends AbstractCallbackHandler {
    public SwingCallbackHandler() {
        super("SWING");
    }

    protected void handleChoice(final ChoiceCallback callback) throws IOException {
        final JDialog dialog = new JDialog();
        dialog.setResizable(false);
        Container content = dialog.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        content.setLayout(layout);
        JLabel prompt = new JLabel(callback.getPrompt(), 2);
        content.add((Component)prompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 5, 5));
        Object[] choices = callback.getChoices();
        final JList choicesList = new JList(choices);
        JScrollPane choicesPane = new JScrollPane(choicesList, 20, 30);
        final int defaultChoice = callback.getDefaultChoice();
        choicesList.setSelectedIndex(defaultChoice);
        choicesList.setSelectionMode(callback.allowMultipleSelections() ? 2 : 0);
        content.add((Component)choicesPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 5, 5));
        JPanel confirmButtons = new JPanel();
        confirmButtons.setLayout(new FlowLayout(2));
        JButton cancel = new JButton(this.messages.getString("callback.cancel"));
        JButton ok = new JButton(this.messages.getString("callback.ok"));
        confirmButtons.add(cancel);
        confirmButtons.add(ok);
        content.add((Component)confirmButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        dialog.getRootPane().setDefaultButton(ok);
        cancel.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                callback.setSelectedIndex(defaultChoice);
                dialog.setVisible(false);
                ChoiceCallback choiceCallback = callback;
                synchronized (choiceCallback) {
                    callback.notify();
                }
            }
        });
        ok.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                if (callback.allowMultipleSelections()) {
                    int[] indices = choicesList.getSelectedIndices();
                    if (indices != null && indices.length > 0) {
                        callback.setSelectedIndexes(indices);
                    } else {
                        callback.setSelectedIndex(defaultChoice);
                    }
                } else {
                    int selected = choicesList.getSelectedIndex();
                    if (selected != -1) {
                        callback.setSelectedIndex(selected);
                    } else {
                        callback.setSelectedIndex(defaultChoice);
                    }
                }
                dialog.setVisible(false);
                ChoiceCallback choiceCallback = callback;
                synchronized (choiceCallback) {
                    callback.notify();
                }
            }
        });
        dialog.pack();
        dialog.setSize(new Dimension(400, 400));
        dialog.setVisible(true);
        this.waitForInput(dialog, callback);
    }

    protected void handleConfirmation(final ConfirmationCallback callback) throws IOException {
        final JDialog dialog = new JDialog();
        switch (callback.getMessageType()) {
            case 2: {
                dialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 1: {
                dialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            case 0: {
                dialog.setTitle(this.messages.getString("callback.information"));
            }
        }
        Container content = dialog.getContentPane();
        content.setLayout(new GridBagLayout());
        String prompt = callback.getPrompt();
        if (prompt != null) {
            content.add((Component)new JLabel(prompt), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 25), 0, 0));
        }
        final String[] options = callback.getOptions();
        ActionListener listener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (options != null) {
                    int i = 0;
                    while (i < options.length) {
                        if (cmd.equals(options[i])) {
                            callback.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                } else if (cmd.equals("cancel")) {
                    callback.setSelectedIndex(2);
                } else if (cmd.equals("okay")) {
                    callback.setSelectedIndex(3);
                } else if (cmd.equals("yes")) {
                    callback.setSelectedIndex(0);
                } else if (cmd.equals("no")) {
                    callback.setSelectedIndex(1);
                }
                dialog.setVisible(false);
                ConfirmationCallback confirmationCallback = callback;
                synchronized (confirmationCallback) {
                    callback.notify();
                }
            }
        };
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        switch (callback.getOptionType()) {
            case 1: {
                JButton cancel = new JButton(this.messages.getString("callback.cancel"));
                buttons.add(cancel);
                cancel.setActionCommand("cancel");
                cancel.addActionListener(listener);
            }
            case 0: {
                JButton yes = new JButton(this.messages.getString("callback.yes"));
                JButton no = new JButton(this.messages.getString("callback.no"));
                buttons.add(no);
                buttons.add(yes);
                yes.setActionCommand("yes");
                yes.addActionListener(listener);
                no.setActionCommand("no");
                no.addActionListener(listener);
                dialog.getRootPane().setDefaultButton(yes);
                break;
            }
            case 2: {
                JButton okay = new JButton(this.messages.getString("callback.ok"));
                JButton cancel = new JButton(this.messages.getString("callback.cancel"));
                buttons.add(cancel);
                buttons.add(okay);
                okay.setActionCommand("okay");
                okay.addActionListener(listener);
                cancel.setActionCommand("cancel");
                cancel.addActionListener(listener);
                dialog.getRootPane().setDefaultButton(okay);
                break;
            }
            case -1: {
                int i = 0;
                while (i < options.length) {
                    JButton button = new JButton(options[i]);
                    buttons.add(button);
                    button.setActionCommand(options[i]);
                    button.addActionListener(listener);
                    if (i == options.length - 1) {
                        dialog.getRootPane().setDefaultButton(button);
                    }
                    ++i;
                }
                break;
            }
        }
        content.add((Component)buttons, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 14, 1, new Insets(5, 5, 5, 5), 0, 0));
        dialog.setResizable(false);
        dialog.pack();
        dialog.setVisible(true);
        this.waitForInput(dialog, callback);
    }

    protected void handleLanguage(LanguageCallback callback) throws IOException {
        Locale locale = Locale.getDefault();
        Locale[] locales = Locale.getAvailableLocales();
        String[] localeNames = new String[locales.length + 1];
        int i = 0;
        while (i < locales.length) {
            localeNames[i + 1] = locales[i].getDisplayLanguage(locales[i]);
            String country = locales[i].getDisplayCountry(locales[i]);
            if (country.length() > 0) {
                int n = i + 1;
                localeNames[n] = String.valueOf(localeNames[n]) + " (" + country + ")";
            }
            if (locales[i].equals(locale)) {
            }
            ++i;
        }
        locales[0] = locale;
        localeNames[0] = locale.getDisplayLanguage(locale);
        String country = locale.getDisplayCountry(locale);
        if (country.length() > 0) {
            localeNames[0] = String.valueOf(localeNames[0]) + " (" + country + ")";
        }
        ChoiceCallback cb = new ChoiceCallback(this.messages.getString("callback.language"), localeNames, 0, false);
        this.handleChoice(cb);
        int selected = cb.getSelectedIndexes()[0];
        if (selected > 0) {
            callback.setLocale(locales[selected - 1]);
        } else {
            callback.setLocale(locale);
        }
    }

    protected void handleName(final NameCallback callback) throws IOException {
        final JDialog dialog = new JDialog();
        Container content = dialog.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)new JLabel(callback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(10, 10, 15, 5), 0, 0));
        final JTextField name = new JTextField();
        name.setColumns(20);
        String _name = callback.getDefaultName();
        if (_name != null) {
            name.setText(_name);
        }
        content.add((Component)name, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 15, 10), 0, 0));
        ActionListener listener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("okay")) {
                    callback.setName(name.getText());
                }
                dialog.setVisible(false);
                NameCallback nameCallback = callback;
                synchronized (nameCallback) {
                    callback.notify();
                }
            }
        };
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        JButton cancel = new JButton(this.messages.getString("callback.cancel"));
        JButton okay = new JButton(this.messages.getString("callback.ok"));
        cancel.setActionCommand("cancel");
        cancel.addActionListener(listener);
        buttons.add(cancel);
        okay.setActionCommand("okay");
        okay.addActionListener(listener);
        buttons.add(okay);
        content.add((Component)buttons, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        dialog.setResizable(false);
        dialog.pack();
        dialog.setVisible(true);
        dialog.getRootPane().setDefaultButton(okay);
        this.waitForInput(dialog, callback);
    }

    protected void handlePassword(final PasswordCallback callback) throws IOException {
        final JDialog dialog = new JDialog();
        Container content = dialog.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)new JLabel(callback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(10, 10, 15, 5), 0, 0));
        final JPasswordField password = new JPasswordField();
        password.setColumns(20);
        password.setEchoChar(callback.isEchoOn() ? (char)'\u0000' : '\u2022');
        content.add((Component)password, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 15, 10), 0, 0));
        ActionListener listener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("okay")) {
                    callback.setPassword(password.getPassword());
                }
                dialog.setVisible(false);
                PasswordCallback passwordCallback = callback;
                synchronized (passwordCallback) {
                    callback.notify();
                }
            }
        };
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        JButton cancel = new JButton(this.messages.getString("callback.cancel"));
        JButton okay = new JButton(this.messages.getString("callback.ok"));
        cancel.setActionCommand("cancel");
        cancel.addActionListener(listener);
        buttons.add(cancel);
        okay.setActionCommand("okay");
        okay.addActionListener(listener);
        buttons.add(okay);
        content.add((Component)buttons, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        dialog.setResizable(false);
        dialog.pack();
        dialog.setVisible(true);
        dialog.getRootPane().setDefaultButton(okay);
        this.waitForInput(dialog, callback);
    }

    protected void handleTextInput(final TextInputCallback callback) throws IOException {
        final JDialog dialog = new JDialog();
        Container content = dialog.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)new JLabel(callback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 15, 5), 0, 0));
        final JTextArea text = new JTextArea(24, 80);
        text.setEditable(true);
        String _text = callback.getDefaultText();
        if (_text != null) {
            text.setText(_text);
        }
        text.setFont(new Font("Monospaced", 0, 12));
        JScrollPane textPane = new JScrollPane(text, 20, 30);
        content.add((Component)textPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        ActionListener listener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("okay")) {
                    callback.setText(text.getText());
                }
                dialog.setVisible(false);
                TextInputCallback textInputCallback = callback;
                synchronized (textInputCallback) {
                    callback.notify();
                }
            }
        };
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        JButton cancel = new JButton(this.messages.getString("callback.cancel"));
        JButton okay = new JButton(this.messages.getString("callback.ok"));
        cancel.setActionCommand("cancel");
        cancel.addActionListener(listener);
        buttons.add(cancel);
        okay.setActionCommand("okay");
        okay.addActionListener(listener);
        buttons.add(okay);
        content.add((Component)buttons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.getRootPane().setDefaultButton(okay);
        this.waitForInput(dialog, callback);
    }

    protected void handleTextOutput(final TextOutputCallback callback) throws IOException {
        final JDialog dialog = new JDialog();
        switch (callback.getMessageType()) {
            case 2: {
                dialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 1: {
                dialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            case 0: {
                dialog.setTitle(this.messages.getString("callback.information"));
            }
        }
        Container content = dialog.getContentPane();
        content.setLayout(new GridBagLayout());
        JTextArea text = new JTextArea(24, 80);
        text.setEditable(false);
        text.setText(callback.getMessage());
        text.setFont(new Font("Monospaced", 0, 12));
        JScrollPane textPane = new JScrollPane(text, 20, 30);
        content.add((Component)textPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        ActionListener listener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                dialog.setVisible(false);
                TextOutputCallback textOutputCallback = callback;
                synchronized (textOutputCallback) {
                    callback.notify();
                }
            }
        };
        JButton okay = new JButton(this.messages.getString("callback.ok"));
        okay.setActionCommand("okay");
        okay.addActionListener(listener);
        content.add((Component)okay, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.getRootPane().setDefaultButton(okay);
        this.waitForInput(dialog, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForInput(JDialog dialog, Callback callback) {
        Callback callback2 = callback;
        synchronized (callback2) {
            while (dialog.isVisible()) {
                try {
                    callback.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        dialog.dispose();
    }
}

