/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.lang;

import org.jvnet.jaxb2_commons.lang.MergeFrom;
import org.jvnet.jaxb2_commons.lang.MergeStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;

public class DefaultMergeStrategy
implements MergeStrategy {
    public static final MergeStrategy INSTANCE = new DefaultMergeStrategy();

    protected Object mergeInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Object leftValue, Object rightValue) {
        if (leftValue == null) {
            return rightValue;
        }
        if (rightValue == null) {
            return leftValue;
        }
        if (leftValue instanceof MergeFrom) {
            Object newInstance = ((MergeFrom)leftValue).createNewInstance();
            ((MergeFrom)newInstance).mergeFrom(leftLocator, rightLocator, leftValue, rightValue, this);
            return newInstance;
        }
        if (rightValue instanceof MergeFrom) {
            Object newInstance = ((MergeFrom)rightValue).createNewInstance();
            ((MergeFrom)newInstance).mergeFrom(leftLocator, rightLocator, leftValue, rightValue, this);
            return newInstance;
        }
        return leftValue;
    }

    public Object merge(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Class<?> lhsClass = left.getClass();
        if (!lhsClass.isArray()) {
            return this.mergeInternal(leftLocator, rightLocator, left, right);
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        if (left instanceof long[]) {
            return this.merge(leftLocator, rightLocator, (long[])left, (long[])right);
        }
        if (left instanceof int[]) {
            return this.merge(leftLocator, rightLocator, (int[])left, (int[])right);
        }
        if (left instanceof short[]) {
            return this.merge(leftLocator, rightLocator, (short[])left, (short[])right);
        }
        if (left instanceof char[]) {
            return this.merge(leftLocator, rightLocator, (char[])left, (char[])right);
        }
        if (left instanceof byte[]) {
            return this.merge(leftLocator, rightLocator, (byte[])left, (byte[])right);
        }
        if (left instanceof double[]) {
            return this.merge(leftLocator, rightLocator, (double[])left, (double[])right);
        }
        if (left instanceof float[]) {
            return this.merge(leftLocator, rightLocator, (float[])left, (float[])right);
        }
        if (left instanceof boolean[]) {
            return this.merge(leftLocator, rightLocator, (boolean[])left, (boolean[])right);
        }
        return this.merge(leftLocator, rightLocator, (Object[])left, (Object[])right);
    }

    public long merge(ObjectLocator leftLocator, ObjectLocator rightLocator, long leftValue, long rightValue) {
        return leftValue != 0L ? leftValue : rightValue;
    }

    public int merge(ObjectLocator leftLocator, ObjectLocator rightLocator, int leftValue, int rightValue) {
        return leftValue != 0 ? leftValue : rightValue;
    }

    public short merge(ObjectLocator leftLocator, ObjectLocator rightLocator, short leftValue, short rightValue) {
        return leftValue != 0 ? leftValue : rightValue;
    }

    public char merge(ObjectLocator leftLocator, ObjectLocator rightLocator, char leftValue, char rightValue) {
        return leftValue != '\u0000' ? leftValue : rightValue;
    }

    public byte merge(ObjectLocator leftLocator, ObjectLocator rightLocator, byte leftValue, byte rightValue) {
        return leftValue != 0 ? leftValue : rightValue;
    }

    public double merge(ObjectLocator leftLocator, ObjectLocator rightLocator, double leftValue, double rightValue) {
        return leftValue != 0.0 ? leftValue : rightValue;
    }

    public float merge(ObjectLocator leftLocator, ObjectLocator rightLocator, float leftValue, float rightValue) {
        return leftValue != 0.0f ? leftValue : rightValue;
    }

    public boolean merge(ObjectLocator leftLocator, ObjectLocator rightLocator, boolean leftValue, boolean rightValue) {
        return leftValue ? leftValue : rightValue;
    }

    public Object[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, Object[] leftValue, Object[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public long[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, long[] leftValue, long[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public int[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, int[] leftValue, int[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public short[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, short[] leftValue, short[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public char[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, char[] leftValue, char[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public byte[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, byte[] leftValue, byte[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public double[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, double[] leftValue, double[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public float[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, float[] leftValue, float[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }

    public boolean[] merge(ObjectLocator leftLocator, ObjectLocator rightLocator, boolean[] leftValue, boolean[] rightValue) {
        if (leftValue != null) {
            if (rightValue != null) {
                return leftValue.length > 0 ? leftValue : rightValue;
            }
            return leftValue;
        }
        return rightValue;
    }
}

