/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.concurrent.SubjectAwareExecutorService;

public class SubjectAwareScheduledExecutorService
extends SubjectAwareExecutorService
implements ScheduledExecutorService {
    private ScheduledExecutorService targetScheduledExecutorService;

    public SubjectAwareScheduledExecutorService() {
    }

    public SubjectAwareScheduledExecutorService(ScheduledExecutorService target) {
        this.setTargetScheduledExecutorService(target);
    }

    public ScheduledExecutorService getTargetScheduledExecutorService() {
        return this.targetScheduledExecutorService;
    }

    public void setTargetScheduledExecutorService(ScheduledExecutorService targetScheduledExecutorService) {
        super.setTargetExecutorService(targetScheduledExecutorService);
        this.targetScheduledExecutorService = targetScheduledExecutorService;
    }

    @Override
    public void setTargetExecutor(Executor targetExecutor) {
        if (!(targetExecutor instanceof ScheduledExecutorService)) {
            String msg = "The " + this.getClass().getName() + " implementation only accepts " + ScheduledExecutorService.class.getName() + " target instances.";
            throw new IllegalArgumentException(msg);
        }
        super.setTargetExecutorService((ScheduledExecutorService)targetExecutor);
    }

    @Override
    public void setTargetExecutorService(ExecutorService targetExecutorService) {
        if (!(targetExecutorService instanceof ScheduledExecutorService)) {
            String msg = "The " + this.getClass().getName() + " implementation only accepts " + ScheduledExecutorService.class.getName() + " target instances.";
            throw new IllegalArgumentException(msg);
        }
        super.setTargetExecutorService(targetExecutorService);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Runnable work = this.associateWithSubject(command);
        return this.targetScheduledExecutorService.schedule(work, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Callable<V> work = this.associateWithSubject(callable);
        return this.targetScheduledExecutorService.schedule(work, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Runnable work = this.associateWithSubject(command);
        return this.targetScheduledExecutorService.scheduleAtFixedRate(work, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Runnable work = this.associateWithSubject(command);
        return this.targetScheduledExecutorService.scheduleWithFixedDelay(work, initialDelay, delay, unit);
    }
}

