from typing import Union, Callable, Optional, NamedTuple, List

from Crypto.Math.Numbers import Integer

class UnsupportedEccFeature(ValueError): ...
class EccPoint(object):
    def __init__(self, x: Union[int, Integer], y: Union[int, Integer]) -> None: ...
    def set(self, point: EccPoint) -> EccPoint: ...
    def __eq__(self, point: object) -> bool: ...
    def __neg__(self) -> EccPoint: ...
    def copy(self) -> EccPoint: ...
    def is_point_at_infinity(self) -> bool: ...
    @staticmethod
    def point_at_infinity() -> EccPoint: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...
    def double(self) -> EccPoint: ...
    def __iadd__(self, point: EccPoint) -> EccPoint: ...
    def __add__(self, point: EccPoint) -> EccPoint: ...
    def __mul__(self, scalar: int) -> EccPoint: ...

class EccKey(object):
    curve: str
    def __init__(self, *, curve: str = ..., d: int = ..., point: EccPoint = ...) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __repr__(self) -> str: ...
    def has_private(self) -> bool: ...
    @property
    def d(self) -> int: ...
    @property
    def pointQ(self) -> EccPoint: ...
    def public_key(self) -> EccKey: ...
    def export_key(self, **kwargs: Union[str, bytes, bool]) -> str: ...

_Curve = NamedTuple("_Curve", [	('p', Integer),
				('b', Integer),
				('order', Integer),
				('Gx', Integer),
				('Gy', Integer),
				('G', EccPoint),
				('names', List[str]),
				('oid', str)
				])

_curve : _Curve

def generate(**kwargs: Union[str, Callable]) -> EccKey: ...
def construct(**kwargs: Union[str, int]) -> EccKey: ...
def import_key(encoded: Union[bytes, str], passphrase: Optional[str]=None) -> EccKey: ...
