'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) selectionbox.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.TH iwidgets::selectionbox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::selectionbox \- Create and manipulate a selection box widget
.SH SYNOPSIS
\fBiwidgets::selectionbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Selectionbox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground  background         borderWidth     cursor
exportSelection   foreground         highlightColor  highlightThickness
insertBackground  insertBorderWidth  insertOffTime   insertOnTime
insertWidth       relief             repeatDelay     repeatInterval
selectBackground  selectBorderWidth  selectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "entryfield" widget class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR	\fBlabelMargin\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBdblClickCommand\fR	\fBhscrollMode\fR	\fBsbWidth\fR	\fBscrollMargin\fR
\fBtextBackground\fR	\fBtextFont\fR	\fBvscrollMode\fR
.fi
.LP
See the "scrolledlistbox" widget class manual entry for details on the above
associated options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBchildSitePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-childsitepos\fR
.fi
.IP
Specifies the position of the child site in the selection box: \fBn\fR, 
\fBs\fR, \fBe\fR, \fBw\fR, or \fB\fR.  The default is center
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the selection box.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 320 pixels.
.LP
.nf
Name:	\fBitemsCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-itemscommand\fR
.fi
.IP
Specifies a command to be evaluated following selection of an item.
.LP
.nf
Name:	\fBitemsLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-itemslabel\fR
.fi
.IP
Specifies the text of the label for the items list.  The default is "List".
.LP
.nf
Name:	\fBitemsLabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-itemslabelpos\fR
.fi
.IP
Specifies the position of the label along the side of the items
list: \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, 
or \fBnw\fR.  The default is nw.
.LP
.nf
Name:	\fBitemsOn\fR
Class:	\fBItemsOn\fR
Command-Line Switch:	\fB-itemson\fR
.fi
.IP
Specifies whether or not to display the items list in any
of the forms acceptable to \fBTcl_GetBoolean\fR.  The default is true.
.LP
.nf
Name:	\fBmargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-margin\fR
.fi
.IP
Specifies distance between the items list and selection entry in any of
the forms acceptable to \fBTk_GetPixels\fR.  The default is 7 pixels.
.LP
.nf
Name:	\fBselectionCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectioncommand\fR
.fi
.IP
Specifies a Tcl procedure to be associated with a return key press event
in the selection entry field.
.LP
.nf
Name:	\fBselectionLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-selectionlabel\fR
.fi
.IP
Specifies the text of the label for the selection entry field.  The default
is "Selection".
.LP
.nf
Name:	\fBselectionLabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-selectionlabelpos\fR
.fi
.IP
Specifies the position of the label along the side of the selection: 
\fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR, \fBs\fR, \fBsw\fR, \fBw\fR, 
or \fBnw\fR.  The default is nw.
.LP
.nf
Name:	\fBselectionOn\fR
Class:	\fBSelectionOn\fR
Command-Line Switch:	\fB-selectionon\fR
.fi
.IP
Specifies whether or not to display the selection entry in any
of the forms acceptable to \fBTcl_GetBoolean\fR.  The default is true.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the selection box.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 260 pixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::selectionbox\fR command creates a scrolled list of items and
a selection entry field.  The user may choose any of the items displayed
in the scrolled list of alternatives and the selection field will be
filled with the choice.  The user is also free to enter a new value in
the selection entry field.  Both the list and entry areas have labels.
A child site is also provided in which the user may create other widgets
to be used in conjunction with the selection box.

.SH "METHODS"
.PP
The \fBiwidgets::selectionbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  

.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBcurselection\fR	\fBdelete\fR	\fBindex\fR	\fBnearest\fR
\fBscan\fR	\fBselection\fR	\fBsize\fR
.fi
.LP
See the "listbox" widget class manual entry for details on the 
associated methods.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::selectionbox\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the child site widget path name.
.TP
\fIpathName \fBclear\fR \fIcomponent\fR
Delete the contents of either the selection entry widget or 
items list.  The \fIcomponent\fR argument may be either \fBitems\fR
or \fBselection\fR.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::selectionbox\fR
command.
.TP
\fIpathName \fBget\fR
Returns the current value of the selection entry widget.
.TP
\fIpathName \fBinsert\fR \fIcomponent\fR \fIargs\fR
Insert element(s) into either the selection entry widget or
items list.  The \fIcomponent\fR argument may be either \fBitems\fR
or \fBselection\fR.  The \fIargs\fR follow the rules of either an entry
or list widget depending on the \fIcomponent\fR value.
.TP
\fIpathName \fBselectitem\fR
Replace the selection entry field contents with the currently 
selected items value.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBchildsite\fR
Class:	\fBFrame\fR
.fi
.IP
The childsite component is the user child site for the selection box.  See 
the "frame" widget manual entry for details on the childsite component item.
.LP
.nf
Name:	\fBitems\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The items component provides the scrolled list box of items for the selection
box.  See the "scrolledlistbox" widget manual entry for details on the 
items component item.
.LP
.nf
Name:	\fBselection\fR
Class:	\fBEntryfield\fR
.fi
.IP
The selection component provides the entry field in the selection box for
display of the selected item in the items component.  See the "entryfield" 
widget manual entry for details on the selection component item.
.fi

.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 option add *textBackground white

 iwidgets::selectionbox .sb -items {Hello {Out There} World}
 pack .sb -padx 10 -pady 10 -fill both -expand yes 

 set cs [label [.sb childsite].label -text "Child Site"]
 pack $cs -fill x -padx 10 -pady 10

 .sb insert items 2 {Cruel Cruel}

 .sb selection set 1
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
selectionbox, widget
