/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.users.User;

public class ContextUserAuthManager {
    private int contextId;
    private List<User> users;

    public ContextUserAuthManager(int contextId) {
        this.contextId = contextId;
        this.users = new ArrayList<User>();
    }

    public UsersTableModel getUsersModel() {
        return new UsersTableModel(this.users);
    }

    public int getContextId() {
        return this.contextId;
    }

    public List<User> getUsers() {
        return Collections.unmodifiableList(this.users);
    }

    public void setUsers(List<User> users) {
        this.users = new ArrayList<User>(users);
    }

    public void addUser(User user) {
        this.users.add(user);
    }

    public void removeUser(User user) {
        this.users.remove(user);
    }

    public User getUserById(int id) {
        for (User u : this.users) {
            if (u.getId() != id) continue;
            return u;
        }
        return null;
    }

    public boolean removeUserById(int id) {
        Iterator<User> it = this.users.iterator();
        while (it.hasNext()) {
            if (it.next().getId() != id) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void removeAllUsers() {
        this.users.clear();
    }
}

