/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.helper.DateUtil;

public class CsvBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvBuilder.class);
    private static final String LINE_ENDING = "\r\n";
    private static final String SEPARATOR = ";";
    private StringBuilder builder = new StringBuilder();

    private void addLineEnding() {
        this.builder.append(LINE_ENDING);
    }

    private void addSeparator() {
        this.builder.append(SEPARATOR);
    }

    private SortedSet<Method> getSortedMethods(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        TreeSet<Method> methods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                if (m1.getName().equals("getAttributes") && !m1.getName().equals(m2.getName())) {
                    return 1;
                }
                if (m2.getName().equals("getAttributes") && !m1.getName().equals(m2.getName())) {
                    return -1;
                }
                return m1.getName().compareTo(m2.getName());
            }
        });
        methods.addAll(Arrays.asList(methodArray));
        return methods;
    }

    public void addLine(Object object) {
        SortedSet<Method> methods = this.getSortedMethods(object);
        for (Method method : methods) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            try {
                Object value;
                if (method.getReturnType().equals(Boolean.TYPE)) {
                    this.builder.append(method.invoke(object, new Object[0]));
                    this.addSeparator();
                    continue;
                }
                if (method.getReturnType().equals(Integer.TYPE)) {
                    this.builder.append(method.invoke(object, new Object[0]));
                    this.addSeparator();
                    continue;
                }
                if (method.getReturnType().equals(Long.TYPE)) {
                    this.builder.append(method.invoke(object, new Object[0]));
                    this.addSeparator();
                    continue;
                }
                if (method.getReturnType().equals(Double.TYPE)) {
                    this.builder.append(method.invoke(object, new Object[0]));
                    this.addSeparator();
                    continue;
                }
                if (method.getReturnType().equals(String.class)) {
                    this.builder.append((String)method.invoke(object, new Object[0]));
                    this.addSeparator();
                    continue;
                }
                if (method.getReturnType().equals(Date.class)) {
                    value = (Date)method.invoke(object, new Object[0]);
                    this.builder.append(DateUtil.formatDate((Date)value));
                    this.addSeparator();
                    continue;
                }
                if (!method.getReturnType().equals(Map.class) || (value = (Map)method.invoke(object, new Object[0])) == null) continue;
                try {
                    String map = Context.getObjectMapper().writeValueAsString(value);
                    map = map.replaceAll("[\\{\\}\"]", "");
                    map = map.replaceAll(",", " ");
                    this.builder.append(map);
                    this.addSeparator();
                }
                catch (JsonProcessingException e) {
                    LOGGER.warn("Map JSON formatting error", (Throwable)e);
                }
            }
            catch (IllegalAccessException | InvocationTargetException error) {
                LOGGER.warn("Reflection invocation error", (Throwable)error);
            }
        }
        this.addLineEnding();
    }

    public void addHeaderLine(Object object) {
        SortedSet<Method> methods = this.getSortedMethods(object);
        for (Method method : methods) {
            String name;
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || (name = Introspector.decapitalize(method.getName().substring(3))).equals("class")) continue;
            this.builder.append(name);
            this.addSeparator();
        }
        this.addLineEnding();
    }

    public void addArray(Collection<?> array) {
        block12: for (Object object : array) {
            switch (object.getClass().getSimpleName().toLowerCase()) {
                case "string": {
                    this.builder.append(object.toString());
                    this.addLineEnding();
                    continue block12;
                }
                case "long": {
                    this.builder.append((Long)object);
                    this.addLineEnding();
                    continue block12;
                }
                case "double": {
                    this.builder.append((Double)object);
                    this.addLineEnding();
                    continue block12;
                }
                case "boolean": {
                    this.builder.append((Boolean)object);
                    this.addLineEnding();
                    continue block12;
                }
            }
            this.addLine(object);
        }
    }

    public String build() {
        return this.builder.toString();
    }
}

