/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.traccar.BaseFrameDecoder;

public class Gl200FrameDecoder
extends BaseFrameDecoder {
    private static final int MINIMUM_LENGTH = 11;
    private static final Set<String> BINARY_HEADERS = new HashSet<String>(Arrays.asList("+RSP", "+BSP", "+EVT", "+BVT", "+INF", "+BNF", "+HBD", "+CRD", "+BRD"));

    public static boolean isBinary(ByteBuf buf) {
        String header = buf.toString(buf.readerIndex(), 4, StandardCharsets.US_ASCII);
        if (header.equals("+ACK")) {
            return buf.getByte(buf.readerIndex() + header.length()) != 58;
        }
        return BINARY_HEADERS.contains(header);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 11) {
            return null;
        }
        if (Gl200FrameDecoder.isBinary(buf)) {
            int length;
            switch (buf.toString(buf.readerIndex(), 4, StandardCharsets.US_ASCII)) {
                case "+ACK": {
                    length = buf.getUnsignedByte(buf.readerIndex() + 6);
                    break;
                }
                case "+INF": 
                case "+BNF": {
                    length = buf.getUnsignedShort(buf.readerIndex() + 7);
                    break;
                }
                case "+HBD": {
                    length = buf.getUnsignedByte(buf.readerIndex() + 5);
                    break;
                }
                case "+CRD": 
                case "+BRD": {
                    length = buf.getUnsignedShort(buf.readerIndex() + 6);
                    break;
                }
                default: {
                    length = buf.getUnsignedShort(buf.readerIndex() + 9);
                }
            }
            if (buf.readableBytes() >= length) {
                return buf.readRetainedSlice(length);
            }
        } else {
            int endIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)36);
            if (endIndex < 0) {
                endIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0);
            }
            if (endIndex > 0) {
                ByteBuf frame = buf.readRetainedSlice(endIndex - buf.readerIndex());
                buf.readByte();
                return frame;
            }
        }
        return null;
    }
}

