/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.BaseEventHandler;
import org.traccar.Context;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class DriverEventHandler
extends BaseEventHandler {
    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        if (!Context.getIdentityManager().isLatestPosition(position)) {
            return null;
        }
        String driverUniqueId = position.getString("driverUniqueId");
        if (driverUniqueId != null) {
            String oldDriverUniqueId = null;
            Position lastPosition = Context.getIdentityManager().getLastPosition(position.getDeviceId());
            if (lastPosition != null) {
                oldDriverUniqueId = lastPosition.getString("driverUniqueId");
            }
            if (!driverUniqueId.equals(oldDriverUniqueId)) {
                Event event = new Event("driverChanged", position.getDeviceId(), position.getId());
                event.set("driverUniqueId", driverUniqueId);
                return Collections.singletonMap(event, position);
            }
        }
        return null;
    }
}

