/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.util.List;
import java.util.Map;
import org.restlet.data.Cookie;
import org.restlet.engine.header.HeaderWriter;

public class CookieWriter
extends HeaderWriter<Cookie> {
    public static void getCookies(List<Cookie> source, Map<String, Cookie> destination) {
        for (Cookie cookie : source) {
            if (!destination.containsKey(cookie.getName())) continue;
            destination.put(cookie.getName(), cookie);
        }
    }

    public static String write(Cookie cookie) throws IllegalArgumentException {
        return new CookieWriter().append(cookie).toString();
    }

    public static String write(List<Cookie> cookies) {
        return new CookieWriter().append(cookies).toString();
    }

    public CookieWriter append(Cookie cookie) throws IllegalArgumentException {
        String name = cookie.getName();
        String value = cookie.getValue();
        int version = cookie.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Can't write cookie. Invalid name detected");
        }
        this.appendValue(name, 0).append('=');
        if (value != null && value.length() > 0) {
            this.appendValue(value, version);
        }
        if (version > 0) {
            String domain;
            String path = cookie.getPath();
            if (path != null && path.length() > 0) {
                this.append("; $Path=");
                this.appendQuotedString(path);
            }
            if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                this.append("; $Domain=");
                this.appendQuotedString(domain);
            }
        }
        return this;
    }

    public CookieWriter append(List<Cookie> cookies) {
        if (cookies != null && !cookies.isEmpty()) {
            for (int i = 0; i < cookies.size(); ++i) {
                Cookie cookie = cookies.get(i);
                if (i == 0) {
                    if (cookie.getVersion() > 0) {
                        ((HeaderWriter)this.append("$Version=\"")).append(cookie.getVersion()).append("\"; ");
                    }
                } else {
                    this.append("; ");
                }
                this.append(cookie);
            }
        }
        return this;
    }

    public CookieWriter appendValue(String value, int version) {
        if (version == 0) {
            this.append(value.toString());
        } else {
            this.appendQuotedString(value);
        }
        return this;
    }
}

