/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.prometheus.collector.SolrCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SolrExporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] ARG_PORT_FLAGS = new String[]{"-p", "--port"};
    private static final String ARG_PORT_METAVAR = "PORT";
    private static final String ARG_PORT_DEST = "port";
    private static final Integer ARG_PORT_DEFAULT = 9983;
    private static final String ARG_PORT_HELP = "Specify the solr-exporter HTTP listen port; default is " + String.valueOf(ARG_PORT_DEFAULT) + ".";
    private static final String[] ARG_BASE_URL_FLAGS = new String[]{"-b", "--baseurl"};
    private static final String ARG_BASE_URL_METAVAR = "BASE_URL";
    private static final String ARG_BASE_URL_DEST = "baseUrl";
    private static final String ARG_BASE_URL_DEFAULT = "";
    private static final String ARG_BASE_URL_HELP = "Specify the Solr base URL when connecting to Solr in standalone mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'http://localhost:8983/solr'.";
    private static final String[] ARG_ZK_HOST_FLAGS = new String[]{"-z", "--zkhost"};
    private static final String ARG_ZK_HOST_METAVAR = "ZK_HOST";
    private static final String ARG_ZK_HOST_DEST = "zkHost";
    private static final String ARG_ZK_HOST_DEFAULT = "";
    private static final String ARG_ZK_HOST_HELP = "Specify the ZooKeeper connection string when connecting to Solr in SolrCloud mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'localhost:2181/solr'.";
    private static final String[] ARG_CONFIG_FLAGS = new String[]{"-f", "--config-file"};
    private static final String ARG_CONFIG_METAVAR = "CONFIG";
    private static final String ARG_CONFIG_DEST = "configFile";
    private static final String ARG_CONFIG_DEFAULT = "./conf/solr-exporter-config.xml";
    private static final String ARG_CONFIG_HELP = "Specify the configuration file; default is ./conf/solr-exporter-config.xml.";
    private static final String[] ARG_NUM_THREADS_FLAGS = new String[]{"-n", "--num-threads"};
    private static final String ARG_NUM_THREADS_METAVAR = "NUM_THREADS";
    private static final String ARG_NUM_THREADS_DEST = "numThreads";
    private static final Integer ARG_NUM_THREADS_DEFAULT = 1;
    private static final String ARG_NUM_THREADS_HELP = "Specify the number of threads. solr-exporter creates a thread pools for request to Solr. If you need to improve request latency via solr-exporter, you can increase the number of threads; default is " + String.valueOf(ARG_NUM_THREADS_DEFAULT) + ".";
    private int port;
    private SolrClient solrClient;
    private XmlConfigFile config;
    private int numThreads;
    CollectorRegistry registry = new CollectorRegistry();
    private HTTPServer httpServer;
    private SolrCollector collector;
    private SolrResourceLoader loader;
    public static final Counter scrapeErrorTotal = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("solr_exporter_scrape_error_total")).help("Number of scrape error.")).register();

    public SolrExporter(int port, String connStr, Path configPath, int numThreads) throws ParserConfigurationException, SAXException, IOException {
        this(port, SolrExporter.createClient(connStr), configPath, numThreads);
    }

    public SolrExporter(int port, SolrClient solrClient, Path configPath, int numThreads) throws ParserConfigurationException, SAXException, IOException {
        this.loader = new SolrResourceLoader(configPath.getParent());
        this.port = port;
        this.solrClient = solrClient;
        this.config = new XmlConfigFile(this.loader, configPath.getFileName().toString());
        this.numThreads = numThreads;
    }

    public void start() throws IOException {
        this.collector = new SolrCollector(this.solrClient, this.config, this.numThreads);
        this.registry.register((Collector)this.collector);
        this.registry.register((Collector)scrapeErrorTotal);
        this.httpServer = new HTTPServer(new InetSocketAddress(this.port), this.registry);
    }

    public void stop() {
        this.httpServer.stop();
        this.registry.unregister((Collector)this.collector);
    }

    private static SolrClient createClient(String connStr) {
        HttpSolrClient solrClient;
        Pattern baseUrlPattern = Pattern.compile("^https?:\\/\\/[\\w\\/:%#\\$&\\?\\(\\)~\\.=\\+\\-]+$");
        Pattern zkHostPattern = Pattern.compile("^(?<host>[^\\/]+)(?<chroot>|(?:\\/.*))$");
        Matcher matcher = baseUrlPattern.matcher(connStr);
        if (matcher.matches()) {
            NoOpResponseParser responseParser = new NoOpResponseParser();
            responseParser.setWriterType("json");
            HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
            builder.withBaseSolrUrl(connStr);
            HttpSolrClient httpSolrClient = builder.build();
            httpSolrClient.setParser((ResponseParser)responseParser);
            solrClient = httpSolrClient;
        } else {
            String host = "";
            String chroot = "";
            matcher = zkHostPattern.matcher(connStr);
            if (matcher.matches()) {
                host = matcher.group("host") != null ? matcher.group("host") : "";
                chroot = matcher.group("chroot") != null ? matcher.group("chroot") : "";
            }
            NoOpResponseParser responseParser = new NoOpResponseParser();
            responseParser.setWriterType("json");
            CloudSolrClient.Builder builder = new CloudSolrClient.Builder();
            if (host.contains(",")) {
                ArrayList<String> hosts = new ArrayList<String>();
                for (String h : host.split(",")) {
                    if (h == null || h.equals("")) continue;
                    hosts.add(h.trim());
                }
                builder.withZkHost(hosts);
            } else {
                builder.withZkHost(host);
            }
            if (chroot.equals("")) {
                builder.withZkChroot("/");
            } else {
                builder.withZkChroot(chroot);
            }
            CloudSolrClient cloudSolrClient = builder.build();
            cloudSolrClient.setParser((ResponseParser)responseParser);
            solrClient = cloudSolrClient;
        }
        return solrClient;
    }

    public static void main(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)SolrCollector.class.getSimpleName()).description("Prometheus exporter for Apache Solr.");
        parser.addArgument(ARG_PORT_FLAGS).metavar(new String[]{ARG_PORT_METAVAR}).dest(ARG_PORT_DEST).type(Integer.class).setDefault((Object)ARG_PORT_DEFAULT).help(ARG_PORT_HELP);
        parser.addArgument(ARG_BASE_URL_FLAGS).metavar(new String[]{ARG_BASE_URL_METAVAR}).dest(ARG_BASE_URL_DEST).type(String.class).setDefault((Object)"").help(ARG_BASE_URL_HELP);
        parser.addArgument(ARG_ZK_HOST_FLAGS).metavar(new String[]{ARG_ZK_HOST_METAVAR}).dest(ARG_ZK_HOST_DEST).type(String.class).setDefault((Object)"").help(ARG_ZK_HOST_HELP);
        parser.addArgument(ARG_CONFIG_FLAGS).metavar(new String[]{ARG_CONFIG_METAVAR}).dest(ARG_CONFIG_DEST).type(String.class).setDefault((Object)ARG_CONFIG_DEFAULT).help(ARG_CONFIG_HELP);
        parser.addArgument(ARG_NUM_THREADS_FLAGS).metavar(new String[]{ARG_NUM_THREADS_METAVAR}).dest(ARG_NUM_THREADS_DEST).type(Integer.class).setDefault((Object)ARG_NUM_THREADS_DEFAULT).help(ARG_NUM_THREADS_HELP);
        try {
            Namespace res = parser.parseArgs(args);
            int port = res.getInt(ARG_PORT_DEST);
            String connStr = "http://localhost:8983/solr";
            if (!res.getString(ARG_BASE_URL_DEST).equals("")) {
                connStr = res.getString(ARG_BASE_URL_DEST);
            } else if (!res.getString(ARG_ZK_HOST_DEST).equals("")) {
                connStr = res.getString(ARG_ZK_HOST_DEST);
            }
            Path configPath = Paths.get(res.getString(ARG_CONFIG_DEST), new String[0]);
            int numThreads = res.getInt(ARG_NUM_THREADS_DEST);
            SolrExporter solrExporter = new SolrExporter(port, connStr, configPath, numThreads);
            solrExporter.start();
            log.info("Start server");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error("Start server failed: " + e.toString());
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
        }
    }
}

