/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.Version;
import com.healthmarketscience.jackcess.complex.VersionHistoryColumnInfo;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.complex.ComplexColumnInfoImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHistoryColumnInfoImpl
extends ComplexColumnInfoImpl<Version>
implements VersionHistoryColumnInfo {
    private final Column _valueCol;
    private final Column _modifiedCol;

    public VersionHistoryColumnInfoImpl(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
        Column valueCol = null;
        Column modifiedCol = null;
        for (Column col : this.getTypeColumns()) {
            switch (col.getType()) {
                case SHORT_DATE_TIME: {
                    modifiedCol = col;
                    break;
                }
                case MEMO: {
                    valueCol = col;
                    break;
                }
            }
        }
        this._valueCol = valueCol;
        this._modifiedCol = modifiedCol;
    }

    @Override
    public void postTableLoadInit() throws IOException {
        super.postTableLoadInit();
        Column versionedCol = this.getColumn().getTable().getColumn(this.getValueColumn().getName());
        ((ColumnImpl)versionedCol).setVersionHistoryColumn((ColumnImpl)this.getColumn());
    }

    public Column getValueColumn() {
        return this._valueCol;
    }

    public Column getModifiedDateColumn() {
        return this._modifiedCol;
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.VERSION_HISTORY;
    }

    @Override
    public ComplexValue.Id updateValue(Version value) throws IOException {
        throw new UnsupportedOperationException("This column does not support value updates");
    }

    @Override
    public void deleteValue(Version value) throws IOException {
        throw new UnsupportedOperationException("This column does not support value deletes");
    }

    @Override
    public void deleteAllValues(int complexValueFk) throws IOException {
        throw new UnsupportedOperationException("This column does not support value deletes");
    }

    @Override
    protected List<Version> toValues(ComplexValueForeignKey complexValueFk, List<Row> rawValues) throws IOException {
        List<Version> versions = super.toValues(complexValueFk, rawValues);
        Collections.sort(versions);
        return versions;
    }

    @Override
    protected VersionImpl toValue(ComplexValueForeignKey complexValueFk, Row rawValue) {
        ComplexColumnInfoImpl.ComplexValueIdImpl id = this.getValueId(rawValue);
        String value = (String)this.getValueColumn().getRowValue(rawValue);
        Date modifiedDate = (Date)this.getModifiedDateColumn().getRowValue(rawValue);
        return new VersionImpl(id, complexValueFk, value, modifiedDate);
    }

    @Override
    protected Object[] asRow(Object[] row, Version version) throws IOException {
        super.asRow(row, version);
        this.getValueColumn().setRowValue(row, (Object)version.getValue());
        this.getModifiedDateColumn().setRowValue(row, (Object)version.getModifiedDate());
        return row;
    }

    public static Version newVersion(String value, Date modifiedDate) {
        return VersionHistoryColumnInfoImpl.newVersion(INVALID_FK, value, modifiedDate);
    }

    public static Version newVersion(ComplexValueForeignKey complexValueFk, String value, Date modifiedDate) {
        return new VersionImpl(INVALID_ID, complexValueFk, value, modifiedDate);
    }

    private static class VersionImpl
    extends ComplexColumnInfoImpl.ComplexValueImpl
    implements Version {
        private final String _value;
        private final Date _modifiedDate;

        private VersionImpl(ComplexValue.Id id, ComplexValueForeignKey complexValueFk, String value, Date modifiedDate) {
            super(id, complexValueFk);
            this._value = value;
            this._modifiedDate = modifiedDate;
        }

        public String getValue() {
            return this._value;
        }

        public Date getModifiedDate() {
            return this._modifiedDate;
        }

        public int compareTo(Version o) {
            int id2;
            Date d1 = this.getModifiedDate();
            Date d2 = o.getModifiedDate();
            int cmp = d2.compareTo(d1);
            if (cmp != 0) {
                return cmp;
            }
            int id1 = this.getId().get();
            if (id1 != (id2 = o.getId().get())) {
                return id1 > id2 ? -1 : 1;
            }
            id1 = this.getComplexValueForeignKey().get();
            return id1 > (id2 = o.getComplexValueForeignKey().get()) ? -1 : (id1 < id2 ? 1 : 0);
        }

        public void update() throws IOException {
            throw new UnsupportedOperationException("This column does not support value updates");
        }

        public void delete() throws IOException {
            throw new UnsupportedOperationException("This column does not support value deletes");
        }

        public String toString() {
            return "Version(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.getModifiedDate() + ", " + this.getValue();
        }
    }
}

