/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetFieldParser;
import org.apache.solr.search.facet.FacetHeatmap;
import org.apache.solr.search.facet.FacetQueryParser;
import org.apache.solr.search.facet.FacetRangeParser;
import org.apache.solr.search.facet.FacetRequest;

abstract class FacetParser<FacetRequestT extends FacetRequest> {
    protected FacetRequestT facet;
    protected FacetParser parent;
    protected String key;

    public FacetParser(FacetParser parent, String key) {
        this.parent = parent;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getPathStr() {
        if (this.parent == null) {
            return "/" + this.key;
        }
        return this.parent.getKey() + "/" + this.key;
    }

    protected RuntimeException err(String msg) {
        return new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg + " , path=" + this.getPathStr());
    }

    public abstract FacetRequest parse(Object var1) throws SyntaxError;

    public void parseSubs(Object o) throws SyntaxError {
        if (o == null) {
            return;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("processEmpty".equals(key)) {
                    ((FacetRequest)this.facet).processEmpty = this.getBoolean(m, "processEmpty", false);
                    continue;
                }
                Object parsedValue = this.parseFacetOrStat(key, value);
                if (parsedValue instanceof FacetRequest) {
                    ((FacetRequest)this.facet).addSubFacet(key, (FacetRequest)parsedValue);
                    continue;
                }
                if (parsedValue instanceof AggValueSource) {
                    ((FacetRequest)this.facet).addStat(key, (AggValueSource)((Object)parsedValue));
                    continue;
                }
                throw this.err("Unknown facet type key=" + key + " class=" + (parsedValue == null ? "null" : parsedValue.getClass().getName()));
            }
        } else {
            throw this.err("Expected map for facet/stat");
        }
    }

    public Object parseFacetOrStat(String key, Object o) throws SyntaxError {
        Map args;
        String type;
        if (o instanceof String) {
            return this.parseStringFacetOrStat(key, (String)o);
        }
        if (!(o instanceof Map)) {
            throw this.err("expected Map but got " + o);
        }
        Map m = (Map)o;
        if (m.size() == 1) {
            Map.Entry entry = m.entrySet().iterator().next();
            type = (String)entry.getKey();
            args = entry.getValue();
        } else {
            Object typeObj = m.get("type");
            if (!(typeObj instanceof String)) {
                throw this.err("expected facet/stat type name, like {type:range, field:price, ...} but got " + typeObj);
            }
            type = (String)typeObj;
            args = m;
        }
        return this.parseFacetOrStat(key, type, args);
    }

    public Object parseFacetOrStat(String key, String type, Object args) throws SyntaxError {
        switch (type) {
            case "field": 
            case "terms": {
                return new FacetFieldParser(this, key).parse(args);
            }
            case "query": {
                return new FacetQueryParser(this, key).parse(args);
            }
            case "range": {
                return new FacetRangeParser(this, key).parse(args);
            }
            case "heatmap": {
                return new FacetHeatmap.Parser(this, key).parse(args);
            }
            case "func": {
                return this.parseStat(key, args);
            }
        }
        throw this.err("Unknown facet or stat. key=" + key + " type=" + type + " args=" + args);
    }

    public Object parseStringFacetOrStat(String key, String s) throws SyntaxError {
        return this.parseStat(key, s);
    }

    private AggValueSource parseStatWithParams(String key, SolrParams localparams, String stat) throws SyntaxError {
        SolrQueryRequest req = this.getSolrRequest();
        FunctionQParser parser = new FunctionQParser(stat, localparams, req.getParams(), req);
        AggValueSource agg = parser.parseAgg(1);
        return agg;
    }

    private AggValueSource parseStat(String key, Object args) throws SyntaxError {
        assert (null != args);
        if (args instanceof CharSequence) {
            return this.parseStatWithParams(key, null, args.toString());
        }
        if (args instanceof Map) {
            Map statMap = (Map)args;
            return this.parseStatWithParams(key, FacetParser.jsonToSolrParams(statMap), statMap.get("func").toString());
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats must be specified as either a simple string, or a json Map");
    }

    private FacetRequest.Domain getDomain() {
        if (((FacetRequest)this.facet).domain == null) {
            ((FacetRequest)this.facet).domain = new FacetRequest.Domain();
        }
        return ((FacetRequest)this.facet).domain;
    }

    protected void parseCommonParams(Object o) {
        if (o instanceof Map) {
            Map domainMap;
            Map m = (Map)o;
            List<String> excludeTags = this.getStringList(m, "excludeTags");
            if (excludeTags != null) {
                this.getDomain().excludeTags = excludeTags;
            }
            if ((domainMap = (Map)m.get("domain")) != null) {
                FacetRequest.Domain domain = this.getDomain();
                excludeTags = this.getStringList(domainMap, "excludeTags");
                if (excludeTags != null) {
                    domain.excludeTags = excludeTags;
                }
                if (domainMap.containsKey("query")) {
                    domain.explicitQueries = this.parseJSONQueryStruct(domainMap.get("query"));
                    if (null == domain.explicitQueries) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'query' domain can not be null or empty");
                    }
                    if (null != domain.excludeTags) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'query' domain can not be combined with 'excludeTags'");
                    }
                }
                String blockParent = (String)domainMap.get("blockParent");
                String blockChildren = (String)domainMap.get("blockChildren");
                if (blockParent != null) {
                    domain.toParent = true;
                    domain.parents = blockParent;
                } else if (blockChildren != null) {
                    domain.toChildren = true;
                    domain.parents = blockChildren;
                }
                FacetRequest.Domain.JoinField.createJoinField(domain, domainMap);
                FacetRequest.Domain.GraphField.createGraphField(domain, domainMap);
                Object filterOrList = domainMap.get("filter");
                if (filterOrList != null) {
                    assert (domain.filters == null);
                    domain.filters = this.parseJSONQueryStruct(filterOrList);
                }
            }
        }
    }

    private List<Object> parseJSONQueryStruct(Object raw) {
        ArrayList<Object> result = null;
        if (null == raw) {
            return result;
        }
        if (raw instanceof List) {
            result = (ArrayList<Object>)raw;
        } else {
            result = new ArrayList<Object>(1);
            result.add(raw);
        }
        return result;
    }

    public String getField(Map<String, Object> args) {
        Object fieldName = args.get("field");
        if (fieldName == null) {
            fieldName = args.get("f");
        }
        if (fieldName == null) {
            throw this.err("Missing 'field'");
        }
        if (!(fieldName instanceof String)) {
            throw this.err("Expected string for 'field', got" + fieldName);
        }
        return (String)fieldName;
    }

    public Long getLongOrNull(Map<String, Object> args, String paramName, boolean required) {
        Object o = args.get(paramName);
        if (o == null) {
            if (required) {
                throw this.err("Missing required parameter '" + paramName + "'");
            }
            return null;
        }
        if (!(o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte)) {
            throw this.err("Expected integer type for param '" + paramName + "' but got " + o);
        }
        return ((Number)o).longValue();
    }

    public long getLong(Map<String, Object> args, String paramName, long defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte)) {
            throw this.err("Expected integer type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return ((Number)o).longValue();
    }

    public Double getDoubleOrNull(Map<String, Object> args, String paramName, boolean required) {
        Object o = args.get(paramName);
        if (o == null) {
            if (required) {
                throw this.err("Missing required parameter '" + paramName + "'");
            }
            return null;
        }
        if (!(o instanceof Number)) {
            throw this.err("Expected double type for param '" + paramName + "' but got " + o);
        }
        return ((Number)o).doubleValue();
    }

    public boolean getBoolean(Map<String, Object> args, String paramName, boolean defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof Boolean)) {
            throw this.err("Expected boolean type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (Boolean)o;
    }

    public String getString(Map<String, Object> args, String paramName, String defVal) {
        Object o = args.get(paramName);
        if (o == null) {
            return defVal;
        }
        if (!(o instanceof String)) {
            throw this.err("Expected string type for param '" + paramName + "' but got " + o.getClass().getSimpleName() + " = " + o);
        }
        return (String)o;
    }

    public List<String> getStringList(Map<String, Object> args, String paramName) {
        Object o = args.get(paramName);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return StrUtils.splitSmart((String)((String)o), (String)",", (boolean)true);
        }
        throw this.err("Expected list of string or comma separated string values.");
    }

    public IndexSchema getSchema() {
        return this.parent.getSchema();
    }

    public SolrQueryRequest getSolrRequest() {
        return this.parent.getSolrRequest();
    }

    public static SolrParams jsonToSolrParams(Map jsonObject) {
        NamedList nl = new NamedList();
        nl.addAll(jsonObject);
        return SolrParams.toSolrParams((NamedList)nl);
    }
}

