/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterNumericDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class IntervalFacets
implements Iterable<FacetInterval> {
    private final SchemaField schemaField;
    private final SolrIndexSearcher searcher;
    private final DocSet docs;
    private final FacetInterval[] intervals;

    public IntervalFacets(SchemaField schemaField, SolrIndexSearcher searcher, DocSet docs, String[] intervals, SolrParams params) throws SyntaxError, IOException {
        this.schemaField = schemaField;
        this.searcher = searcher;
        this.docs = docs;
        this.intervals = this.getSortedIntervals(intervals, params);
        this.doCount();
    }

    public IntervalFacets(SchemaField schemaField, SolrIndexSearcher searcher, DocSet docs, FacetInterval[] intervals) throws IOException {
        this.schemaField = schemaField;
        this.searcher = searcher;
        this.docs = docs;
        this.intervals = intervals;
        this.doCount();
    }

    private FacetInterval[] getSortedIntervals(String[] intervals, SolrParams params) throws SyntaxError {
        FacetInterval[] sortedIntervals = new FacetInterval[intervals.length];
        int idx = 0;
        for (String intervalStr : intervals) {
            sortedIntervals[idx++] = new FacetInterval(this.schemaField, intervalStr, params);
        }
        Arrays.sort(sortedIntervals, new Comparator<FacetInterval>(){

            @Override
            public int compare(FacetInterval o1, FacetInterval o2) {
                assert (o1 != null);
                assert (o2 != null);
                return this.compareStart(o1, o2);
            }

            private int compareStart(FacetInterval o1, FacetInterval o2) {
                if (o1.start == null) {
                    if (o2.start == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2.start == null) {
                    return 1;
                }
                int startComparison = o1.start.compareTo(o2.start);
                if (startComparison == 0 && o1.startOpen != o2.startOpen) {
                    if (!o1.startOpen) {
                        return -1;
                    }
                    return 1;
                }
                return startComparison;
            }
        });
        return sortedIntervals;
    }

    private void doCount() throws IOException {
        if (this.schemaField.getType().getNumberType() != null && (!this.schemaField.multiValued() || this.schemaField.getType().isPointField())) {
            if (this.schemaField.multiValued()) {
                this.getCountMultiValuedNumeric();
            } else {
                this.getCountNumeric();
            }
        } else {
            this.getCountString();
        }
    }

    private void getCountNumeric() throws IOException {
        FieldType ft = this.schemaField.getType();
        String fieldName = this.schemaField.getName();
        NumberType numericType = ft.getNumberType();
        if (numericType == null) {
            throw new IllegalStateException();
        }
        List leaves = this.searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        Object longs = null;
        DocIterator docsIt = this.docs.iterator();
        while (docsIt.hasNext()) {
            int valuesDocID;
            int doc = docsIt.nextDoc();
            if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                while ((ctx = (LeafReaderContext)ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                }
                assert (doc >= ctx.docBase);
                switch (numericType) {
                    case LONG: 
                    case DATE: 
                    case INTEGER: {
                        longs = DocValues.getNumeric((LeafReader)ctx.reader(), (String)fieldName);
                        break;
                    }
                    case FLOAT: {
                        longs = new FilterNumericDocValues(DocValues.getNumeric((LeafReader)ctx.reader(), (String)fieldName)){

                            public long longValue() throws IOException {
                                return NumericUtils.sortableFloatBits((int)((int)super.longValue()));
                            }
                        };
                        break;
                    }
                    case DOUBLE: {
                        longs = new FilterNumericDocValues(DocValues.getNumeric((LeafReader)ctx.reader(), (String)fieldName)){

                            public long longValue() throws IOException {
                                return NumericUtils.sortableDoubleBits((long)super.longValue());
                            }
                        };
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            if ((valuesDocID = longs.docID()) < doc - ctx.docBase) {
                valuesDocID = longs.advance(doc - ctx.docBase);
            }
            if (valuesDocID != doc - ctx.docBase) continue;
            this.accumIntervalWithValue(longs.longValue());
        }
    }

    private void getCountMultiValuedNumeric() throws IOException {
        FieldType ft = this.schemaField.getType();
        String fieldName = this.schemaField.getName();
        if (ft.getNumberType() == null) {
            throw new IllegalStateException();
        }
        List leaves = this.searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        SortedNumericDocValues longs = null;
        DocIterator docsIt = this.docs.iterator();
        while (docsIt.hasNext()) {
            int valuesDocID;
            int doc = docsIt.nextDoc();
            if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                while ((ctx = (LeafReaderContext)ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                }
                assert (doc >= ctx.docBase);
                longs = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)fieldName);
            }
            if ((valuesDocID = longs.docID()) < doc - ctx.docBase) {
                valuesDocID = longs.advance(doc - ctx.docBase);
            }
            if (valuesDocID != doc - ctx.docBase) continue;
            this.accumIntervalWithMultipleValues(longs);
        }
    }

    private void getCountString() throws IOException {
        Filter filter = this.docs.getTopFilter();
        List leaves = this.searcher.getTopReaderContext().leaves();
        for (int subIndex = 0; subIndex < leaves.size(); ++subIndex) {
            SortedSetDocValues sub;
            DocIdSetIterator disi;
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(subIndex);
            DocIdSet dis = filter.getDocIdSet(leaf, null);
            if (dis == null || (disi = dis.iterator()) == null) continue;
            if (this.schemaField.multiValued()) {
                sub = leaf.reader().getSortedSetDocValues(this.schemaField.getName());
                if (sub == null) continue;
                SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)sub);
                if (singleton != null) {
                    this.accumIntervalsSingle(singleton, disi, dis.bits());
                    continue;
                }
                this.accumIntervalsMulti(sub, disi, dis.bits());
                continue;
            }
            sub = leaf.reader().getSortedDocValues(this.schemaField.getName());
            if (sub == null) continue;
            this.accumIntervalsSingle((SortedDocValues)sub, disi, dis.bits());
        }
    }

    private void accumIntervalWithMultipleValues(SortedNumericDocValues longs) throws IOException {
        assert (longs.docID() != -1);
        assert (longs.docValueCount() > 0) : "Should have at least one value for this document";
        int currentInterval = 0;
        for (int i = 0; i < longs.docValueCount(); ++i) {
            boolean evaluateNextInterval = true;
            long value = longs.nextValue();
            while (evaluateNextInterval && currentInterval < this.intervals.length) {
                IntervalCompareResult result = this.intervals[currentInterval].includes(value);
                switch (result) {
                    case INCLUDED: {
                        this.intervals[currentInterval].incCount();
                        ++currentInterval;
                        break;
                    }
                    case LOWER_THAN_START: {
                        evaluateNextInterval = false;
                        break;
                    }
                    case GREATER_THAN_END: {
                        ++currentInterval;
                    }
                }
            }
        }
    }

    private void accumIntervalsMulti(SortedSetDocValues ssdv, DocIdSetIterator disi, Bits bits) throws IOException {
        int doc;
        for (FacetInterval interval : this.intervals) {
            interval.updateContext(ssdv);
        }
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            long currOrd;
            if (bits != null && !bits.get(doc)) continue;
            if (doc > ssdv.docID()) {
                ssdv.advance(doc);
            }
            if (doc != ssdv.docID()) continue;
            int currentInterval = 0;
            while ((currOrd = ssdv.nextOrd()) != -1L) {
                boolean evaluateNextInterval = true;
                while (evaluateNextInterval && currentInterval < this.intervals.length) {
                    IntervalCompareResult result = this.intervals[currentInterval].includes(currOrd);
                    switch (result) {
                        case INCLUDED: {
                            this.intervals[currentInterval].incCount();
                            ++currentInterval;
                            break;
                        }
                        case LOWER_THAN_START: {
                            evaluateNextInterval = false;
                            break;
                        }
                        case GREATER_THAN_END: {
                            ++currentInterval;
                        }
                    }
                }
            }
        }
    }

    private void accumIntervalsSingle(SortedDocValues sdv, DocIdSetIterator disi, Bits bits) throws IOException {
        int doc;
        for (FacetInterval interval : this.intervals) {
            interval.updateContext(sdv);
        }
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (bits != null && !bits.get(doc)) continue;
            if (doc > sdv.docID()) {
                sdv.advance(doc);
            }
            if (doc != sdv.docID()) continue;
            this.accumInterval(sdv.ordValue());
        }
    }

    private void accumInterval(int ordinal) {
        assert (ordinal >= 0);
        this.accumIntervalWithValue(ordinal);
    }

    private void accumIntervalWithValue(long value) {
        for (int i = 0; i < this.intervals.length; ++i) {
            FacetInterval interval = this.intervals[i];
            IntervalCompareResult result = interval.includes(value);
            if (result == IntervalCompareResult.INCLUDED) {
                interval.incCount();
                continue;
            }
            if (result == IntervalCompareResult.LOWER_THAN_START) break;
        }
    }

    @Override
    public Iterator<FacetInterval> iterator() {
        return new ArrayList<FacetInterval>(Arrays.asList(this.intervals)).iterator();
    }

    public static class FacetInterval {
        private final String key;
        final BytesRef start;
        final BytesRef end;
        private final boolean startOpen;
        private final boolean endOpen;
        private long startLimit;
        private long endLimit;
        private int count;
        private boolean includeNoDocs = false;

        FacetInterval(SchemaField schemaField, String intervalStr, SolrParams params) throws SyntaxError {
            if (intervalStr == null) {
                throw new SyntaxError("empty facet interval");
            }
            if ((intervalStr = intervalStr.trim()).length() == 0) {
                throw new SyntaxError("empty facet interval");
            }
            try {
                SolrParams localParams = QueryParsing.getLocalParams(intervalStr, params);
                if (localParams != null) {
                    int localParamEndIdx = 2;
                    while (intervalStr.charAt((localParamEndIdx = intervalStr.indexOf(125, localParamEndIdx)) - 1) == '\\') {
                        ++localParamEndIdx;
                    }
                    intervalStr = intervalStr.substring(localParamEndIdx + 1);
                    this.key = localParams.get("key", intervalStr);
                } else {
                    this.key = intervalStr;
                }
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            if (intervalStr.charAt(0) == '(') {
                this.startOpen = true;
            } else if (intervalStr.charAt(0) == '[') {
                this.startOpen = false;
            } else {
                throw new SyntaxError("Invalid start character " + intervalStr.charAt(0) + " in facet interval " + intervalStr);
            }
            int lastNdx = intervalStr.length() - 1;
            if (intervalStr.charAt(lastNdx) == ')') {
                this.endOpen = true;
            } else if (intervalStr.charAt(lastNdx) == ']') {
                this.endOpen = false;
            } else {
                throw new SyntaxError("Invalid end character " + intervalStr.charAt(0) + " in facet interval " + intervalStr);
            }
            StringBuilder startStr = new StringBuilder(lastNdx);
            int i = this.unescape(intervalStr, 1, lastNdx, startStr);
            if (i == lastNdx) {
                if (intervalStr.charAt(lastNdx - 1) == ',') {
                    throw new SyntaxError("Empty interval limit");
                }
                throw new SyntaxError("Missing unescaped comma separating interval ends in " + intervalStr);
            }
            try {
                this.start = this.getLimitFromString(schemaField, startStr);
            }
            catch (SolrException | SyntaxError e) {
                throw new SyntaxError(String.format(Locale.ROOT, "Invalid start interval for key '%s': %s", this.key, e.getMessage()), e);
            }
            StringBuilder endStr = new StringBuilder(lastNdx);
            i = this.unescape(intervalStr, i, lastNdx, endStr);
            if (i != lastNdx) {
                throw new SyntaxError("Extra unescaped comma at index " + i + " in interval " + intervalStr);
            }
            try {
                this.end = this.getLimitFromString(schemaField, endStr);
            }
            catch (SolrException | SyntaxError e) {
                throw new SyntaxError(String.format(Locale.ROOT, "Invalid end interval for key '%s': %s", this.key, e.getMessage()), e);
            }
            if (schemaField.getType().getNumberType() != null) {
                this.setNumericLimits(schemaField);
            }
            if (this.start != null && this.end != null && this.start.compareTo(this.end) > 0) {
                throw new SyntaxError("Start is higher than end in interval for key: " + this.key);
            }
        }

        public FacetInterval(SchemaField schemaField, String startStr, String endStr, boolean includeLower, boolean includeUpper, String key) {
            assert (schemaField.getType().getNumberType() != null) : "Only numeric fields supported with this constructor";
            this.key = key;
            this.startOpen = !includeLower;
            this.endOpen = !includeUpper;
            this.start = this.getLimitFromString(schemaField, startStr);
            this.end = this.getLimitFromString(schemaField, endStr);
            assert (this.start == null || this.end == null || this.start.compareTo(this.end) < 0) : "Bad start/end limits: " + startStr + "/" + endStr;
            this.setNumericLimits(schemaField);
        }

        private void setNumericLimits(SchemaField schemaField) {
            if (this.start == null) {
                this.startLimit = Long.MIN_VALUE;
            } else {
                switch (schemaField.getType().getNumberType()) {
                    case LONG: {
                        this.startLimit = (Long)schemaField.getType().toObject(schemaField, this.start);
                        break;
                    }
                    case DATE: {
                        this.startLimit = ((Date)schemaField.getType().toObject(schemaField, this.start)).getTime();
                        break;
                    }
                    case INTEGER: {
                        this.startLimit = ((Integer)schemaField.getType().toObject(schemaField, this.start)).longValue();
                        break;
                    }
                    case FLOAT: {
                        this.startLimit = NumericUtils.floatToSortableInt((float)((Float)schemaField.getType().toObject(schemaField, this.start)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.startLimit = NumericUtils.doubleToSortableLong((double)((Double)schemaField.getType().toObject(schemaField, this.start)));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (this.startOpen) {
                    if (this.startLimit == Long.MAX_VALUE) {
                        this.includeNoDocs = true;
                    } else {
                        ++this.startLimit;
                    }
                }
            }
            if (this.end == null) {
                this.endLimit = Long.MAX_VALUE;
            } else {
                switch (schemaField.getType().getNumberType()) {
                    case LONG: {
                        this.endLimit = (Long)schemaField.getType().toObject(schemaField, this.end);
                        break;
                    }
                    case DATE: {
                        this.endLimit = ((Date)schemaField.getType().toObject(schemaField, this.end)).getTime();
                        break;
                    }
                    case INTEGER: {
                        this.endLimit = ((Integer)schemaField.getType().toObject(schemaField, this.end)).longValue();
                        break;
                    }
                    case FLOAT: {
                        this.endLimit = NumericUtils.floatToSortableInt((float)((Float)schemaField.getType().toObject(schemaField, this.end)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.endLimit = NumericUtils.doubleToSortableLong((double)((Double)schemaField.getType().toObject(schemaField, this.end)));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (this.endOpen) {
                    if (this.endLimit == Long.MIN_VALUE) {
                        this.includeNoDocs = true;
                    } else {
                        --this.endLimit;
                    }
                }
            }
        }

        private BytesRef getLimitFromString(SchemaField schemaField, StringBuilder builder) throws SyntaxError {
            String value = builder.toString().trim();
            if (value.length() == 0) {
                throw new SyntaxError("Empty interval limit");
            }
            return this.getLimitFromString(schemaField, value);
        }

        private BytesRef getLimitFromString(SchemaField schemaField, String value) {
            if ("*".equals(value)) {
                return null;
            }
            if (schemaField.getType().isPointField()) {
                return ((PointField)schemaField.getType()).toInternalByteRef(value);
            }
            return new BytesRef((CharSequence)schemaField.getType().toInternal(value));
        }

        public void updateContext(SortedDocValues sdv) throws IOException {
            if (this.start == null) {
                this.startLimit = -1L;
            } else {
                this.startLimit = sdv.lookupTerm(this.start);
                if (this.startLimit < 0L) {
                    this.startLimit = this.startLimit * -1L - 1L;
                } else if (this.startOpen) {
                    ++this.startLimit;
                }
            }
            if (this.end == null) {
                this.endLimit = Long.MAX_VALUE;
            } else {
                this.endLimit = sdv.lookupTerm(this.end);
                if (this.endLimit < 0L) {
                    this.endLimit = this.endLimit * -1L - 2L;
                } else if (this.endOpen) {
                    --this.endLimit;
                }
            }
        }

        public void updateContext(SortedSetDocValues sdv) throws IOException {
            if (this.start == null) {
                this.startLimit = -1L;
            } else {
                this.startLimit = sdv.lookupTerm(this.start);
                if (this.startLimit < 0L) {
                    this.startLimit = this.startLimit * -1L - 1L;
                } else if (this.startOpen) {
                    ++this.startLimit;
                }
            }
            if (this.end == null) {
                this.endLimit = Long.MAX_VALUE;
            } else {
                this.endLimit = sdv.lookupTerm(this.end);
                if (this.endLimit < 0L) {
                    this.endLimit = this.endLimit * -1L - 2L;
                } else if (this.endOpen) {
                    --this.endLimit;
                }
            }
        }

        public IntervalCompareResult includes(long value) {
            if (this.startLimit > value) {
                return IntervalCompareResult.LOWER_THAN_START;
            }
            if (this.endLimit < value) {
                return IntervalCompareResult.GREATER_THAN_END;
            }
            return IntervalCompareResult.INCLUDED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int unescape(String s, int i, int n, StringBuilder sb) throws SyntaxError {
            while (i < n) {
                char c = s.charAt(i);
                if (c == '\\') {
                    if (++i >= n) throw new SyntaxError("Unfinished escape at index " + i + " in facet interval " + s);
                    c = s.charAt(i);
                } else if (c == ',') {
                    return i + 1;
                }
                sb.append(c);
                ++i;
            }
            return n;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [key=" + this.key + ", start=" + this.start + ", end=" + this.end + ", startOpen=" + this.startOpen + ", endOpen=" + this.endOpen + "]";
        }

        public int getCount() {
            if (this.includeNoDocs) {
                return 0;
            }
            return this.count;
        }

        void incCount() {
            ++this.count;
        }

        public String getKey() {
            return this.key;
        }
    }

    static enum IntervalCompareResult {
        LOWER_THAN_START,
        INCLUDED,
        GREATER_THAN_END;

    }
}

