/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCloudAuthTestCase
extends SolrCloudTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> AUTH_METRICS_KEYS = Arrays.asList("errors", "requests", "authenticated", "passThrough", "failWrongCredentials", "failMissingCredentials", "requestTimes", "totalTime");
    private static final List<String> AUTH_METRICS_METER_KEYS = Arrays.asList("errors");
    private static final List<String> AUTH_METRICS_TIMER_KEYS = Collections.singletonList("requestTimes");
    private static final String METRICS_PREFIX_PKI = "SECURITY./authentication/pki.";
    private static final String METRICS_PREFIX = "SECURITY./authentication.";

    protected void assertPkiAuthMetricsMinimums(int requests, int authenticated, int passThrough, int failWrongCredentials, int failMissingCredentials, int errors) {
        this.assertAuthMetricsMinimums(METRICS_PREFIX_PKI, requests, authenticated, passThrough, failWrongCredentials, failMissingCredentials, errors);
    }

    protected void assertAuthMetricsMinimums(int requests, int authenticated, int passThrough, int failWrongCredentials, int failMissingCredentials, int errors) {
        this.assertAuthMetricsMinimums(METRICS_PREFIX, requests, authenticated, passThrough, failWrongCredentials, failMissingCredentials, errors);
    }

    Map<String, Long> countAuthMetrics(String prefix) {
        ArrayList metrics = new ArrayList();
        cluster.getJettySolrRunners().forEach(r -> {
            MetricRegistry registry = r.getCoreContainer().getMetricManager().registry("solr.node");
            SolrCloudAuthTestCase.assertNotNull((Object)registry);
            metrics.add(registry.getMetrics());
        });
        HashMap<String, Long> counts = new HashMap<String, Long>();
        AUTH_METRICS_KEYS.forEach(k -> counts.put((String)k, this.sumCount(prefix, (String)k, metrics)));
        return counts;
    }

    private void assertAuthMetricsMinimums(String prefix, int requests, int authenticated, int passThrough, int failWrongCredentials, int failMissingCredentials, int errors) {
        Map<String, Long> counts = this.countAuthMetrics(prefix);
        boolean success = this.isMetricEuqalOrLarger(requests, "requests", counts) & this.isMetricEuqalOrLarger(authenticated, "authenticated", counts) & this.isMetricEuqalOrLarger(passThrough, "passThrough", counts) & this.isMetricEuqalOrLarger(failWrongCredentials, "failWrongCredentials", counts) & this.isMetricEuqalOrLarger(failMissingCredentials, "failMissingCredentials", counts) & this.isMetricEuqalOrLarger(errors, "errors", counts);
        HashMap<String, Long> expectedCounts = new HashMap<String, Long>();
        expectedCounts.put("requests", Long.valueOf(requests));
        expectedCounts.put("authenticated", Long.valueOf(authenticated));
        expectedCounts.put("passThrough", Long.valueOf(passThrough));
        expectedCounts.put("failWrongCredentials", Long.valueOf(failWrongCredentials));
        expectedCounts.put("failMissingCredentials", Long.valueOf(failMissingCredentials));
        expectedCounts.put("errors", Long.valueOf(errors));
        SolrCloudAuthTestCase.assertTrue((String)("Expected metric minimums for prefix " + prefix + ": " + expectedCounts + ", but got: " + counts), (boolean)success);
        if (counts.get("requests") > 0L) {
            SolrCloudAuthTestCase.assertTrue((String)"requestTimes count not > 1", (counts.get("requestTimes") > 1L ? 1 : 0) != 0);
            SolrCloudAuthTestCase.assertTrue((String)"totalTime not > 0", (counts.get("totalTime") > 0L ? 1 : 0) != 0);
        }
    }

    private boolean isMetricEuqalOrLarger(int expected, String key, Map<String, Long> counts) {
        long cnt = counts.get(key);
        log.debug("Asserting that auth metrics count ({}) > expected ({})", (Object)cnt, (Object)expected);
        return cnt >= (long)expected;
    }

    private long sumCount(String prefix, String key, List<Map<String, Metric>> metrics) {
        SolrCloudAuthTestCase.assertTrue((String)("Metric " + prefix + key + " does not exist"), (boolean)metrics.get(0).containsKey(prefix + key));
        if (AUTH_METRICS_METER_KEYS.contains(key)) {
            return metrics.stream().mapToLong(l -> ((Meter)l.get(prefix + key)).getCount()).sum();
        }
        if (AUTH_METRICS_TIMER_KEYS.contains(key)) {
            return (long)(1000.0 * metrics.stream().mapToDouble(l -> ((Timer)l.get(prefix + key)).getMeanRate()).average().orElse(0.0));
        }
        return metrics.stream().mapToLong(l -> ((Counter)l.get(prefix + key)).getCount()).sum();
    }
}

