/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ConcurrentUpdateHttp2SolrClient
extends SolrClient {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ConcurrentUpdateSolrClient.Update END_UPDATE = new ConcurrentUpdateSolrClient.Update(null, null);
    private Http2SolrClient client;
    private final String basePath;
    private final CustomBlockingQueue<ConcurrentUpdateSolrClient.Update> queue;
    private final ExecutorService scheduler;
    private final Queue<Runner> runners;
    private final int threadCount;
    private boolean shutdownClient;
    private boolean shutdownExecutor;
    private int pollQueueTime = 250;
    private final boolean streamDeletes;
    private volatile boolean closed;
    private volatile CountDownLatch lock = null;

    protected ConcurrentUpdateHttp2SolrClient(Builder builder) {
        this.client = builder.client;
        this.shutdownClient = builder.closeHttp2Client;
        this.threadCount = builder.threadCount;
        this.queue = new CustomBlockingQueue<ConcurrentUpdateSolrClient.Update>(builder.queueSize, this.threadCount, END_UPDATE);
        this.runners = new LinkedList<Runner>();
        this.streamDeletes = builder.streamDeletes;
        this.basePath = builder.baseSolrUrl;
        if (builder.executorService != null) {
            this.scheduler = builder.executorService;
            this.shutdownExecutor = false;
        } else {
            this.scheduler = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("concurrentUpdateScheduler"));
            this.shutdownExecutor = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyQueueAndRunnersIfEmptyQueue() {
        if (this.queue.size() == 0) {
            Iterable<Object> iterable = this.queue;
            synchronized (iterable) {
                this.queue.notifyAll();
            }
            iterable = this.runners;
            synchronized (iterable) {
                this.runners.notifyAll();
            }
        }
    }

    private void addRunner() {
        MDC.put((String)"ConcurrentUpdateHttp2SolrClient.url", (String)this.client.getBaseURL());
        try {
            Runner r = new Runner();
            this.runners.add(r);
            try {
                this.scheduler.execute(r);
            }
            catch (RuntimeException e) {
                this.runners.remove(r);
                throw e;
            }
        }
        finally {
            MDC.remove((String)"ConcurrentUpdateHttp2SolrClient.url");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        ModifiableSolrParams params;
        if (!(request instanceof UpdateRequest)) {
            request.setBasePath(this.basePath);
            return this.client.request(request, collection);
        }
        UpdateRequest req = (UpdateRequest)request;
        req.setBasePath(this.basePath);
        if (this.streamDeletes) {
            if (!(req.getDocuments() != null && !req.getDocuments().isEmpty() || req.getDeleteById() != null && !req.getDeleteById().isEmpty() || req.getDeleteByIdMap() != null && !req.getDeleteByIdMap().isEmpty() || req.getDeleteQuery() != null)) {
                this.blockUntilFinished();
                return this.client.request(request, collection);
            }
        } else if (req.getDocuments() == null || req.getDocuments().isEmpty()) {
            this.blockUntilFinished();
            return this.client.request(request, collection);
        }
        if ((params = req.getParams()) != null && params.getBool("waitSearcher", false)) {
            log.info("blocking for commit/optimize");
            this.blockUntilFinished();
            return this.client.request(request, collection);
        }
        try {
            CountDownLatch tmpLock = this.lock;
            if (tmpLock != null) {
                tmpLock.await();
            }
            ConcurrentUpdateSolrClient.Update update = new ConcurrentUpdateSolrClient.Update(req, collection);
            boolean success = this.queue.offer(update);
            while (true) {
                Queue<Runner> queue = this.runners;
                synchronized (queue) {
                    if (this.runners.isEmpty() || this.queue.remainingCapacity() < this.queue.size() && this.runners.size() < this.threadCount) {
                        this.addRunner();
                    } else if (success) {
                        break;
                    }
                }
                if (success) continue;
                success = this.queue.offer(update, 100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("interrupted", (Throwable)e);
            throw new IOException(e.getLocalizedMessage());
        }
        NamedList<Object> dummy = new NamedList<Object>();
        dummy.add("NOTE", "the request is processed in a background stream");
        return dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void blockUntilFinished() {
        this.lock = new CountDownLatch(1);
        try {
            this.waitForEmptyQueue();
            this.interruptRunnerThreadsPolling();
            Queue<Runner> queue = this.runners;
            synchronized (queue) {
                int loopCount = 0;
                while (!this.runners.isEmpty() && !this.scheduler.isShutdown()) {
                    ++loopCount;
                    int queueSize = this.queue.size();
                    if (queueSize > 0 && this.runners.isEmpty()) {
                        log.warn("No more runners, but queue still has " + queueSize + " adding more runners to process remaining requests on queue");
                        this.addRunner();
                    }
                    this.interruptRunnerThreadsPolling();
                    int timeout = loopCount < 3 ? 10 : (loopCount < 10 ? 25 : 250);
                    try {
                        this.runners.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        finally {
            this.lock.countDown();
            this.lock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEmptyQueue() {
        boolean threadInterrupted = Thread.currentThread().isInterrupted();
        while (!this.queue.isEmpty()) {
            if (this.scheduler.isTerminated()) {
                log.warn("The task queue still has elements but the update scheduler {} is terminated. Can't process any more tasks. Queue size: {}, Runners: {}. Current thread Interrupted? {}", new Object[]{this.scheduler, this.queue.size(), this.runners.size(), threadInterrupted});
                break;
            }
            Iterable<Object> iterable = this.runners;
            synchronized (iterable) {
                int queueSize = this.queue.size();
                if (queueSize > 0 && this.runners.isEmpty()) {
                    log.warn("No more runners, but queue still has " + queueSize + " adding more runners to process remaining requests on queue");
                    this.addRunner();
                }
            }
            iterable = this.queue;
            synchronized (iterable) {
                try {
                    this.queue.wait(250L);
                }
                catch (InterruptedException e) {
                    threadInterrupted = true;
                    log.warn("Thread interrupted while waiting for update queue to be empty. There are still {} elements in the queue.", (Object)this.queue.size());
                }
            }
        }
        if (threadInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void handleError(Throwable ex) {
        log.error("error", ex);
    }

    public void onSuccess(Response resp, InputStream respBody) {
    }

    @Override
    public synchronized void close() {
        block9: {
            if (this.closed) {
                this.interruptRunnerThreadsPolling();
                return;
            }
            this.closed = true;
            try {
                if (this.shutdownExecutor) {
                    this.scheduler.shutdown();
                    this.interruptRunnerThreadsPolling();
                    try {
                        if (this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) break block9;
                        this.scheduler.shutdownNow();
                        if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                            log.error("ExecutorService did not terminate");
                        }
                        break block9;
                    }
                    catch (InterruptedException ie) {
                        this.scheduler.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                    break block9;
                }
                this.interruptRunnerThreadsPolling();
            }
            finally {
                if (this.shutdownClient) {
                    this.client.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptRunnerThreadsPolling() {
        Queue<Runner> queue = this.runners;
        synchronized (queue) {
            for (Runner ignored : this.runners) {
                this.queue.backdoorOffer();
            }
        }
    }

    public void shutdownNow() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.shutdownExecutor) {
            this.scheduler.shutdown();
            this.interruptRunnerThreadsPolling();
            this.scheduler.shutdownNow();
            try {
                if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                    log.error("ExecutorService did not terminate");
                }
            }
            catch (InterruptedException ie) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } else {
            this.interruptRunnerThreadsPolling();
        }
    }

    public void setPollQueueTime(int pollQueueTime) {
        this.pollQueueTime = pollQueueTime;
    }

    public static class Builder {
        protected Http2SolrClient client;
        protected String baseSolrUrl;
        protected int queueSize = 10;
        protected int threadCount;
        protected ExecutorService executorService;
        protected boolean streamDeletes;
        protected boolean closeHttp2Client;

        public Builder(String baseSolrUrl, Http2SolrClient client) {
            this(baseSolrUrl, client, false);
        }

        public Builder(String baseSolrUrl, Http2SolrClient client, boolean closeHttp2Client) {
            this.baseSolrUrl = baseSolrUrl;
            this.client = client;
            this.closeHttp2Client = closeHttp2Client;
        }

        public Builder withQueueSize(int queueSize) {
            if (queueSize <= 0) {
                throw new IllegalArgumentException("queueSize must be a positive integer.");
            }
            this.queueSize = queueSize;
            return this;
        }

        public Builder withThreadCount(int threadCount) {
            if (threadCount <= 0) {
                throw new IllegalArgumentException("threadCount must be a positive integer.");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder alwaysStreamDeletes() {
            this.streamDeletes = true;
            return this;
        }

        public Builder neverStreamDeletes() {
            this.streamDeletes = false;
            return this;
        }

        public ConcurrentUpdateHttp2SolrClient build() {
            if (this.baseSolrUrl == null) {
                throw new IllegalArgumentException("Cannot create HttpSolrClient without a valid baseSolrUrl!");
            }
            return new ConcurrentUpdateHttp2SolrClient(this);
        }
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug("starting runner: {}", (Object)this);
            while (true) {
                try {
                    this.sendUpdateStream();
                    continue;
                }
                catch (Throwable e) {
                    if (e instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)e;
                    }
                    ConcurrentUpdateHttp2SolrClient.this.handleError(e);
                    continue;
                }
                finally {
                    Queue queue = ConcurrentUpdateHttp2SolrClient.this.runners;
                    synchronized (queue) {
                        if (ConcurrentUpdateHttp2SolrClient.this.runners.size() != 1 || ConcurrentUpdateHttp2SolrClient.this.queue.isEmpty() || ConcurrentUpdateHttp2SolrClient.this.scheduler.isShutdown()) {
                            ConcurrentUpdateHttp2SolrClient.this.runners.remove(this);
                            if (ConcurrentUpdateHttp2SolrClient.this.runners.isEmpty()) {
                                ConcurrentUpdateHttp2SolrClient.this.runners.notifyAll();
                            }
                            break;
                        }
                    }
                    continue;
                }
                break;
            }
            log.debug("finished: {}", (Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendUpdateStream() throws Exception {
            try {
                while (!ConcurrentUpdateHttp2SolrClient.this.queue.isEmpty()) {
                    InputStream rspBody = null;
                    try {
                        ConcurrentUpdateHttp2SolrClient.this.notifyQueueAndRunnersIfEmptyQueue();
                        ConcurrentUpdateSolrClient.Update update = (ConcurrentUpdateSolrClient.Update)ConcurrentUpdateHttp2SolrClient.this.queue.poll(ConcurrentUpdateHttp2SolrClient.this.pollQueueTime, TimeUnit.MILLISECONDS);
                        if (update == null) break;
                        InputStreamResponseListener responseListener = null;
                        try (Http2SolrClient.OutStream out = ConcurrentUpdateHttp2SolrClient.this.client.initOutStream(ConcurrentUpdateHttp2SolrClient.this.basePath, update.getRequest(), update.getCollection());){
                            ConcurrentUpdateSolrClient.Update upd = update;
                            while (upd != null) {
                                UpdateRequest req = upd.getRequest();
                                if (!out.belongToThisStream(req, upd.getCollection())) {
                                    ConcurrentUpdateHttp2SolrClient.this.queue.add(upd);
                                    break;
                                }
                                ConcurrentUpdateHttp2SolrClient.this.client.send(out, upd.getRequest(), upd.getCollection());
                                out.flush();
                                ConcurrentUpdateHttp2SolrClient.this.notifyQueueAndRunnersIfEmptyQueue();
                                upd = (ConcurrentUpdateSolrClient.Update)ConcurrentUpdateHttp2SolrClient.this.queue.poll(ConcurrentUpdateHttp2SolrClient.this.pollQueueTime, TimeUnit.MILLISECONDS);
                            }
                            responseListener = out.getResponseListener();
                        }
                        Response response = responseListener.get(ConcurrentUpdateHttp2SolrClient.this.client.getIdleTimeout(), TimeUnit.MILLISECONDS);
                        rspBody = responseListener.getInputStream();
                        int statusCode = response.getStatus();
                        if (statusCode != 200) {
                            HttpSolrClient.RemoteSolrException solrExc;
                            StringBuilder msg = new StringBuilder();
                            msg.append(response.getReason());
                            msg.append("\n\n\n\n");
                            msg.append("request: ").append(ConcurrentUpdateHttp2SolrClient.this.basePath);
                            NamedList metadata = null;
                            try {
                                String encoding = "UTF-8";
                                NamedList<Object> resp = ConcurrentUpdateHttp2SolrClient.this.client.getParser().processResponse(rspBody, encoding);
                                NamedList error = (NamedList)resp.get("error");
                                if (error != null) {
                                    metadata = (NamedList)error.get("metadata");
                                    String remoteMsg = (String)error.get("msg");
                                    if (remoteMsg != null) {
                                        msg.append("\nRemote error message: ");
                                        msg.append(remoteMsg);
                                    }
                                }
                                solrExc = new HttpSolrClient.RemoteSolrException(ConcurrentUpdateHttp2SolrClient.this.basePath, statusCode, msg.toString(), null);
                                if (metadata != null) {
                                    solrExc.setMetadata(metadata);
                                }
                            }
                            catch (Exception exc) {
                                try {
                                    log.warn("Failed to parse error response from " + ConcurrentUpdateHttp2SolrClient.this.basePath + " due to: " + exc);
                                    solrExc = new HttpSolrClient.RemoteSolrException(ConcurrentUpdateHttp2SolrClient.this.basePath, statusCode, msg.toString(), null);
                                    if (metadata != null) {
                                        solrExc.setMetadata(metadata);
                                    }
                                }
                                catch (Throwable throwable) {
                                    solrExc = new HttpSolrClient.RemoteSolrException(ConcurrentUpdateHttp2SolrClient.this.basePath, statusCode, msg.toString(), null);
                                    if (metadata != null) {
                                        solrExc.setMetadata(metadata);
                                    }
                                    throw throwable;
                                }
                            }
                            ConcurrentUpdateHttp2SolrClient.this.handleError(solrExc);
                            continue;
                        }
                        ConcurrentUpdateHttp2SolrClient.this.onSuccess(response, rspBody);
                    }
                    finally {
                        try {
                            if (rspBody != null) {
                                while (rspBody.read() != -1) {
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error("Error consuming and closing http response stream.", (Throwable)e);
                        }
                        ConcurrentUpdateHttp2SolrClient.this.notifyQueueAndRunnersIfEmptyQueue();
                    }
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupted on polling from queue", (Throwable)e);
            }
        }
    }

    private static class CustomBlockingQueue<E>
    implements Iterable<E> {
        private final BlockingQueue<E> queue = new LinkedBlockingQueue();
        private final Semaphore available;
        private final int queueSize;
        private final E backdoorE;

        public CustomBlockingQueue(int queueSize, int maxConsumers, E backdoorE) {
            this.available = new Semaphore(queueSize);
            this.queueSize = queueSize;
            this.backdoorE = backdoorE;
        }

        public boolean offer(E e) {
            boolean success = this.available.tryAcquire();
            if (success) {
                this.queue.offer(e);
            }
            return success;
        }

        public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
            boolean success = this.available.tryAcquire(timeout, unit);
            if (success) {
                this.queue.offer(e);
            }
            return success;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public E poll(int timeout, TimeUnit unit) throws InterruptedException {
            E e = this.queue.poll(timeout, unit);
            if (e == null) {
                return null;
            }
            if (e == this.backdoorE) {
                return null;
            }
            this.available.release();
            return e;
        }

        public boolean add(E e) {
            boolean success = this.available.tryAcquire();
            if (!success) {
                throw new IllegalStateException("Queue is full");
            }
            this.queue.add(e);
            return true;
        }

        public int size() {
            return this.queueSize - this.available.availablePermits();
        }

        public int remainingCapacity() {
            return this.available.availablePermits();
        }

        @Override
        public Iterator<E> iterator() {
            return this.queue.iterator();
        }

        public void backdoorOffer() {
            this.queue.offer(this.backdoorE);
        }
    }
}

