/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;

public class ClusterStatus {
    private final ZkStateReader zkStateReader;
    private final ZkNodeProps message;
    private final String collection;

    public ClusterStatus(ZkStateReader zkStateReader, ZkNodeProps props) {
        this.zkStateReader = zkStateReader;
        this.message = props;
        this.collection = props.getStr("collection");
    }

    public void getClusterStatus(NamedList results) throws KeeperException, InterruptedException {
        Map collectionAliasMap;
        boolean didNotFindCollection;
        Aliases aliases = this.zkStateReader.getAliases();
        HashMap<String, List> collectionVsAliases = new HashMap<String, List>();
        Map aliasVsCollections = aliases.getCollectionAliasListMap();
        for (Map.Entry entry2 : aliasVsCollections.entrySet()) {
            String alias = (String)entry2.getKey();
            List colls = (List)entry2.getValue();
            for (String coll : colls) {
                if (this.collection != null && !this.collection.equals(coll)) continue;
                List list = collectionVsAliases.computeIfAbsent(coll, k -> new ArrayList());
                list.add(alias);
            }
        }
        Map roles = null;
        if (this.zkStateReader.getZkClient().exists("/roles.json", true).booleanValue()) {
            roles = (Map)Utils.fromJSON((byte[])this.zkStateReader.getZkClient().getData("/roles.json", null, null, true));
        }
        ClusterState clusterState = this.zkStateReader.getClusterState();
        byte[] bytes = Utils.toJSON((Object)clusterState);
        Map stateMap = (Map)Utils.fromJSON((byte[])bytes);
        String routeKey = this.message.getStr("_route_");
        String shard = this.message.getStr("shard");
        Map<String, DocCollection> collectionsMap = null;
        collectionsMap = this.collection == null ? clusterState.getCollectionsMap() : Collections.singletonMap(this.collection, clusterState.getCollectionOrNull(this.collection));
        boolean isAlias = aliasVsCollections.containsKey(this.collection);
        boolean bl = didNotFindCollection = collectionsMap.get(this.collection) == null;
        if (didNotFindCollection && isAlias) {
            collectionsMap = clusterState.getCollectionsMap().entrySet().stream().filter(entry -> ((List)aliasVsCollections.get(this.collection)).contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        SimpleOrderedMap collectionProps = new SimpleOrderedMap();
        for (Map.Entry<String, DocCollection> entry3 : collectionsMap.entrySet()) {
            Map<String, Object> collectionStatus;
            String name = entry3.getKey();
            DocCollection clusterStateCollection = entry3.getValue();
            if (clusterStateCollection == null) {
                if (this.collection == null) continue;
                SolrException solrException = new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
                solrException.setMetadata("CLUSTERSTATUS", "NOT_FOUND");
                throw solrException;
            }
            HashSet<String> requestedShards = new HashSet<String>();
            if (routeKey != null) {
                DocRouter router = clusterStateCollection.getRouter();
                Collection slices = router.getSearchSlices(routeKey, null, clusterStateCollection);
                for (Slice slice : slices) {
                    requestedShards.add(slice.getName());
                }
            }
            if (shard != null) {
                String[] paramShards = shard.split(",");
                requestedShards.addAll(Arrays.asList(paramShards));
            }
            if (clusterStateCollection.getStateFormat() > 1) {
                bytes = Utils.toJSON((Object)clusterStateCollection);
                Map docCollection = (Map)Utils.fromJSON((byte[])bytes);
                collectionStatus = this.getCollectionStatus(docCollection, name, requestedShards);
            } else {
                collectionStatus = this.getCollectionStatus((Map)stateMap.get(name), name, requestedShards);
            }
            collectionStatus.put("znodeVersion", clusterStateCollection.getZNodeVersion());
            if (collectionVsAliases.containsKey(name) && !((List)collectionVsAliases.get(name)).isEmpty()) {
                collectionStatus.put("aliases", collectionVsAliases.get(name));
            }
            try {
                String configName = this.zkStateReader.readConfigName(name);
                collectionStatus.put("configName", configName);
                collectionProps.add(name, collectionStatus);
            }
            catch (SolrException e) {
                if (e.getCause() instanceof KeeperException.NoNodeException) continue;
                throw e;
            }
        }
        List liveNodes = this.zkStateReader.getZkClient().getChildren("/live_nodes", null, true);
        this.crossCheckReplicaStateWithLiveNodes(liveNodes, (NamedList<Object>)collectionProps);
        SimpleOrderedMap clusterStatus = new SimpleOrderedMap();
        clusterStatus.add("collections", (Object)collectionProps);
        Map clusterProps = this.zkStateReader.getClusterProperties();
        if (clusterProps != null && !clusterProps.isEmpty()) {
            clusterStatus.add("properties", (Object)clusterProps);
        }
        if (!(collectionAliasMap = aliases.getCollectionAliasMap()).isEmpty()) {
            clusterStatus.add("aliases", (Object)collectionAliasMap);
        }
        if (roles != null) {
            clusterStatus.add("roles", (Object)roles);
        }
        clusterStatus.add("live_nodes", (Object)liveNodes);
        results.add("cluster", (Object)clusterStatus);
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> collection, String name, Set<String> requestedShards) {
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (requestedShards == null || requestedShards.isEmpty()) {
            return collection;
        }
        Map shards = (Map)collection.get("shards");
        HashMap selected = new HashMap();
        for (String selectedShard : requestedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            collection.put("shards", selected);
        }
        return collection;
    }

    protected void crossCheckReplicaStateWithLiveNodes(List<String> liveNodes, NamedList<Object> collectionProps) {
        for (Map.Entry next : collectionProps) {
            Map collMap = (Map)next.getValue();
            Map shards = (Map)collMap.get("shards");
            for (Object nextShard : shards.values()) {
                Map shardMap = (Map)nextShard;
                Map replicas = (Map)shardMap.get("replicas");
                for (Object nextReplica : replicas.values()) {
                    String node_name;
                    Map replicaMap = (Map)nextReplica;
                    if (Replica.State.getState((String)((String)replicaMap.get("state"))) == Replica.State.DOWN || liveNodes.contains(node_name = (String)replicaMap.get("node_name"))) continue;
                    replicaMap.put("state", Replica.State.DOWN.toString());
                }
            }
        }
    }
}

