/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.jetbrains.extensions.ModuleExtKt;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PySyncDirection;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class NewFilesProcessor {
    private NewFilesProcessor() {
    }

    @NotNull
    public static String processNewFiles(@NotNull Module module2, @NotNull String files) {
        if (module2 == null) {
            NewFilesProcessor.$$$reportNull$$$0(0);
        }
        if (files == null) {
            NewFilesProcessor.$$$reportNull$$$0(1);
        }
        Sdk sdk = ModuleExtKt.getSdk(module2);
        assert (sdk != null) : String.format("Sdk can't be null on module %s", module2);
        PyProjectSynchronizer synchronizer = PythonRemoteInterpreterManager.getSynchronizerInstance(sdk);
        String[] fileNames = StringUtil.split((String)files, (String)",").toArray(ArrayUtil.EMPTY_STRING_ARRAY);
        if (fileNames.length == 0) {
            if ("" == null) {
                NewFilesProcessor.$$$reportNull$$$0(2);
            }
            return "";
        }
        if (synchronizer != null) {
            synchronizer.syncProject(module2, PySyncDirection.REMOTE_TO_LOCAL, success -> {
                if (module2 == null) {
                    NewFilesProcessor.$$$reportNull$$$0(6);
                }
                if (!success.booleanValue()) {
                    return;
                }
                String[] localFileNames = (String[])Arrays.stream(fileNames).map(remoteName -> {
                    if (module2 == null) {
                        NewFilesProcessor.$$$reportNull$$$0(7);
                    }
                    return synchronizer.mapFilePath(module2.getProject(), PySyncDirection.REMOTE_TO_LOCAL, (String)remoteName);
                }).filter(localFileName -> localFileName != null).toArray(String[]::new);
                NewFilesProcessor.addToVcsIfNeeded(module2, localFileNames);
            }, fileNames);
        } else {
            NewFilesProcessor.addToVcsIfNeeded(module2, fileNames);
        }
        String string = String.format("Following files were affected \n %s", StringUtil.join((String[])fileNames, (String)"\n"));
        if (string == null) {
            NewFilesProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void addToVcsIfNeeded(@NotNull Module module2, String ... localFileNames) {
        if (module2 == null) {
            NewFilesProcessor.$$$reportNull$$$0(4);
        }
        if (localFileNames == null) {
            NewFilesProcessor.$$$reportNull$$$0(5);
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        fs.refresh(false);
        Project project = module2.getProject();
        Arrays.stream(localFileNames).map(o -> fs.findFileByPath(o)).filter(o -> o != null).forEach(file -> {
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)file);
            if (vcs == null) {
                return;
            }
            CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                environment.scheduleUnversionedFilesForAddition(Collections.singletonList(file));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/NewFilesProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/NewFilesProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processNewFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNewFiles";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addToVcsIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processNewFiles$3";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

