/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    protected ParsingContext myContext;
    protected PsiBuilder myBuilder;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.parsing.Parsing");

    protected Parsing(ParsingContext context) {
        this.myContext = context;
        this.myBuilder = context.getBuilder();
    }

    public ParsingContext getParsingContext() {
        return this.myContext;
    }

    public ExpressionParsing getExpressionParser() {
        return this.getParsingContext().getExpressionParser();
    }

    public StatementParsing getStatementParser() {
        return this.getParsingContext().getStatementParser();
    }

    public FunctionParsing getFunctionParser() {
        return this.getParsingContext().getFunctionParser();
    }

    protected boolean checkMatches(IElementType token, @NotNull String message) {
        if (message == null) {
            Parsing.$$$reportNull$$$0(0);
        }
        if (this.myBuilder.getTokenType() == token) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    protected boolean parseIdentifierOrSkip(IElementType ... validSuccessiveTokens) {
        if (validSuccessiveTokens == null) {
            Parsing.$$$reportNull$$$0(1);
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            this.myBuilder.advanceLexer();
            return true;
        }
        PsiBuilder.Marker nameExpected = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && !this.atAnyOfTokens(validSuccessiveTokens)) {
            this.myBuilder.advanceLexer();
        }
        nameExpected.error(PyBundle.message("PARSE.expected.identifier", new Object[0]));
        return false;
    }

    protected void assertCurrentToken(PyElementType tokenType) {
        LOG.assertTrue(this.myBuilder.getTokenType() == tokenType);
    }

    protected boolean atToken(@Nullable IElementType tokenType) {
        return this.myBuilder.getTokenType() == tokenType;
    }

    protected boolean atToken(@NotNull IElementType tokenType, @NotNull String tokenText) {
        if (tokenType == null) {
            Parsing.$$$reportNull$$$0(2);
        }
        if (tokenText == null) {
            Parsing.$$$reportNull$$$0(3);
        }
        return this.myBuilder.getTokenType() == tokenType && tokenText.equals(this.myBuilder.getTokenText());
    }

    protected boolean atAnyOfTokens(IElementType ... tokenTypes) {
        IElementType currentTokenType = this.myBuilder.getTokenType();
        for (IElementType tokenType : tokenTypes) {
            if (currentTokenType != tokenType) continue;
            return true;
        }
        return false;
    }

    protected boolean matchToken(IElementType tokenType) {
        if (this.myBuilder.getTokenType() == tokenType) {
            this.myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    protected void nextToken() {
        this.myBuilder.advanceLexer();
    }

    protected void advanceAsync(boolean falseAsync) {
        if (falseAsync) {
            Parsing.advanceError(this.myBuilder, "'async' keyword is not expected here");
        } else {
            this.myBuilder.advanceLexer();
        }
    }

    protected static void advanceIdentifierLike(@NotNull PsiBuilder builder) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(4);
        }
        if (Parsing.isFalseIdentifier(builder)) {
            String tokenText = builder.getTokenText();
            Parsing.advanceError(builder, "'" + tokenText + "' keyword can't be used as identifier in Python 2");
        } else {
            builder.advanceLexer();
        }
    }

    protected static void advanceError(@NotNull PsiBuilder builder, @NotNull String message) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(5);
        }
        if (message == null) {
            Parsing.$$$reportNull$$$0(6);
        }
        PsiBuilder.Marker err = builder.mark();
        builder.advanceLexer();
        err.error(message);
    }

    protected static boolean isIdentifier(@NotNull PsiBuilder builder) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(7);
        }
        return builder.getTokenType() == PyTokenTypes.IDENTIFIER || Parsing.isFalseIdentifier(builder);
    }

    private static boolean isFalseIdentifier(@NotNull PsiBuilder builder) {
        if (builder == null) {
            Parsing.$$$reportNull$$$0(8);
        }
        return builder.getTokenType() == PyTokenTypes.EXEC_KEYWORD || builder.getTokenType() == PyTokenTypes.PRINT_KEYWORD;
    }

    protected static void buildTokenElement(IElementType type, PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Parsing.advanceIdentifierLike(builder);
        marker.done(type);
    }

    protected IElementType getReferenceType() {
        return PyElementTypes.REFERENCE_EXPRESSION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validSuccessiveTokens";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/parsing/Parsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMatches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseIdentifierOrSkip";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "atToken";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceIdentifierLike";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceError";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isFalseIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

