/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionReturnTypeQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PyFunction> myFunction;
    private final SmartPsiElementPointer<PyAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiComment> myTypeCommentAnnotation;
    private final String myReturnTypeName;

    public PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @Nullable String returnTypeName, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)function.getProject());
        this.myFunction = manager.createSmartPsiElementPointer((PsiElement)function);
        PyAnnotation annotation = function.getAnnotation();
        this.myAnnotation = annotation != null ? manager.createSmartPsiElementPointer((PsiElement)annotation) : null;
        PsiComment typeCommentAnnotation = function.getTypeComment();
        this.myTypeCommentAnnotation = typeCommentAnnotation != null ? manager.createSmartPsiElementPointer((PsiElement)typeCommentAnnotation) : null;
        this.myReturnTypeName = returnTypeName == null ? PythonDocumentationProvider.getTypeName(function.getReturnStatementType(context), context) : returnTypeName;
    }

    @NotNull
    public String getName() {
        PyFunction function = (PyFunction)this.myFunction.getElement();
        String functionName = function != null ? function.getName() : "function";
        String string = PyBundle.message("QFIX.NAME.make.$0.return.$1", functionName, this.myReturnTypeName);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.make.$0.return.$1", "function", "inferred type");
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiComment typeComment;
        if (project == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (this.myAnnotation != null) {
            PyAnnotation annotation = (PyAnnotation)this.myAnnotation.getElement();
            if (annotation != null) {
                PyExpression annotationExpr = annotation.getValue();
                if (annotationExpr == null) {
                    return;
                }
                annotationExpr.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.PYTHON34, this.myReturnTypeName));
            }
        } else if (this.myTypeCommentAnnotation != null && (typeComment = (PsiComment)this.myTypeCommentAnnotation.getElement()) != null) {
            StringBuilder typeCommentAnnotation = new StringBuilder(typeComment.getText());
            typeCommentAnnotation.delete(typeCommentAnnotation.indexOf("->"), typeCommentAnnotation.length());
            typeCommentAnnotation.append("-> ").append(this.myReturnTypeName);
            PsiComment newTypeComment = elementGenerator.createFromText(LanguageLevel.PYTHON27, PsiComment.class, typeCommentAnnotation.toString());
            typeComment.replace((PsiElement)newTypeComment);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

