/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyMandatoryEncodingInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;
    public boolean myAllPythons = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.mandatory.encoding", new Object[0]);
        if (string == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    public JComponent createOptionsPanel() {
        JPanel main = new JPanel(new GridBagLayout());
        main.add((Component)this.onlyPython2Box(), PyMandatoryEncodingInspection.fixedIn(0));
        main.add((Component)PyMandatoryEncodingInspection.defaultEncodingLabel(), PyMandatoryEncodingInspection.fixedIn(1));
        main.add(this.defaultEncodingBox(), PyMandatoryEncodingInspection.resizableIn(1));
        main.add((Component)PyMandatoryEncodingInspection.encodingFormatLabel(), PyMandatoryEncodingInspection.fixedIn(2));
        main.add(this.encodingFormatBox(), PyMandatoryEncodingInspection.resizableIn(2));
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)main, "North");
        return result;
    }

    @NotNull
    private static GridBagConstraints fixedIn(int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = y;
        GridBagConstraints gridBagConstraints = c;
        if (gridBagConstraints == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(4);
        }
        return gridBagConstraints;
    }

    @NotNull
    private static GridBagConstraints resizableIn(int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = y;
        GridBagConstraints gridBagConstraints = c;
        if (gridBagConstraints == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(5);
        }
        return gridBagConstraints;
    }

    @NotNull
    private JPanel onlyPython2Box() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add((Component)new CheckBox("Enable in Python 3+", (InspectionProfileEntry)this, "myAllPythons"));
        JPanel jPanel = panel;
        if (jPanel == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel defaultEncodingLabel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Select default encoding: "));
        JPanel jPanel = panel;
        if (jPanel == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    private JComboBox<String> defaultEncodingBox() {
        ComboBox box = new ComboBox((Object[])PyEncodingUtil.POSSIBLE_ENCODINGS);
        box.setSelectedItem(this.myDefaultEncoding);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyMandatoryEncodingInspection.this.myDefaultEncoding = (String)cb.getSelectedItem();
            }
        });
        ComboBox comboBox = box;
        if (comboBox == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(8);
        }
        return comboBox;
    }

    @NotNull
    private static JPanel encodingFormatLabel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Encoding comment format:"));
        JPanel jPanel = panel;
        if (jPanel == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @NotNull
    private JComboBox<String> encodingFormatBox() {
        ComboBox box = new ComboBox((Object[])PyEncodingUtil.ENCODING_FORMAT, 250);
        box.setSelectedIndex(this.myEncodingFormatIndex);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyMandatoryEncodingInspection.this.myEncodingFormatIndex = cb.getSelectedIndex();
            }
        });
        ComboBox comboBox = box;
        if (comboBox == null) {
            PyMandatoryEncodingInspection.$$$reportNull$$$0(10);
        }
        return comboBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMandatoryEncodingInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fixedIn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resizableIn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyPython2Box";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultEncodingBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatLabel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingFormatBox";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            if (!PyMandatoryEncodingInspection.this.myAllPythons && !LanguageLevel.forElement((PsiElement)node).isPython2()) {
                return;
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(node);
            if (charsetString == null) {
                TextRange tr = new TextRange(0, 0);
                ProblemsHolder holder = this.getHolder();
                if (holder != null) {
                    holder.registerProblem((PsiElement)node, tr, "No encoding specified for file", new LocalQuickFix[]{new AddEncodingQuickFix(PyMandatoryEncodingInspection.this.myDefaultEncoding, PyMandatoryEncodingInspection.this.myEncodingFormatIndex)});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection$Visitor", "<init>"));
        }
    }
}

