/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InvocationCache {
    private static final Map<JavaMethodSignature, Invocation> ourCoreInvocations = new HashMap<JavaMethodSignature, Invocation>();
    private final Map<Method, Invocation> myInvocations = ConcurrentFactoryMap.createMap(key -> ourCoreInvocations.get(new JavaMethodSignature(key)));
    private final Map<Method, JavaMethod> myJavaMethods;
    private final Map<JavaMethod, Boolean> myGetters = ConcurrentFactoryMap.createMap(key -> DomImplUtil.isTagValueGetter(key));
    private final Map<JavaMethod, Boolean> mySetters = ConcurrentFactoryMap.createMap(key -> DomImplUtil.isTagValueSetter(key));
    private final Map<JavaMethod, Map<Class, Object>> myMethodAnnotations = ConcurrentFactoryMap.createMap(method -> ConcurrentFactoryMap.createMap(annoClass -> method.getAnnotation(annoClass)));
    private final Map<Class, Object> myClassAnnotations;
    private final Class myType;

    private static void addCoreInvocations(Class<?> aClass) {
        for (final Method method : ReflectionUtil.getClassDeclaredMethods(aClass)) {
            if ("equals".equals(method.getName())) {
                ourCoreInvocations.put(new JavaMethodSignature(method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                        Object arg;
                        DomElement proxy2 = handler.getProxy();
                        if (proxy2 == (arg = args[0])) {
                            return true;
                        }
                        if (arg == null) {
                            return false;
                        }
                        if (arg instanceof DomElement) {
                            DomInvocationHandler handler1 = DomManagerImpl.getDomInvocationHandler(proxy2);
                            return handler1 != null && handler1.equals((Object)DomManagerImpl.getDomInvocationHandler((DomElement)arg));
                        }
                        return false;
                    }
                });
                continue;
            }
            if ("hashCode".equals(method.getName())) {
                ourCoreInvocations.put(new JavaMethodSignature(method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                        return handler.hashCode();
                    }
                });
                continue;
            }
            ourCoreInvocations.put(new JavaMethodSignature(method), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                    return method.invoke((Object)handler, args);
                }
            });
        }
    }

    public InvocationCache(Class type) {
        this.myType = type;
        this.myJavaMethods = ConcurrentFactoryMap.createMap(key -> JavaMethod.getMethod((Class)this.myType, (Method)key));
        this.myClassAnnotations = ConcurrentFactoryMap.createMap(annoClass -> this.myType.getAnnotation(annoClass));
    }

    @Nullable
    public Invocation getInvocation(Method method) {
        return this.myInvocations.get(method);
    }

    public JavaMethod getInternedMethod(Method method) {
        return this.myJavaMethods.get(method);
    }

    public void putInvocation(Method method, Invocation invocation) {
        this.myInvocations.put(method, invocation);
    }

    public boolean isTagValueGetter(JavaMethod method) {
        return this.myGetters.get(method);
    }

    public boolean isTagValueSetter(JavaMethod method) {
        return this.mySetters.get(method);
    }

    @Nullable
    public <T extends Annotation> T getMethodAnnotation(JavaMethod method, Class<T> annoClass) {
        return (T)((Annotation)this.myMethodAnnotations.get(method).get(annoClass));
    }

    @Nullable
    public <T extends Annotation> T getClassAnnotation(Class<T> annoClass) {
        return (T)((Annotation)this.myClassAnnotations.get(annoClass));
    }

    static {
        InvocationCache.addCoreInvocations(DomElement.class);
        InvocationCache.addCoreInvocations(Navigatable.class);
        InvocationCache.addCoreInvocations(AnnotatedElement.class);
        InvocationCache.addCoreInvocations(Object.class);
        ourCoreInvocations.put(new JavaMethodSignature("getUserData", new Class[]{Key.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getUserData((Key)args[0]);
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("putUserData", new Class[]{Key.class, Object.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                handler.putUserData((Key)args[0], args[1]);
                return null;
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getXmlElement", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getXmlElement();
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getXmlTag", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getXmlTag();
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getParent", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getParent();
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("accept", new Class[]{DomElementVisitor.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                handler.accept((DomElementVisitor)args[0]);
                return null;
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("acceptChildren", new Class[]{DomElementVisitor.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                handler.acceptChildren((DomElementVisitor)args[0]);
                return null;
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getAnnotation", new Class[]{Class.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getAnnotation((Class)args[0]);
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getRawText", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getValue();
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getXmlAttribute", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                return handler.getXmlElement();
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getXmlAttributeValue", new Class[0]), new Invocation(){

            @Override
            @Nullable
            public final Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                XmlAttribute attribute = (XmlAttribute)handler.getXmlElement();
                return attribute != null ? attribute.getValueElement() : null;
            }
        });
        ourCoreInvocations.put(new JavaMethodSignature("getConverter", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> handler, Object[] args) throws Throwable {
                try {
                    return handler.getScalarConverter();
                }
                catch (Throwable e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)cause;
                    }
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

