/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentContent
extends DiffContent {
    private final Document myDocument;
    private final VirtualFile myFile;
    private final FileType myOverriddenType;
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;

    public DocumentContent(Project project, Document document) {
        this(project, document, null);
    }

    public DocumentContent(Project project, @NotNull Document document, FileType type) {
        if (document == null) {
            DocumentContent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDocument = document;
        this.myDocumentManager = FileDocumentManager.getInstance();
        this.myFile = this.myDocumentManager.getFile(document);
        this.myOverriddenType = type;
    }

    public DocumentContent(@NotNull Document document) {
        if (document == null) {
            DocumentContent.$$$reportNull$$$0(1);
        }
        this(null, document, null);
    }

    public DocumentContent(@NotNull Document document, @NotNull FileType type) {
        if (document == null) {
            DocumentContent.$$$reportNull$$$0(2);
        }
        if (type == null) {
            DocumentContent.$$$reportNull$$$0(3);
        }
        this(null, document, type);
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DocumentContent.$$$reportNull$$$0(4);
        }
        return document;
    }

    @Override
    public Navigatable getOpenFileDescriptor(int offset) {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        if (this.myProject == null) {
            return null;
        }
        return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, offset);
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myOverriddenType == null ? DiffContentUtil.getContentType(this.getFile()) : this.myOverriddenType;
    }

    @Override
    public byte[] getBytes() {
        return this.myDocument.getText().getBytes();
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        LineSeparator lineSeparator = LineSeparator.fromString((String)this.myDocumentManager.getLineSeparator(this.myFile, this.myProject));
        if (lineSeparator == null) {
            DocumentContent.$$$reportNull$$$0(5);
        }
        return lineSeparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/DocumentContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/DocumentContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

