/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

@State(name="IssueNavigationConfiguration", storages={@Storage(value="vcs.xml")})
public class IssueNavigationConfiguration
extends SimpleModificationTracker
implements PersistentStateComponent<IssueNavigationConfiguration> {
    private static final Logger LOG = Logger.getInstance(IssueNavigationConfiguration.class);
    private List<IssueNavigationLink> myLinks = new ArrayList<IssueNavigationLink>();

    public static IssueNavigationConfiguration getInstance(Project project) {
        return ServiceManager.getService(project, IssueNavigationConfiguration.class);
    }

    public List<IssueNavigationLink> getLinks() {
        return this.myLinks;
    }

    public void setLinks(List<? extends IssueNavigationLink> links) {
        this.myLinks = new ArrayList<IssueNavigationLink>(links);
        this.incModificationCount();
    }

    @Override
    public IssueNavigationConfiguration getState() {
        return this;
    }

    @Override
    public void loadState(@NotNull IssueNavigationConfiguration state) {
        if (state == null) {
            IssueNavigationConfiguration.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public List<LinkMatch> findIssueLinks(CharSequence text) {
        ArrayList<LinkMatch> result2 = new ArrayList<LinkMatch>();
        try {
            for (IssueNavigationLink link : this.myLinks) {
                Pattern issuePattern = link.getIssuePattern();
                Matcher m = issuePattern.matcher(text);
                while (m.find()) {
                    try {
                        String replacement = issuePattern.matcher(m.group(0)).replaceFirst(link.getLinkRegexp());
                        IssueNavigationConfiguration.addMatch(result2, new TextRange(m.start(), m.end()), replacement);
                    }
                    catch (Exception e) {
                        LOG.debug("Malformed regex replacement. IssueLink: " + link + "; text: " + text, (Throwable)e);
                    }
                }
            }
            Matcher m = URLUtil.URL_PATTERN.matcher(text);
            while (m.find()) {
                IssueNavigationConfiguration.addMatch(result2, new TextRange(m.start(), m.end()), m.group());
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        Collections.sort(result2);
        return result2;
    }

    private static void addMatch(List<LinkMatch> result2, TextRange range, String replacement) {
        Iterator<LinkMatch> iterator = result2.iterator();
        while (iterator.hasNext()) {
            LinkMatch oldMatch = iterator.next();
            if (range.contains(oldMatch.getRange())) {
                iterator.remove();
                continue;
            }
            if (!oldMatch.getRange().contains(range)) continue;
            return;
        }
        result2.add(new LinkMatch(range, replacement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vcs/IssueNavigationConfiguration", "loadState"));
    }

    public static class LinkMatch
    implements Comparable {
        private final TextRange myRange;
        private final String myTargetUrl;

        public LinkMatch(TextRange range, String targetUrl) {
            this.myRange = range;
            this.myTargetUrl = targetUrl;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public String getTargetUrl() {
            return this.myTargetUrl;
        }

        public int compareTo(Object o) {
            if (!(o instanceof LinkMatch)) {
                return 0;
            }
            return this.myRange.getStartOffset() - ((LinkMatch)o).getRange().getStartOffset();
        }
    }
}

