/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyParametersRenameFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            PyParametersRenameFactory.$$$reportNull$$$0(0);
        }
        if (element instanceof PyParameter) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            return function != null && function.getContainingClass() != null;
        }
        return false;
    }

    public String getOptionName() {
        return "Rename parameters in hierarchy";
    }

    public boolean isEnabled() {
        return PyCodeInsightSettings.getInstance().RENAME_PARAMETERS_IN_HIERARCHY;
    }

    public void setEnabled(boolean enabled) {
        PyCodeInsightSettings.getInstance().RENAME_PARAMETERS_IN_HIERARCHY = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        PyParametersRenamer pyParametersRenamer = new PyParametersRenamer((PyParameter)element, newName);
        if (pyParametersRenamer == null) {
            PyParametersRenameFactory.$$$reportNull$$$0(1);
        }
        return pyParametersRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/PyParametersRenameFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/PyParametersRenameFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PyParametersRenamer
    extends AutomaticRenamer {
        public PyParametersRenamer(PyParameter element, String newName) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            PyOverridingMethodsSearch.search(function, true).forEach(pyFunction -> {
                PyParameter[] parameters2;
                for (PyParameter parameter : parameters2 = pyFunction.getParameterList().getParameters()) {
                    PyNamedParameter named = parameter.getAsNamed();
                    if (named == null || !Comparing.equal((String)named.getName(), (String)element.getName())) continue;
                    this.myElements.add(named);
                }
                return true;
            });
            this.suggestAllNames(element.getName(), newName);
        }

        public String getDialogTitle() {
            return "Rename Parameters";
        }

        public String getDialogDescription() {
            return "Rename parameter in hierarchy to:";
        }

        public String entityName() {
            return "Parameter";
        }

        public boolean isSelectedByDefault() {
            return true;
        }
    }
}

