/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.util.ArrayList;
import java.util.List;

public class PyMethodDescriptor
implements MethodDescriptor<PyParameterInfo, String> {
    private final PyFunction myFunction;

    public PyMethodDescriptor(PyFunction function) {
        this.myFunction = function;
    }

    public String getName() {
        return this.myFunction.getName();
    }

    public List<PyParameterInfo> getParameters() {
        ArrayList<PyParameterInfo> parameterInfos = new ArrayList<PyParameterInfo>();
        PyParameter[] parameters2 = this.myFunction.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PyParameter parameter = parameters2[i];
            PyExpression defaultValue = parameter.getDefaultValue();
            String name = parameter instanceof PyNamedParameter ? (((PyNamedParameter)parameter).isPositionalContainer() ? "*" + parameter.getName() : (((PyNamedParameter)parameter).isKeywordContainer() ? "**" + parameter.getName() : parameter.getName())) : parameter.getText();
            parameterInfos.add(new PyParameterInfo(i, name, defaultValue == null ? null : defaultValue.getText(), defaultValue != null && !StringUtil.isEmptyOrSpaces((String)defaultValue.getText())));
        }
        return parameterInfos;
    }

    public int getParametersCount() {
        return this.myFunction.getParameterList().getParameters().length;
    }

    public String getVisibility() {
        return "";
    }

    public PyFunction getMethod() {
        return this.myFunction;
    }

    public boolean canChangeVisibility() {
        return false;
    }

    public boolean canChangeParameters() {
        return true;
    }

    public boolean canChangeName() {
        return true;
    }

    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        return MethodDescriptor.ReadWriteOption.None;
    }
}

