/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.pipenv.PipEnvInstallQuickFix;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageRequirementsInspection
extends PyInspection {
    public JDOMExternalizableStringList ignoredPackages = new JDOMExternalizableStringList();

    @NotNull
    public String getDisplayName() {
        if ("Package requirements" == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(0);
        }
        return "Package requirements";
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore packages", (List)this.ignoredPackages);
        return form.getContentPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(2);
        }
        if (!(holder.getFile() instanceof PyFile) && !(holder.getFile() instanceof PsiPlainTextFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PyPackageRequirementsInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        Visitor visitor2 = new Visitor(holder, session, (Collection<String>)this.ignoredPackages);
        if (visitor2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(4);
        }
        return visitor2;
    }

    @Nullable
    public static PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(5);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        return (PyPackageRequirementsInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Nullable
    private static Set<PyRequirement> getRequirementsInclTransitive(@NotNull PyPackageManager packageManager, @NotNull Module module2) {
        List<PyRequirement> requirements;
        if (packageManager == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(6);
        }
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(7);
        }
        if ((requirements = PyPackageRequirementsInspection.getListedRequirements(packageManager, module2)) == null) {
            return null;
        }
        if (requirements.isEmpty()) {
            return Collections.emptySet();
        }
        List<PyPackage> packages = packageManager.getPackages();
        if (packages == null) {
            return null;
        }
        HashSet<PyRequirement> result = new HashSet<PyRequirement>(requirements);
        result.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages, requirements, new HashSet<PyPackage>()));
        return result;
    }

    @Nullable
    private static List<PyRequirement> getListedRequirements(@NotNull PyPackageManager packageManager, @NotNull Module module2) {
        if (packageManager == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(8);
        }
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(9);
        }
        List<PyRequirement> requirements = packageManager.getRequirements(module2);
        List<PyRequirement> extrasRequirements = PyPackageRequirementsInspection.getExtrasRequirements(module2);
        if (requirements == null) {
            return extrasRequirements;
        }
        if (extrasRequirements == null) {
            return requirements;
        }
        return ContainerUtil.concat(requirements, extrasRequirements);
    }

    @Nullable
    private static List<PyRequirement> getExtrasRequirements(@NotNull Module module2) {
        Map<String, List<PyRequirement>> extrasRequire;
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(10);
        }
        return (extrasRequire = PyPackageUtil.findSetupPyExtrasRequire(module2)) == null ? null : ContainerUtil.flatten(extrasRequire.values());
    }

    @NotNull
    private static Set<PyRequirement> getTransitiveRequirements(@NotNull List<PyPackage> packages, @NotNull Collection<PyRequirement> requirements, @NotNull Set<PyPackage> visited) {
        if (packages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(11);
        }
        if (requirements == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(12);
        }
        if (visited == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(13);
        }
        HashSet<PyRequirement> result = new HashSet<PyRequirement>();
        for (PyRequirement req : requirements) {
            PyPackage pkg = req.match(packages);
            if (pkg == null || !visited.add(pkg)) continue;
            result.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages, pkg.getRequirements(), visited));
        }
        HashSet<PyRequirement> hashSet = result;
        if (hashSet == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Nullable
    private static List<PyRequirement> findUnsatisfiedRequirements(@NotNull Module module2, @NotNull Sdk sdk, @NotNull Set<String> ignoredPackages) {
        PyPackageManager manager;
        List<PyRequirement> requirements;
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(15);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(16);
        }
        if (ignoredPackages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(17);
        }
        if ((requirements = (manager = PyPackageManager.getInstance(sdk)).getRequirements(module2)) != null) {
            List<PyPackage> packages = manager.getPackages();
            if (packages == null) {
                return null;
            }
            List<PyPackage> packagesInModule = PyPackageRequirementsInspection.collectPackagesInModule(module2);
            ArrayList<PyRequirement> unsatisfied = new ArrayList<PyRequirement>();
            for (PyRequirement req : requirements) {
                if (ignoredPackages.contains(req.getName()) || req.match(packages) != null || req.match(packagesInModule) != null) continue;
                unsatisfied.add(req);
            }
            return unsatisfied;
        }
        return null;
    }

    @NotNull
    private static List<PyPackage> collectPackagesInModule(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(18);
        }
        String[] metadataExtensions = new String[]{"egg-info", "dist-info"};
        SmartList result = new SmartList();
        for (VirtualFile srcRoot : PyUtil.getSourceRoots(module2)) {
            for (VirtualFile metadata : VfsUtil.getChildren((VirtualFile)srcRoot, file -> ArrayUtil.contains((String)file.getExtension(), (String[])metadataExtensions))) {
                String[] nameAndVersionAndRest = metadata.getNameWithoutExtension().split("-", 3);
                if (nameAndVersionAndRest.length < 2) continue;
                result.add(new PyPackage(nameAndVersionAndRest[0], nameAndVersionAndRest[1], null, Collections.emptyList()));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    private static void setRunningPackagingTasks(@NotNull Module module2, boolean value) {
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(20);
        }
        module2.putUserData(PyPackageManager.RUNNING_PACKAGING_TASKS, (Object)value);
    }

    private static boolean isRunningPackagingTasks(@NotNull Module module2) {
        Boolean value;
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(21);
        }
        return (value = (Boolean)module2.getUserData(PyPackageManager.RUNNING_PACKAGING_TASKS)) != null && value != false;
    }

    private static boolean checkAdminPermissionsAndConfigureInterpreter(@NotNull Project project, @NotNull ProblemDescriptor descriptor2, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(22);
        }
        if (descriptor2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(23);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(24);
        }
        if (!PythonSdkType.isRemote(sdk) && PySdkExtKt.adminPermissionsNeeded(sdk)) {
            int answer = PyPackageRequirementsInspection.askToConfigureInterpreter(project, sdk);
            switch (answer) {
                case 0: {
                    new PyInterpreterInspection.ConfigureInterpreterFix().applyFix(project, descriptor2);
                    return true;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private static int askToConfigureInterpreter(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(25);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(26);
        }
        String sdkName = StringUtil.shortenTextWithEllipsis((String)sdk.getName(), (int)25, (int)0);
        String text2 = "Installing packages into '" + sdkName + "' requires administrator privileges.\n\nConfigure a per-project virtual environment as your project interpreter\nto avoid installing packages to a protected area of the file system.";
        String[] options = new String[]{"Configure", "Install Anyway", "Cancel"};
        return Messages.showIdeaMessageDialog((Project)project, (String)text2, (String)"Administrator Privileges Required", (String[])options, (int)0, (Icon)Messages.getWarningIcon(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManager";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 16: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPackages";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveRequirements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackagesInModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsInclTransitive";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getListedRequirements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExtrasRequirements";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTransitiveRequirements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findUnsatisfiedRequirements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagesInModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setRunningPackagingTasks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPackagingTasks";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkAdminPermissionsAndConfigureInterpreter";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "askToConfigureInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final PyPackageManager myPackageManager;
        @NotNull
        private final Module myModule;
        @NotNull
        private final String myPackageName;
        @NotNull
        private final LanguageLevel myLanguageLevel;

        private AddToRequirementsFix(@NotNull PyPackageManager packageManager, @NotNull Module module2, @NotNull String packageName, @NotNull LanguageLevel languageLevel) {
            if (packageManager == null) {
                AddToRequirementsFix.$$$reportNull$$$0(0);
            }
            if (module2 == null) {
                AddToRequirementsFix.$$$reportNull$$$0(1);
            }
            if (packageName == null) {
                AddToRequirementsFix.$$$reportNull$$$0(2);
            }
            if (languageLevel == null) {
                AddToRequirementsFix.$$$reportNull$$$0(3);
            }
            this.myPackageManager = packageManager;
            this.myModule = module2;
            this.myPackageName = packageName;
            this.myLanguageLevel = languageLevel;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = String.format("Add requirement '%s' to %s", this.myPackageName, this.calculateTarget());
            if (string == null) {
                AddToRequirementsFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            List<PyRequirement> requirements;
            if (project == null) {
                AddToRequirementsFix.$$$reportNull$$$0(5);
            }
            if (descriptor2 == null) {
                AddToRequirementsFix.$$$reportNull$$$0(6);
            }
            if ((requirements = this.myPackageManager.getRequirements(this.myModule)) != null && ContainerUtil.exists(requirements, r -> r.getName().equals(this.myPackageName))) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> PyPackageUtil.addRequirementToTxtOrSetupPy(this.myModule, this.myPackageName, this.myLanguageLevel)), this.getName(), null);
        }

        @NotNull
        private String calculateTarget() {
            VirtualFile requirementsTxt = PyPackageUtil.findRequirementsTxt(this.myModule);
            if (requirementsTxt != null) {
                String string = requirementsTxt.getName();
                if (string == null) {
                    AddToRequirementsFix.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (PyPackageUtil.findSetupCall(this.myModule) != null) {
                if ("setup.py" == null) {
                    AddToRequirementsFix.$$$reportNull$$$0(8);
                }
                return "setup.py";
            }
            if ("project requirements" == null) {
                AddToRequirementsFix.$$$reportNull$$$0(9);
            }
            return "project requirements";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreRequirementFix
    implements LocalQuickFix {
        @NotNull
        private final Set<String> myPackageNames;

        IgnoreRequirementFix(@NotNull Set<String> packageNames) {
            if (packageNames == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(0);
            }
            this.myPackageNames = packageNames;
        }

        @NotNull
        public String getFamilyName() {
            boolean plural = this.myPackageNames.size() > 1;
            String string = String.format("Ignore requirement%s", plural ? "s" : "");
            if (string == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyPackageRequirementsInspection inspection;
            PsiElement element;
            if (project == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor2.getPsiElement()) != null && (inspection = PyPackageRequirementsInspection.getInstance(element)) != null) {
                JDOMExternalizableStringList ignoredPackages = inspection.ignoredPackages;
                boolean changed = false;
                for (String name : this.myPackageNames) {
                    if (ignoredPackages.contains((Object)name)) continue;
                    ignoredPackages.add((Object)name);
                    changed = true;
                }
                if (changed) {
                    ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RunningPackagingTasksListener
    implements PyPackageManagerUI.Listener {
        @NotNull
        private final Module myModule;

        public RunningPackagingTasksListener(@NotNull Module module2) {
            if (module2 == null) {
                RunningPackagingTasksListener.$$$reportNull$$$0(0);
            }
            this.myModule = module2;
        }

        @Override
        public void started() {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, true);
        }

        @Override
        public void finished(List<ExecutionException> exceptions) {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$RunningPackagingTasksListener", "<init>"));
        }
    }

    public static class InstallAndImportQuickFix
    implements LocalQuickFix {
        @Nullable
        private final Sdk mySdk;
        @Nullable
        private final Module myModule;
        @NotNull
        private final String myPackageName;
        @Nullable
        private final String myAsName;
        @NotNull
        private final SmartPsiElementPointer<PyElement> myNode;

        public InstallAndImportQuickFix(@NotNull String packageName, @Nullable String asName, @NotNull PyElement node) {
            if (packageName == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(0);
            }
            if (node == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myAsName = asName;
            this.myNode = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node, node.getContainingFile());
            this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            this.mySdk = PythonSdkType.findPythonSdk(this.myModule);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PyBundle.message("QFIX.NAME.install.and.import.package", this.myPackageName);
            if (string == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("QFIX.install.and.import.package", new Object[0]);
            if (string == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(5);
            }
            if (this.mySdk == null || !PyPackageRequirementsInspection.checkAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.mySdk)) {
                this.installAndImportPackage(project);
            }
        }

        private void installAndImportPackage(final @NotNull Project project) {
            if (project == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(6);
            }
            if (this.mySdk == null) {
                return;
            }
            PyPackageManagerUI ui2 = new PyPackageManagerUI(project, this.mySdk, new RunningPackagingTasksListener(this.myModule){

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    if (exceptions.isEmpty()) {
                        PyElement element = (PyElement)myNode.getElement();
                        if (element == null) {
                            return;
                        }
                        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> AddImportHelper.addImportStatement(element.getContainingFile(), myPackageName, myAsName, AddImportHelper.ImportPriority.THIRD_PARTY, (PsiElement)element)), "Add import", (Object)"Add import");
                    }
                }
            });
            ui2.install(Collections.singletonList(PyRequirementsKt.pyRequirement(this.myPackageName)), Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "installAndImportPackage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyInstallRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final String myName;
        @NotNull
        private final Module myModule;
        @NotNull
        private final Sdk mySdk;
        @NotNull
        private final List<PyRequirement> myUnsatisfied;
        @NotNull
        private final List<String> myExtraArgs;
        @Nullable
        private final PyPackageManagerUI.Listener myListener;

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module2, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied) {
            if (module2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(1);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(2);
            }
            this(name, module2, sdk, unsatisfied, Collections.emptyList(), null);
        }

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module2, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied, @NotNull List<String> extraArgs, @Nullable PyPackageManagerUI.Listener listener2) {
            boolean plural;
            if (module2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(3);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(4);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(5);
            }
            if (extraArgs == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(6);
            }
            boolean bl = plural = unsatisfied.size() > 1;
            this.myName = name != null ? name : String.format("Install requirement%s", plural ? "s" : "");
            this.myModule = module2;
            this.mySdk = sdk;
            this.myUnsatisfied = unsatisfied;
            this.myExtraArgs = extraArgs;
            this.myListener = listener2;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(8);
            }
            if (descriptor2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(9);
            }
            if (!PyPackageRequirementsInspection.checkAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.mySdk)) {
                this.installPackages(project);
            }
        }

        private void installPackages(final @NotNull Project project) {
            boolean hasManagement;
            PyChooseRequirementsDialog dialog;
            PyPackageManager manager;
            List<PyPackage> packages;
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(10);
            }
            if ((packages = (manager = PyPackageManager.getInstance(this.mySdk)).getPackages()) == null) {
                return;
            }
            final List<PyRequirement> chosen = this.myUnsatisfied.size() > 1 ? ((dialog = new PyChooseRequirementsDialog(project, this.myUnsatisfied)).showAndGet() ? dialog.getMarkedElements() : Collections.emptyList()) : this.myUnsatisfied;
            if (chosen.isEmpty()) {
                return;
            }
            try {
                hasManagement = manager.hasManagement();
            }
            catch (ExecutionException e) {
                hasManagement = false;
            }
            if (!hasManagement) {
                PyPackageManagerUI ui2 = new PyPackageManagerUI(project, this.mySdk, new RunningPackagingTasksListener(this.myModule){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            this.installRequirements(project, chosen);
                        }
                    }
                });
                ui2.installManagement();
            } else {
                this.installRequirements(project, chosen);
            }
        }

        private void installRequirements(Project project, List<PyRequirement> requirements) {
            RunningPackagingTasksListener listener2 = this.myListener == null ? new RunningPackagingTasksListener(this.myModule) : new RunningPackagingTasksListener(this.myModule){

                @Override
                public void started() {
                    super.started();
                    myListener.started();
                }

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    myListener.finished(exceptions);
                }
            };
            new PyPackageManagerUI(project, this.mySdk, listener2).install(requirements, this.myExtraArgs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unsatisfied";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "installPackages";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredPackages;

        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<String> ignoredPackages) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
            this.myIgnoredPackages = ImmutableSet.copyOf(ignoredPackages);
        }

        @Override
        public void visitPyFile(PyFile node) {
            this.checkPackagesHaveBeenInstalled((PsiElement)node, ModuleUtilCore.findModuleForPsiElement((PsiElement)node));
        }

        public void visitPlainTextFile(PsiPlainTextFile file) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module2 != null && file.getVirtualFile().equals(PyPackageUtil.findRequirementsTxt(module2))) {
                this.checkPackagesHaveBeenInstalled((PsiElement)file, module2);
            }
        }

        private void checkPackagesHaveBeenInstalled(@NotNull PsiElement file, @Nullable Module module2) {
            List unsatisfied;
            Sdk sdk;
            if (file == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (module2 != null && !PyPackageRequirementsInspection.isRunningPackagingTasks(module2) && (sdk = PythonSdkType.findPythonSdk(module2)) != null && (unsatisfied = PyPackageRequirementsInspection.findUnsatisfiedRequirements(module2, sdk, this.myIgnoredPackages)) != null && !unsatisfied.isEmpty()) {
                boolean plural = unsatisfied.size() > 1;
                String msg = String.format("Package requirement%s %s %s not satisfied", plural ? "s" : "", PyPackageUtil.requirementsToString(unsatisfied), plural ? "are" : "is");
                HashSet<String> unsatisfiedNames = new HashSet<String>();
                for (PyRequirement req : unsatisfied) {
                    unsatisfiedNames.add(req.getName() + req.getExtras());
                }
                ArrayList<Object> quickFixes = new ArrayList<Object>();
                if (PipenvKt.isPipEnv(sdk)) {
                    quickFixes.add(new PipEnvInstallQuickFix());
                } else {
                    quickFixes.add(new PyInstallRequirementsFix(null, module2, sdk, unsatisfied));
                }
                quickFixes.add(new IgnoreRequirementFix(unsatisfiedNames));
                this.registerProblem(file, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PyReferenceExpression expr = node.getImportSource();
            if (expr != null) {
                this.checkPackageNameInRequirements(expr);
            }
        }

        @Override
        public void visitPyImportStatement(PyImportStatement node) {
            for (PyImportElement element : node.getImportElements()) {
                PyReferenceExpression expr = element.getImportReferenceExpression();
                if (expr == null) continue;
                this.checkPackageNameInRequirements(expr);
            }
        }

        private void checkPackageNameInRequirements(@NotNull PyQualifiedExpression importedExpression) {
            block18: {
                PsiReference reference;
                if (importedExpression == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
                for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                    if (!extension.ignorePackageNameInRequirements(importedExpression)) continue;
                    return;
                }
                PyExpression packageReferenceExpression = PyPsiUtils.getFirstQualifier(importedExpression);
                String packageName = packageReferenceExpression.getName();
                if (packageName == null || this.myIgnoredPackages.contains(packageName)) break block18;
                List possiblePyPIPackageNames = (List)PyPIPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList());
                if (!ApplicationManager.getApplication().isUnitTestMode() && !PyPIPackageUtil.INSTANCE.isInPyPI(packageName)) {
                    if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, PyPIPackageUtil.INSTANCE::isInPyPI)) {
                        return;
                    }
                }
                if ("setuptools".equals(packageName)) {
                    return;
                }
                Collection<String> stdlibPackages = PyStdlibUtil.getPackages();
                if (stdlibPackages != null && stdlibPackages.contains(packageName)) {
                    return;
                }
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)packageReferenceExpression);
                if (module2 == null) {
                    return;
                }
                Sdk sdk = PythonSdkType.findPythonSdk(module2);
                if (sdk == null) {
                    return;
                }
                PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
                Set requirements = PyPackageRequirementsInspection.getRequirementsInclTransitive(packageManager, module2);
                if (requirements == null) {
                    return;
                }
                for (PyRequirement req : requirements) {
                    String name2;
                    block20: {
                        block19: {
                            name2 = req.getName();
                            if (name2.equalsIgnoreCase(packageName)) break block19;
                            if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, name2::equalsIgnoreCase)) break block20;
                        }
                        return;
                    }
                    String nameWhereUnderscoreReplacedWithHyphen = name2.replaceAll("_", "-");
                    if (ContainerUtil.exists((Iterable)possiblePyPIPackageNames, nameWhereUnderscoreReplacedWithHyphen::equalsIgnoreCase)) {
                        return;
                    }
                    String nameWhereHyphenReplacedWithUnderscore = name2.replaceAll("-", "_");
                    if (!nameWhereHyphenReplacedWithUnderscore.equalsIgnoreCase(packageName)) {
                        if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, nameWhereHyphenReplacedWithUnderscore::equalsIgnoreCase)) continue;
                    }
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && (reference = packageReferenceExpression.getReference()) != null) {
                    VirtualFile virtualFile;
                    PsiFile file;
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiDirectory && ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)((PsiDirectory)element).getVirtualFile(), (boolean)false)) {
                        return;
                    }
                    if (element != null && (file = element.getContainingFile()) != null && ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)(virtualFile = file.getVirtualFile()), (boolean)false)) {
                        return;
                    }
                }
                ArrayList<IgnoreRequirementFix> quickFixes = new ArrayList<IgnoreRequirementFix>();
                ((StreamEx)StreamEx.of((Object)packageName).append((Collection)possiblePyPIPackageNames).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).map(name -> {
                    if (importedExpression == null) {
                        Visitor.$$$reportNull$$$0(3);
                    }
                    return new AddToRequirementsFix(packageManager, module2, (String)name, LanguageLevel.forElement((PsiElement)importedExpression));
                }).forEach(quickFixes::add);
                quickFixes.add(new IgnoreRequirementFix(Collections.singleton(packageName)));
                this.registerProblem((PsiElement)packageReferenceExpression, String.format("Package containing module '%s' is not listed in project requirements", packageName), ProblemHighlightType.WEAK_WARNING, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackagesHaveBeenInstalled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackageNameInRequirements";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$checkPackageNameInRequirements$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

