/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.MessageEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.EditorAdapter;
import org.jetbrains.annotations.NotNull;

public class CvsMessagesConsole
extends CvsMessagesAdapter {
    private EditorAdapter myOutput;
    public static final TextAttributes USER_MESSAGES_ATTRIBUTES = new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 0);
    public static final TextAttributes PROGRESS_MESSAGES_ATTRIBUTES = new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 2);
    public static final TextAttributes COMMAND = new TextAttributes(null, null, null, EffectType.LINE_UNDERSCORE, 1);
    private int lineLimit = 1000;
    private int currentLines = 0;

    public void connectToOutputView(@NotNull Editor editor, Project project) {
        if (editor == null) {
            CvsMessagesConsole.$$$reportNull$$$0(0);
        }
        this.myOutput = new EditorAdapter(editor, project, true);
    }

    @Override
    public void addMessage(MessageEvent event) {
        String message = event.getMessage();
        if (message.isEmpty()) {
            return;
        }
        if (!event.isError() && !event.isTagged()) {
            ++this.currentLines;
            if (this.currentLines > this.lineLimit) {
                return;
            }
        }
        this.appendString(message, CvsMessagesConsole.getAttributesFor(event));
    }

    private void appendString(String message, TextAttributes attributes) {
        if (this.myOutput == null) {
            return;
        }
        this.myOutput.appendString(message, attributes);
    }

    private static TextAttributes getAttributesFor(MessageEvent event) {
        return event.isError() || event.isTagged() ? USER_MESSAGES_ATTRIBUTES : PROGRESS_MESSAGES_ATTRIBUTES;
    }

    @Override
    public void commandStarted(String command) {
        this.lineLimit = Registry.intValue((String)"cvs.server.output.max.lines", (int)1000);
        this.currentLines = 0;
        this.appendString(command, COMMAND);
    }

    @Override
    public void commandFinished(String commandName, long time) {
        if (this.currentLines > this.lineLimit) {
            this.appendString(CvsBundle.message((String)"message.log.truncated", (Object[])new Object[]{this.lineLimit, this.currentLines - this.lineLimit}), PROGRESS_MESSAGES_ATTRIBUTES);
        }
        this.appendString(CvsBundle.message((String)"message.command.finished", (Object[])new Object[]{time / 1000L}), COMMAND);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/cvsSupport2/cvshandlers/CvsMessagesConsole", "connectToOutputView"));
    }
}

