/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.projectView.CustomResourceBundlePropertiesFileNode;
import com.intellij.lang.properties.projectView.ResourceBundleDeleteProvider;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleGrouper
implements TreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(ResourceBundleGrouper.class);
    private final Project myProject;

    public ResourceBundleGrouper(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(1);
        }
        if (parent instanceof ResourceBundleNode) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                ResourceBundleGrouper.$$$reportNull$$$0(2);
            }
            return collection;
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            if (children == null) {
                ResourceBundleGrouper.$$$reportNull$$$0(9);
            }
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            SmartList dirPropertiesFiles = new SmartList();
            for (AbstractTreeNode child : children) {
                PropertiesFile propertiesFile;
                Object f = child.getValue();
                if (f instanceof PsiFile && child.getClass() == PsiFileNode.class && (propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)f)) != null) {
                    dirPropertiesFiles.add(propertiesFile);
                    continue;
                }
                result.add(child);
            }
            if (dirPropertiesFiles.isEmpty()) {
                return result;
            }
            ResourceBundleGrouper.appendPropertiesFilesNodes((List<? extends PropertiesFile>)dirPropertiesFiles, this.myProject, (Consumer<? super AbstractTreeNode>)((Consumer)result::add), settings);
            return result;
        });
        if (collection == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static void appendPropertiesFilesNodes(@NotNull List<? extends PropertiesFile> files, @NotNull Project project, @NotNull Consumer<? super AbstractTreeNode> nodeConsumer, ViewSettings settings) {
        Collection bundleFiles;
        if (files == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(5);
        }
        if (nodeConsumer == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(6);
        }
        ResourceBundleManager manager = ResourceBundleManager.getInstance(project);
        MultiMap resourceBundles = new MultiMap();
        MultiMap customResourceBundles = new MultiMap();
        for (PropertiesFile propertiesFile : files) {
            CustomResourceBundle customResourceBundle = manager.getCustomResourceBundle(propertiesFile);
            if (customResourceBundle != null) {
                customResourceBundles.putValue((Object)customResourceBundle, (Object)propertiesFile);
                continue;
            }
            String extension = propertiesFile.getVirtualFile().getExtension();
            String baseName = manager.getBaseName(propertiesFile.getContainingFile());
            resourceBundles.putValue((Object)Couple.of((Object)baseName, (Object)extension), (Object)propertiesFile);
        }
        for (Map.Entry entry : resourceBundles.entrySet()) {
            bundleFiles = (Collection)entry.getValue();
            PropertiesFile defaultFile = (PropertiesFile)bundleFiles.iterator().next();
            nodeConsumer.consume(bundleFiles.size() == 1 ? new PsiFileNode(project, defaultFile.getContainingFile(), settings) : new ResourceBundleNode(project, new ResourceBundleImpl(defaultFile), settings));
        }
        for (Map.Entry entry : customResourceBundles.entrySet()) {
            bundleFiles = (Collection)entry.getValue();
            if (bundleFiles.size() == 1) {
                PropertiesFile representative = (PropertiesFile)bundleFiles.iterator().next();
                nodeConsumer.consume((Object)new CustomResourceBundlePropertiesFileNode(project, representative.getContainingFile(), settings));
                continue;
            }
            nodeConsumer.consume((Object)new ResourceBundleNode(project, (ResourceBundle)entry.getKey(), settings));
        }
    }

    public Object getData(@NotNull Collection<AbstractTreeNode> selected, @NotNull String dataId) {
        if (selected == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(7);
        }
        if (dataId == null) {
            ResourceBundleGrouper.$$$reportNull$$$0(8);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            for (AbstractTreeNode selectedElement : selected) {
                Object element = selectedElement.getValue();
                if (!(element instanceof ResourceBundle)) continue;
                return new ResourceBundleDeleteProvider();
            }
        } else if (ResourceBundle.ARRAY_DATA_KEY.is(dataId)) {
            ArrayList<ResourceBundle> selectedElements = new ArrayList<ResourceBundle>();
            for (AbstractTreeNode node : selected) {
                Object value = node.getValue();
                if (!(value instanceof ResourceBundle)) continue;
                selectedElements.add((ResourceBundle)value);
            }
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ResourceBundle[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/projectView/ResourceBundleGrouper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeConsumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/projectView/ResourceBundleGrouper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendPropertiesFilesNodes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modify$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

